/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ConversionTaskState;
import com.amazonaws.services.ec2.model.ImportInstanceTaskDetails;
import com.amazonaws.services.ec2.model.ImportVolumeTaskDetails;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ConversionTask
implements Serializable,
Cloneable {
    private String conversionTaskId;
    private String expirationTime;
    private ImportInstanceTaskDetails importInstance;
    private ImportVolumeTaskDetails importVolume;
    private String state;
    private String statusMessage;
    private SdkInternalList<Tag> tags;

    public void setConversionTaskId(String conversionTaskId) {
        this.conversionTaskId = conversionTaskId;
    }

    public String getConversionTaskId() {
        return this.conversionTaskId;
    }

    public ConversionTask withConversionTaskId(String conversionTaskId) {
        this.setConversionTaskId(conversionTaskId);
        return this;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public ConversionTask withExpirationTime(String expirationTime) {
        this.setExpirationTime(expirationTime);
        return this;
    }

    public void setImportInstance(ImportInstanceTaskDetails importInstance) {
        this.importInstance = importInstance;
    }

    public ImportInstanceTaskDetails getImportInstance() {
        return this.importInstance;
    }

    public ConversionTask withImportInstance(ImportInstanceTaskDetails importInstance) {
        this.setImportInstance(importInstance);
        return this;
    }

    public void setImportVolume(ImportVolumeTaskDetails importVolume) {
        this.importVolume = importVolume;
    }

    public ImportVolumeTaskDetails getImportVolume() {
        return this.importVolume;
    }

    public ConversionTask withImportVolume(ImportVolumeTaskDetails importVolume) {
        this.setImportVolume(importVolume);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public ConversionTask withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(ConversionTaskState state) {
        this.state = state.toString();
    }

    public ConversionTask withState(ConversionTaskState state) {
        this.setState(state);
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public ConversionTask withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public ConversionTask withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public ConversionTask withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConversionTaskId() != null) {
            sb.append("ConversionTaskId: ").append(this.getConversionTaskId()).append(",");
        }
        if (this.getExpirationTime() != null) {
            sb.append("ExpirationTime: ").append(this.getExpirationTime()).append(",");
        }
        if (this.getImportInstance() != null) {
            sb.append("ImportInstance: ").append(this.getImportInstance()).append(",");
        }
        if (this.getImportVolume() != null) {
            sb.append("ImportVolume: ").append(this.getImportVolume()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionTask)) {
            return false;
        }
        ConversionTask other = (ConversionTask)obj;
        if (other.getConversionTaskId() == null ^ this.getConversionTaskId() == null) {
            return false;
        }
        if (other.getConversionTaskId() != null && !other.getConversionTaskId().equals(this.getConversionTaskId())) {
            return false;
        }
        if (other.getExpirationTime() == null ^ this.getExpirationTime() == null) {
            return false;
        }
        if (other.getExpirationTime() != null && !other.getExpirationTime().equals(this.getExpirationTime())) {
            return false;
        }
        if (other.getImportInstance() == null ^ this.getImportInstance() == null) {
            return false;
        }
        if (other.getImportInstance() != null && !other.getImportInstance().equals(this.getImportInstance())) {
            return false;
        }
        if (other.getImportVolume() == null ^ this.getImportVolume() == null) {
            return false;
        }
        if (other.getImportVolume() != null && !other.getImportVolume().equals(this.getImportVolume())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConversionTaskId() == null ? 0 : this.getConversionTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationTime() == null ? 0 : this.getExpirationTime().hashCode());
        hashCode = 31 * hashCode + (this.getImportInstance() == null ? 0 : this.getImportInstance().hashCode());
        hashCode = 31 * hashCode + (this.getImportVolume() == null ? 0 : this.getImportVolume().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ConversionTask clone() {
        try {
            return (ConversionTask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

