/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.ImportKeyPairRequestMarshaller;
import java.io.Serializable;

public class ImportKeyPairRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ImportKeyPairRequest> {
    private String keyName;
    private String publicKeyMaterial;

    public ImportKeyPairRequest() {
    }

    public ImportKeyPairRequest(String keyName, String publicKeyMaterial) {
        this.setKeyName(keyName);
        this.setPublicKeyMaterial(publicKeyMaterial);
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public ImportKeyPairRequest withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public void setPublicKeyMaterial(String publicKeyMaterial) {
        this.publicKeyMaterial = publicKeyMaterial;
    }

    public String getPublicKeyMaterial() {
        return this.publicKeyMaterial;
    }

    public ImportKeyPairRequest withPublicKeyMaterial(String publicKeyMaterial) {
        this.setPublicKeyMaterial(publicKeyMaterial);
        return this;
    }

    @Override
    public Request<ImportKeyPairRequest> getDryRunRequest() {
        Request<ImportKeyPairRequest> request = new ImportKeyPairRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getPublicKeyMaterial() != null) {
            sb.append("PublicKeyMaterial: ").append(this.getPublicKeyMaterial());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest)obj;
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getPublicKeyMaterial() == null ^ this.getPublicKeyMaterial() == null) {
            return false;
        }
        return other.getPublicKeyMaterial() == null || other.getPublicKeyMaterial().equals(this.getPublicKeyMaterial());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getPublicKeyMaterial() == null ? 0 : this.getPublicKeyMaterial().hashCode());
        return hashCode;
    }

    public ImportKeyPairRequest clone() {
        return (ImportKeyPairRequest)super.clone();
    }
}

