/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jca;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Stack;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.xa.XAResource;

public class JcaTransactionalResource
extends XATransactionalResource {
    private static final Logger LOGGER = LoggerFactory.createLogger(JcaTransactionalResource.class);
    private ManagedConnectionFactory mcf;
    private ManagedConnection connection;

    public JcaTransactionalResource(String servername, ManagedConnectionFactory mcf) {
        super(servername);
        this.mcf = mcf;
    }

    public JcaTransactionalResource(String servername, ManagedConnectionFactory mcf, XidFactory xidFactory) {
        super(servername, xidFactory);
        this.mcf = mcf;
    }

    @Override
    public boolean usesXAResource(XAResource xares) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected XAResource refreshXAConnection() throws ResourceException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("refreshXAConnection() for resource: " + this.getName());
        }
        XAResource ret = null;
        if (this.connection != null) {
            try {
                this.connection.destroy();
            }
            catch (Exception normal) {
                // empty catch block
            }
        }
        try {
            LOGGER.logInfo("about to block for new connection...");
            this.connection = this.mcf.createManagedConnection(null, null);
        }
        catch (javax.resource.ResourceException e) {
            this.connection = null;
        }
        finally {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("blocking done.");
            }
        }
        try {
            if (this.connection != null) {
                ret = this.connection.getXAResource();
            }
        }
        catch (javax.resource.ResourceException e) {
            LOGGER.logWarning("error getting XAResource: " + e.getMessage());
            Stack<javax.resource.ResourceException> errors = new Stack<javax.resource.ResourceException>();
            errors.push(e);
            throw new ResourceException("Error in getting XA resource", errors);
        }
        LOGGER.logInfo("refreshXAConnection() done.");
        return ret;
    }

    @Override
    public void close() throws ResourceException {
        super.close();
        try {
            if (this.connection != null) {
                this.connection.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

