/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.persistence.LogException;
import com.atomikos.persistence.LogStream;
import com.atomikos.persistence.ObjectLog;
import com.atomikos.persistence.Recoverable;
import com.atomikos.persistence.imp.SystemLogImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class StreamObjectLog
implements ObjectLog {
    protected LogStream logstream_;
    protected Hashtable logTable_;
    protected long size_;
    private boolean initialized_ = false;
    protected boolean panic_ = false;
    private long count_;
    private long maxCount_;

    private StreamObjectLog() {
    }

    public StreamObjectLog(LogStream logstream, long checkpointInterval) {
        this.logstream_ = logstream;
        this.size_ = 0L;
        this.logTable_ = new Hashtable();
        this.maxCount_ = checkpointInterval;
        this.count_ = 0L;
    }

    private synchronized void writeCheckpoint() throws LogException {
        ++this.count_;
        if (this.count_ >= this.maxCount_) {
            this.logstream_.writeCheckpoint(this.logTable_.elements());
            this.count_ = 0L;
        }
    }

    public synchronized void init() throws LogException {
        Stack<Exception> errors = new Stack<Exception>();
        Vector recovered = null;
        if (this.initialized_) {
            return;
        }
        try {
            recovered = this.logstream_.recover();
            if (recovered != null) {
                Enumeration entries = recovered.elements();
                while (entries.hasMoreElements()) {
                    SystemLogImage entry = (SystemLogImage)entries.nextElement();
                    if (entry.getId() == null) continue;
                    if (!entry.isForgettable()) {
                        if (!this.logTable_.containsKey(entry.getId())) {
                            ++this.size_;
                        }
                        this.logTable_.put(entry.getId(), entry);
                        continue;
                    }
                    if (!this.logTable_.containsKey(entry.getId())) continue;
                    this.logTable_.remove(entry.getId());
                    --this.size_;
                }
            }
        }
        catch (LogException le) {
            throw le;
        }
        catch (Exception e) {
            errors.push(e);
            throw new LogException(e.getMessage(), errors);
        }
        finally {
            this.initialized_ = true;
        }
        this.logstream_.writeCheckpoint(this.logTable_.elements());
    }

    public synchronized Vector recover() throws LogException {
        Stack errors = new Stack();
        Vector<Recoverable> hist = new Vector<Recoverable>();
        if (!this.initialized_) {
            throw new LogException("Not initialized");
        }
        Enumeration enumm = this.logTable_.elements();
        while (enumm.hasMoreElements()) {
            SystemLogImage next = (SystemLogImage)enumm.nextElement();
            hist.addElement(next.getObjectImage().restore());
        }
        return hist;
    }

    public synchronized void flush(Recoverable rec) throws LogException {
        if (rec == null) {
            return;
        }
        SystemLogImage simg = new SystemLogImage(rec, false);
        this.flush(simg, true);
    }

    protected synchronized void flush(SystemLogImage img, boolean shouldSync) throws LogException {
        Stack<Exception> errors = new Stack<Exception>();
        if (img == null) {
            return;
        }
        if (this.panic_) {
            throw new LogException("StreamObjectLog: PANIC");
        }
        try {
            try {
                this.logstream_.flushObject(img, shouldSync);
                this.writeCheckpoint();
            }
            catch (LogException ioerr) {
                ioerr.printStackTrace();
                errors.push(ioerr);
                try {
                    this.logstream_.writeCheckpoint(this.logTable_.elements());
                }
                catch (Exception e) {
                    errors.push(e);
                }
                throw new LogException(ioerr.getMessage(), errors);
            }
            if (img.isForgettable()) {
                if (this.logTable_.containsKey(img.getId())) {
                    this.logTable_.remove(img.getId());
                    --this.size_;
                }
            } else {
                if (!this.logTable_.containsKey(img.getId())) {
                    ++this.size_;
                }
                this.logTable_.put(img.getId(), img);
            }
        }
        catch (LogException le) {
            System.err.println("Error in StreamObjectLog.flush() " + le.getMessage());
            throw le;
        }
        catch (Exception e) {
            System.err.println("Error in StreamObjectLog.flush() " + e.getMessage());
            errors.push(e);
            throw new LogException(e.getMessage(), errors);
        }
    }

    public synchronized Recoverable recover(Object id) throws LogException {
        if (!this.logTable_.containsKey(id)) {
            return null;
        }
        SystemLogImage simg = (SystemLogImage)this.logTable_.get(id);
        return simg.getObjectImage().restore();
    }

    public synchronized void delete(Object id) throws LogException {
        SystemLogImage previous = (SystemLogImage)this.logTable_.get(id);
        if (previous == null) {
            return;
        }
        Recoverable bogus = previous.getRecoverable();
        SystemLogImage simg = new SystemLogImage(bogus, true);
        this.flush(simg, false);
    }

    public synchronized void close() throws LogException {
        Stack<Exception> errors = new Stack<Exception>();
        try {
            if (this.logstream_ != null) {
                this.logstream_.close();
            }
            this.initialized_ = false;
        }
        catch (LogException le) {
            throw le;
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.push(e);
            throw new LogException(e.getMessage(), errors);
        }
    }
}

