/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.Bucket;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.RateLimitReachedException;
import com.google.common.annotations.VisibleForTesting;

public class RateLimitedJwkProvider
implements JwkProvider {
    private final JwkProvider provider;
    private final Bucket bucket;

    public RateLimitedJwkProvider(JwkProvider provider, Bucket bucket) {
        this.provider = provider;
        this.bucket = bucket;
    }

    @Override
    public Jwk get(String keyId) throws JwkException {
        if (!this.bucket.consume()) {
            throw new RateLimitReachedException(this.bucket.willLeakIn());
        }
        return this.provider.get(keyId);
    }

    @VisibleForTesting
    JwkProvider getBaseProvider() {
        return this.provider;
    }
}

