/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.code.FieldCode;
import com.baidu.bjf.remoting.protobuf.code.MethodCode;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassCode {
    public static final String LINE_BREAK = "\n";
    public static final String JAVA_END = ";";
    public static final String JAVA_LINE_BREAK = ";\n";
    public static final String PACKAGE_SPLIT = ".";
    public static final String SENTENCE_COMMA = ",";
    public static final String BLANK_STRING = " ";
    public static final String KEY_CLASS = "class";
    public static final String SCOPE_PUBLIC = "public";
    public static final String SCOPE_PROTECTED = "protected";
    public static final String SCOPE_DEFAULT = "private";
    public static final String CODE_FORMAT = "    ";
    private Set<String> imports = new HashSet<String>();
    private String pkg;
    private String className;
    private Set<String> interfaces = new HashSet<String>();
    private Set<String> extendClasses = new HashSet<String>();
    private Map<String, FieldCode> fields = new HashMap<String, FieldCode>();
    private List<MethodCode> methods = new ArrayList<MethodCode>();
    private String scope;

    public void addField(String scope, String type, String name, String defaultValue) {
        this.fields.put(name, new FieldCode(scope, name, type, defaultValue));
    }

    public ClassCode(String scope, String name, Set<String> interfaces, Set<String> extendClasses) {
        this(scope, name);
        interfaces = extendClasses;
        extendClasses = interfaces;
    }

    public ClassCode(String scope, String name) {
        this.scope = scope;
        this.className = name;
    }

    public String toCode() {
        Iterator<String> iter;
        StringBuilder code = new StringBuilder();
        if (!StringUtils.isEmpty(this.pkg)) {
            code.append("package ").append(this.pkg).append(JAVA_LINE_BREAK);
        }
        for (String importClass : this.imports) {
            code.append("import ").append(importClass).append(JAVA_LINE_BREAK);
        }
        code.append(this.scope).append(" class ").append(this.className);
        if (!this.interfaces.isEmpty()) {
            code.append(" implements ");
            iter = this.interfaces.iterator();
            while (iter.hasNext()) {
                code.append(iter.next());
                if (!iter.hasNext()) continue;
                code.append(SENTENCE_COMMA);
            }
        }
        if (!this.extendClasses.isEmpty()) {
            code.append(" extends ");
            iter = this.extendClasses.iterator();
            while (iter.hasNext()) {
                code.append(iter.next());
                if (!iter.hasNext()) continue;
                code.append(SENTENCE_COMMA);
            }
        }
        code.append("{").append(LINE_BREAK);
        for (FieldCode field : this.fields.values()) {
            code.append(CODE_FORMAT).append(field.toCode()).append(JAVA_LINE_BREAK);
        }
        for (MethodCode mc : this.methods) {
            code.append(CODE_FORMAT).append(mc.toCode()).append(LINE_BREAK);
        }
        code.append("}");
        return code.toString();
    }

    public void importClass(String importClass) {
        if (StringUtils.isEmpty(importClass)) {
            return;
        }
        this.imports.add(importClass);
    }

    public ClassCode addMethod(MethodCode mc) {
        if (mc != null) {
            this.methods.add(mc);
        }
        return this;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addInteface(String intf) {
        this.interfaces.add(intf);
    }

    public void addExtendClass(String cls) {
        this.extendClasses.add(cls);
    }
}

