/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils;

import com.baidu.bjf.remoting.protobuf.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class FieldInfo {
    private Field field;
    boolean required;
    private String description;
    int order;
    private Class<?> genericKeyType;
    private Class<?> genericeValueType;
    FieldType fieldType;
    private boolean isList;
    private boolean isMap;

    private void checkListMapType(Field field) {
        ParameterizedType ptype;
        Type[] actualTypeArguments;
        Class<?> cls = field.getType();
        boolean needCheckGenericType = false;
        if (List.class.isAssignableFrom(cls)) {
            this.isList = true;
            needCheckGenericType = true;
        }
        if (Map.class.isAssignableFrom(cls)) {
            this.isMap = true;
            needCheckGenericType = true;
        }
        if (!needCheckGenericType) {
            return;
        }
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (actualTypeArguments = (ptype = (ParameterizedType)type).getActualTypeArguments()) != null) {
            Type targetType;
            int length = actualTypeArguments.length;
            if (this.isList) {
                if (length != 1) {
                    throw new RuntimeException("List must use generic definiation like List<String>, please check  field name '" + field.getName() + " at class " + field.getDeclaringClass().getName());
                }
            } else if (this.isMap && length != 2) {
                throw new RuntimeException("Map must use generic definiation like Map<String, String>, please check  field name '" + field.getName() + " at class " + field.getDeclaringClass().getName());
            }
            if ((targetType = actualTypeArguments[0]) instanceof Class) {
                this.genericKeyType = (Class)targetType;
            }
            if (actualTypeArguments.length > 1 && (targetType = actualTypeArguments[1]) instanceof Class) {
                this.genericeValueType = (Class)targetType;
            }
        }
    }

    public FieldInfo(Field field) {
        this.field = field;
        this.checkListMapType(field);
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public void setMap(boolean isMap) {
        this.isMap = isMap;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.trim().length() != 0;
    }

    public Class<?> getGenericKeyType() {
        return this.genericKeyType;
    }

    public void setGenericKeyType(Class<?> genericKeyType) {
        this.genericKeyType = genericKeyType;
    }

    public Class<?> getGenericeValueType() {
        return this.genericeValueType;
    }

    public void setGenericeValueType(Class<?> genericeValueType) {
        this.genericeValueType = genericeValueType;
    }
}

