/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.http;

import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.ErrorCode;
import com.baidubce.http.RetryPolicy;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRetryPolicy
implements RetryPolicy {
    private static Logger logger = LoggerFactory.getLogger(DefaultRetryPolicy.class);
    private static final int SCALE_FACTOR = 300;
    private int maxErrorRetry;
    private long maxDelayInMillis;

    public DefaultRetryPolicy() {
        this(3, 20000L);
    }

    public DefaultRetryPolicy(int maxErrorRetry, long maxDelayInMillis) {
        Preconditions.checkArgument((maxErrorRetry >= 0 ? 1 : 0) != 0, (Object)"maxErrorRetry should be a non-negative.");
        Preconditions.checkArgument((maxDelayInMillis >= 0L ? 1 : 0) != 0, (Object)"maxDelayInMillis should be a non-negative.");
        this.maxErrorRetry = maxErrorRetry;
        this.maxDelayInMillis = maxDelayInMillis;
    }

    @Override
    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    @Override
    public long getMaxDelayInMillis() {
        return this.maxDelayInMillis;
    }

    @Override
    public long getDelayBeforeNextRetryInMillis(BceClientException exception, int retriesAttempted) {
        if (!this.shouldRetry(exception, retriesAttempted)) {
            return -1L;
        }
        if (retriesAttempted < 0) {
            return 0L;
        }
        return (1 << retriesAttempted + 1) * 300;
    }

    protected boolean shouldRetry(BceClientException exception, int retriesAttempted) {
        if (exception.getCause() instanceof IOException) {
            logger.debug("Retry for IOException.");
            return true;
        }
        if (exception instanceof BceServiceException) {
            BceServiceException e = (BceServiceException)exception;
            if (e.getStatusCode() == 500) {
                logger.debug("Retry for internal server error.");
                return true;
            }
            if (e.getStatusCode() == 502) {
                logger.debug("Retry for bad gateway.");
                return true;
            }
            if (e.getStatusCode() == 503) {
                logger.debug("Retry for service unavailable.");
                return true;
            }
            String errorCode = e.getErrorCode();
            if (ErrorCode.REQUEST_EXPIRED.equals(errorCode)) {
                logger.debug("Retry for request expired.");
                return true;
            }
        }
        return false;
    }
}

