/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bcd;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bcd.BcdClientConfiguration;
import com.baidubce.services.bcd.model.AddDomainResolveRequest;
import com.baidubce.services.bcd.model.AuditTemplateInfoRequest;
import com.baidubce.services.bcd.model.ChangeDnsRequest;
import com.baidubce.services.bcd.model.CheckOrderRequest;
import com.baidubce.services.bcd.model.CheckOrderResponse;
import com.baidubce.services.bcd.model.DeleteDomainResolveRequest;
import com.baidubce.services.bcd.model.DeleteTemplateInfoRequest;
import com.baidubce.services.bcd.model.DomainOrderResponse;
import com.baidubce.services.bcd.model.GetDomainAuditRequest;
import com.baidubce.services.bcd.model.GetDomainAuditResponse;
import com.baidubce.services.bcd.model.GetDomainDetailRequest;
import com.baidubce.services.bcd.model.GetDomainDetailResponse;
import com.baidubce.services.bcd.model.GetDomainPriceRequest;
import com.baidubce.services.bcd.model.GetDomainPriceResponse;
import com.baidubce.services.bcd.model.GetTemplateInfoRequest;
import com.baidubce.services.bcd.model.GetTemplateInfoResponse;
import com.baidubce.services.bcd.model.ListDomainResolveRequest;
import com.baidubce.services.bcd.model.ListDomainResolveResponse;
import com.baidubce.services.bcd.model.ListTemplateInfoRequest;
import com.baidubce.services.bcd.model.ListTemplateInfoResponse;
import com.baidubce.services.bcd.model.ModifyTemplateInfoRequest;
import com.baidubce.services.bcd.model.ModifyTemplateInfoResponse;
import com.baidubce.services.bcd.model.OrderPageListRequest;
import com.baidubce.services.bcd.model.PageListRequest;
import com.baidubce.services.bcd.model.RegisterDomainRequest;
import com.baidubce.services.bcd.model.RegisterDomainResponse;
import com.baidubce.services.bcd.model.RenewDomainRequest;
import com.baidubce.services.bcd.model.RenewDomainResponse;
import com.baidubce.services.bcd.model.SearchDomainRequest;
import com.baidubce.services.bcd.model.SearchDomainResponse;
import com.baidubce.services.bcd.model.TemplateRegisterDomainRequest;
import com.baidubce.services.bcd.model.TemplateUpdateOwnerRequest;
import com.baidubce.services.bcd.model.UpdateContactRequest;
import com.baidubce.services.bcd.model.UpdateDomainResolveRequest;
import com.baidubce.services.bcd.model.UpdateOwnerRequest;
import com.baidubce.services.bcd.model.UploadAuditDataRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class BcdClient
extends AbstractBceClient {
    private static final String VERSION_ONE = "v1";
    private static final String VERSION_TWO = "v2";
    private static final String TEMPLATE_URI_PREFIX = "/contact/template";
    private static final String DOMAIN_RESOLVE_URI_PREFIX = "/domain/resolve";
    private static final String RESOLVE_ADD = "/add";
    private static final String RESOLVE_DELETE = "/delete";
    private static final String RESOLVE_EDIT = "/edit";
    private static final String RESOLVE_LIST = "/list";
    private static final String DOMAIN_AUDIT = "/domain/audit";
    private static final String OWNER_EDIT = "/domain/owner/edit";
    private static final String CONTACT_EDIT = "/domain/contact/edit";
    private static final String CONTACT_EDIT_SUFFIX = "/contact";
    private static final String CHANGE_DNS = "/domain/changeDns";
    private static final String DOMAIN_DETAIL = "/domain/detail";
    private static final String DOMAIN_API_PREFIX = "/domain";
    private static final String DOMAIN_SEARCH = "/domain/search";
    private static final String DOMAIN_PRICE = "/domain/price";
    private static final String DOMAIN_REGISTER = "/domain/register";
    private static final String DOMAIN_TEMPLATE_REGISTER = "/domain/registerByTemplate";
    private static final String DOMAIN_ASYNC_REGISTER = "/domain/register_async";
    private static final String DOMAIN_ASYNC_TEMPLATE_REGISTER = "/domain/register_asyncByTemplate";
    private static final String DOMAIN_RENEW = "/domain/renew";
    private static final String DOMAIN_ASYNC_RENEW = "/domain/renew_async";
    private static final String CHECK_DOMAIN_ORDER = "/order/check";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] BCD_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BcdClient() {
        this(new BcdClientConfiguration());
    }

    public BcdClient(BcdClientConfiguration clientConfiguration) {
        super(clientConfiguration, BCD_HANDLERS);
    }

    public ListTemplateInfoResponse listTemplateInfo(ListTemplateInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_TWO, TEMPLATE_URI_PREFIX);
        this.addOrderPageListParamIfNotNull(request, internalRequest);
        this.addParamsIfNotNull("userType", request.getUserType(), internalRequest);
        this.addParamsIfNotNull("email", request.getEmail(), internalRequest);
        return this.invokeHttpClient(internalRequest, ListTemplateInfoResponse.class);
    }

    public ModifyTemplateInfoResponse addTemplateInfo(ModifyTemplateInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_TWO, TEMPLATE_URI_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ModifyTemplateInfoResponse.class);
    }

    public GetTemplateInfoResponse getTemplateInfo(GetTemplateInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_TWO, TEMPLATE_URI_PREFIX, request.getTemplateId());
        return this.invokeHttpClient(internalRequest, GetTemplateInfoResponse.class);
    }

    public void deleteTemplateInfo(DeleteTemplateInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VERSION_TWO, TEMPLATE_URI_PREFIX, request.getTemplateId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateTemplateInfo(ModifyTemplateInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VERSION_TWO, TEMPLATE_URI_PREFIX, request.getTemplateId());
        internalRequest.addParameter("update", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void auditTemplateInfo(AuditTemplateInfoRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VERSION_TWO, TEMPLATE_URI_PREFIX, request.getTemplateId());
        internalRequest.addParameter("audit", null);
        this.fillPayload(internalRequest, request.getAuditInfo());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void addDomainResolve(AddDomainResolveRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDomain(), StringFormatUtils.checkEmptyExceptionMessageFormat("domain"));
        Validate.checkStringNotEmpty(request.getView(), StringFormatUtils.checkEmptyExceptionMessageFormat("view"));
        Validate.checkStringNotEmpty(request.getRdType(), StringFormatUtils.checkEmptyExceptionMessageFormat("rdType"));
        Preconditions.checkArgument((request.getTtl() >= 60 && request.getTtl() <= 3600 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("ttl"));
        Validate.checkStringNotEmpty(request.getRdata(), StringFormatUtils.checkEmptyExceptionMessageFormat("rdata"));
        Validate.checkStringNotEmpty(request.getZoneName(), StringFormatUtils.checkEmptyExceptionMessageFormat("zoneName"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_RESOLVE_URI_PREFIX, RESOLVE_ADD);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteDomainResolve(DeleteDomainResolveRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getRecordId(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("recordId"));
        Validate.checkStringNotEmpty(request.getZoneName(), StringFormatUtils.checkEmptyExceptionMessageFormat("zoneName"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_RESOLVE_URI_PREFIX, RESOLVE_DELETE);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateDomainResolve(UpdateDomainResolveRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getDomain(), StringFormatUtils.checkEmptyExceptionMessageFormat("domain"));
        Validate.checkStringNotEmpty(request.getView(), StringFormatUtils.checkEmptyExceptionMessageFormat("view"));
        Validate.checkStringNotEmpty(request.getRdType(), StringFormatUtils.checkEmptyExceptionMessageFormat("rdType"));
        Preconditions.checkArgument((request.getTtl() >= 60 && request.getTtl() <= 3600 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("ttl"));
        Validate.checkStringNotEmpty(request.getRdata(), StringFormatUtils.checkEmptyExceptionMessageFormat("rdata"));
        Validate.checkStringNotEmpty(request.getZoneName(), StringFormatUtils.checkEmptyExceptionMessageFormat("zoneName"));
        Preconditions.checkNotNull((Object)request.getRecordId(), (Object)StringFormatUtils.checkEmptyExceptionMessageFormat("recordId"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_RESOLVE_URI_PREFIX, RESOLVE_EDIT);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListDomainResolveResponse listDomainResolve(ListDomainResolveRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_RESOLVE_URI_PREFIX, RESOLVE_LIST);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ListDomainResolveResponse.class);
    }

    public void updateOwner(UpdateOwnerRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, OWNER_EDIT);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateOwnerByTemplate(TemplateUpdateOwnerRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getDomain(), (Object)"param domain should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VERSION_TWO, DOMAIN_API_PREFIX, request.getDomain(), CONTACT_EDIT_SUFFIX);
        internalRequest.addParameter("update", "");
        this.addParamsIfNotNull("templateId", request.getTemplateId(), internalRequest);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateContact(UpdateContactRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, CONTACT_EDIT);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetDomainAuditResponse getDomainAudit(GetDomainAuditRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)request.getDomain()), (Object)"domain should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_ONE, DOMAIN_AUDIT);
        internalRequest.addParameter("domain", request.getDomain());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, GetDomainAuditResponse.class);
    }

    public void changeDns(ChangeDnsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, CHANGE_DNS);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetDomainDetailResponse getDomainDetail(GetDomainDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_ONE, DOMAIN_DETAIL);
        internalRequest.addParameter("domain", request.getDomain());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, GetDomainDetailResponse.class);
    }

    public void uploadAudit(UploadAuditDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_AUDIT);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public SearchDomainResponse searchDomain(SearchDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_ONE, DOMAIN_SEARCH);
        this.addParamsIfNotNull("domain", request.getDomain(), internalRequest);
        return this.invokeHttpClient(internalRequest, SearchDomainResponse.class);
    }

    public GetDomainPriceResponse getDomainPrice(GetDomainPriceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_ONE, DOMAIN_PRICE);
        this.addParamsIfNotNull("domain", request.getDomain(), internalRequest);
        return this.invokeHttpClient(internalRequest, GetDomainPriceResponse.class);
    }

    public RegisterDomainResponse registerDomain(RegisterDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_REGISTER);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RegisterDomainResponse.class);
    }

    public DomainOrderResponse asyncRegisterDomain(RegisterDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_ASYNC_REGISTER);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DomainOrderResponse.class);
    }

    public RegisterDomainResponse registerDomainByTemplate(TemplateRegisterDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_TEMPLATE_REGISTER);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RegisterDomainResponse.class);
    }

    public DomainOrderResponse asyncRegisterDomainByTemplate(TemplateRegisterDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_ASYNC_TEMPLATE_REGISTER);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DomainOrderResponse.class);
    }

    public CheckOrderResponse checkOrderStatus(CheckOrderRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_ONE, CHECK_DOMAIN_ORDER);
        this.addParamsIfNotNull("bceOrderId", request.getBceOrderId(), internalRequest);
        return this.invokeHttpClient(internalRequest, CheckOrderResponse.class);
    }

    public RenewDomainResponse renewDomain(RenewDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_RENEW);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RenewDomainResponse.class);
    }

    public DomainOrderResponse asyncRenewDomain(RenewDomainRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_ONE, DOMAIN_ASYNC_RENEW);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, DomainOrderResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String version, String ... pathVariables) {
        ArrayList path = Lists.newArrayList();
        path.add(version);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private void addOrderPageListParamIfNotNull(OrderPageListRequest request, InternalRequest internalRequest) {
        this.addPageListParamIfNotNull(request, internalRequest);
        this.addParamsIfNotNull("order", request.getOrder(), internalRequest);
        this.addParamsIfNotNull("orderBy", request.getOrderBy(), internalRequest);
    }

    private void addPageListParamIfNotNull(PageListRequest request, InternalRequest internalRequest) {
        this.addParamsIfNotNull("pageNo", request.getPageNo(), internalRequest);
        this.addParamsIfNotNull("pageSize", request.getPageSize(), internalRequest);
    }

    private void addParamsIfNotNull(String name, Object value, InternalRequest internalRequest) {
        if (value == null) {
            return;
        }
        internalRequest.addParameter(name, value.toString());
    }
}

