/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.demo;

import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.CompleteMultipartUploadRequest;
import com.baidubce.services.bos.model.CompleteMultipartUploadResponse;
import com.baidubce.services.bos.model.CopyObjectRequest;
import com.baidubce.services.bos.model.CopyObjectResponse;
import com.baidubce.services.bos.model.InitiateMultipartUploadRequest;
import com.baidubce.services.bos.model.InitiateMultipartUploadResponse;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.bos.model.PartETag;
import com.baidubce.services.bos.model.UploadPartCopyRequest;
import com.baidubce.services.bos.model.UploadPartCopyResponse;
import java.util.ArrayList;
import java.util.HashMap;

public class CopyObjectDemo {
    public static void copyObjectSimple() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest("srcBucketName", "srcKey", "destBucketName", "destKey");
        HashMap<String, String> userMetadata = new HashMap<String, String>();
        userMetadata.put("user-meta-key", "user-meta-value");
        ObjectMetadata meta = new ObjectMetadata();
        meta.setUserMetadata(userMetadata);
        copyObjectRequest.setNewObjectMetadata(meta);
        CopyObjectResponse copyObjectResponse = client.copyObject(copyObjectRequest);
        System.out.println("ETag: " + copyObjectResponse.getETag() + " LastModified: " + copyObjectResponse.getLastModified());
        client.shutdown();
    }

    public static void copyObjectMultipart() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest("targetBucketName", "targetObjectName");
        InitiateMultipartUploadResponse initiateMultipartUploadResponse = client.initiateMultipartUpload(initiateMultipartUploadRequest);
        long left_size = client.getObjectMetadata("sourceBucketName", "sourceObjectName").getContentLength();
        long skipBytes = 0L;
        int partNumber = 1;
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        while (left_size > 0L) {
            long partSize = 0x100000L;
            if (left_size < partSize) {
                partSize = left_size;
            }
            UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest();
            uploadPartCopyRequest.setBucketName("targetBucketName");
            uploadPartCopyRequest.setKey("targetObjectName");
            uploadPartCopyRequest.setSourceBucketName("sourceBucketName");
            uploadPartCopyRequest.setSourceKey("sourceObjectName");
            uploadPartCopyRequest.setUploadId(initiateMultipartUploadResponse.getUploadId());
            uploadPartCopyRequest.setPartSize(partSize);
            uploadPartCopyRequest.setOffSet(skipBytes);
            uploadPartCopyRequest.setPartNumber(partNumber);
            UploadPartCopyResponse uploadPartCopyResponse = client.uploadPartCopy(uploadPartCopyRequest);
            PartETag partETag = new PartETag(partNumber, uploadPartCopyResponse.getETag());
            partETags.add(partETag);
            left_size -= partSize;
            skipBytes += partSize;
            ++partNumber;
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest("targetBucketName", "targetObjectName", initiateMultipartUploadResponse.getUploadId(), partETags);
        CompleteMultipartUploadResponse completeMultipartUploadResponse = client.completeMultipartUpload(completeMultipartUploadRequest);
        client.shutdown();
    }
}

