/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.services.bos.BosObjectInputStream;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.GetObjectResponse;
import com.baidubce.util.Base64Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SelectObjectResponse
extends GetObjectResponse {
    private String recordDelimiter;
    private Messages messages;

    public Messages getMessages() {
        return this.messages;
    }

    public void initMessages(BosObject object) {
        if (this.messages != null) {
            return;
        }
        this.messages = new Messages(object);
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String delimiterBase64) {
        this.recordDelimiter = delimiterBase64;
    }

    private Map<String, String> parseMessages(byte[] headers) {
        int valLen;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int index = 0; index < headers.length; index += valLen) {
            int keyLen = headers[index] & 0xFF;
            String headerKey = new String(Arrays.copyOfRange(headers, ++index, index + keyLen));
            byte[] v = new byte[]{0, 0, headers[index += keyLen], headers[index + 1]};
            valLen = ByteBuffer.wrap(v).getInt();
            String headerVal = new String(Arrays.copyOfRange(headers, index += 2, index + valLen));
            map.put(headerKey, headerVal);
        }
        return map;
    }

    public class EndMessage
    extends CommonMessage {
        EndMessage(Prelude prelude, Map<String, String> headers, int crc32) {
            super(prelude, headers, crc32);
            this.Type = "End";
        }

        public String toString() {
            return "EndMessage{Prelude=" + this.Prelude.toString() + ", Headers=" + this.Headers + ", Crc32=" + super.getCrc32() + '}';
        }
    }

    public class ContinuationMessage
    extends CommonMessage {
        public int BytesScanned;
        public int BytesReturned;

        ContinuationMessage(Prelude prelude, Map<String, String> headers, int bytesScanned, int bytesReturned, int crc32) {
            super(prelude, headers, crc32);
            this.Type = "Cont";
            this.BytesScanned = bytesScanned;
            this.BytesReturned = bytesReturned;
        }

        public String toString() {
            return "ContinuationMessage{Prelude=" + this.Prelude.toString() + ", Headers=" + this.Headers + ", BytesScanned=" + this.BytesScanned + ", BytesReturned=" + this.BytesReturned + ", Crc32=" + super.getCrc32() + '}';
        }
    }

    public class RecordsMessage
    extends CommonMessage {
        RecordsMessage(Prelude prelude, Map<String, String> headers, String[] records, int crc32) {
            super(prelude, headers, crc32);
            super.setRecords(records);
            this.Type = "Records";
        }

        public String toString() {
            return "RecordsMessage{Prelude=" + this.Prelude.toString() + ", Headers=" + this.Headers + ", Records=" + Arrays.toString(super.getRecords()) + ", Crc32=" + super.getCrc32() + '}';
        }
    }

    public class CommonMessage {
        public String Type;
        public Prelude Prelude;
        public Map Headers;
        private int Crc32;
        private String[] Records;

        CommonMessage(Prelude prelude, Map headers, int crc32) {
            this.Prelude = prelude;
            this.Headers = headers;
            this.Crc32 = crc32;
        }

        public int getCrc32() {
            return this.Crc32;
        }

        public void setCrc32(int crc32) {
            this.Crc32 = crc32;
        }

        public String[] getRecords() {
            return this.Records;
        }

        public void setRecords(String[] records) {
            this.Records = records;
        }
    }

    public class Prelude {
        int TotalLen;
        int HeadersLen;

        Prelude(int totalLen, int headersLen) {
            this.TotalLen = totalLen;
            this.HeadersLen = headersLen;
        }

        public String toString() {
            return "Prelude{TotalLen=" + this.TotalLen + ", HeadersLen=" + this.HeadersLen + '}';
        }
    }

    public class Messages
    implements Iterator {
        BosObject object;
        BosObjectInputStream inputStream;
        boolean isEnd = false;
        private String messageType = "";

        Messages(BosObject object) {
            this.object = object;
            this.inputStream = object.getObjectContent();
        }

        public boolean readFromStream(byte[] b) {
            int readed;
            try {
                int n = 0;
                for (readed = 0; readed < b.length && (n = this.inputStream.read(b, readed, b.length - readed)) != -1; readed += n) {
                }
            }
            catch (IOException e) {
                return false;
            }
            return readed == b.length;
        }

        @Override
        public boolean hasNext() {
            if ("End".equals(this.messageType) || "EndMessage lost".equals(this.messageType) || this.isEnd) {
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                        this.inputStream = null;
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("the EndMessage may have been lost.", e);
                }
                return false;
            }
            return true;
        }

        public CommonMessage next() {
            try {
                byte[] temp_4 = new byte[4];
                if (!this.readFromStream(temp_4)) {
                    this.isEnd = true;
                    throw new IllegalStateException("the Message may have been lost.");
                }
                int totalLen = ByteBuffer.wrap(temp_4).getInt();
                if (!this.readFromStream(temp_4)) {
                    this.isEnd = true;
                    throw new IllegalStateException("the Message may have been lost.");
                }
                int headerLen = ByteBuffer.wrap(temp_4).getInt();
                byte[] temp_headers = new byte[headerLen];
                if (!this.readFromStream(temp_headers)) {
                    this.isEnd = true;
                    throw new IllegalStateException("the Message may have been lost.");
                }
                Map headers = SelectObjectResponse.this.parseMessages(temp_headers);
                if (((String)headers.get("message-type")).equals("Records")) {
                    this.messageType = "Records";
                    int payloadLen = totalLen - headerLen - 12;
                    byte[] temp_payLoad = new byte[payloadLen];
                    if (!this.readFromStream(temp_payLoad)) {
                        this.isEnd = true;
                        throw new IllegalStateException("the Message may have been lost.");
                    }
                    String payload = new String(temp_payLoad);
                    if (!this.readFromStream(temp_4)) {
                        this.isEnd = true;
                        throw new IllegalStateException("the Message may have been lost.");
                    }
                    int crc = ByteBuffer.wrap(temp_4).getInt();
                    Prelude prelude = new Prelude(totalLen, headerLen);
                    String delimiter = "\n";
                    if (SelectObjectResponse.this.recordDelimiter != null) {
                        delimiter = Base64Utils.decode(SelectObjectResponse.this.recordDelimiter);
                    }
                    return new RecordsMessage(prelude, headers, payload.split(delimiter), crc);
                }
                if (((String)headers.get("message-type")).equals("Cont")) {
                    this.messageType = "Cont";
                    byte[] temp_8 = new byte[8];
                    if (!this.readFromStream(temp_8)) {
                        this.isEnd = true;
                        throw new IllegalStateException("the Message may have been lost.");
                    }
                    int bytesScanned = ByteBuffer.wrap(temp_8).getInt();
                    if (!this.readFromStream(temp_8)) {
                        this.isEnd = true;
                        throw new IllegalStateException("the Message may have been lost.");
                    }
                    int bytesReturned = ByteBuffer.wrap(temp_8).getInt();
                    if (!this.readFromStream(temp_4)) {
                        this.isEnd = true;
                        throw new IllegalStateException("the Message may have been lost.");
                    }
                    int crc = ByteBuffer.wrap(temp_4).getInt();
                    Prelude prelude = new Prelude(totalLen, headerLen);
                    return new ContinuationMessage(prelude, headers, bytesScanned, bytesReturned, crc);
                }
                if (((String)headers.get("message-type")).equals("End")) {
                    this.messageType = "End";
                    if (!this.readFromStream(temp_4)) {
                        this.isEnd = true;
                        throw new IllegalStateException("the Message may have been lost.");
                    }
                    int crc = ByteBuffer.wrap(temp_4).getInt();
                    Prelude prelude = new Prelude(totalLen, headerLen);
                    this.inputStream.close();
                    this.inputStream = null;
                    return new EndMessage(prelude, (Map<String, String>)headers, crc);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse parameters.", e);
            }
            this.messageType = "EndMessage lost";
            return null;
        }

        @Override
        @Deprecated
        public void remove() {
        }
    }
}

