/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cfw;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.common.ApiInfo;
import com.baidubce.common.BaseBceClient;
import com.baidubce.common.BaseBceResponse;
import com.baidubce.common.BceRegion;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.cfw.api.CfwApi;
import com.baidubce.services.cfw.model.BindCfwRequest;
import com.baidubce.services.cfw.model.CreateCfwRequest;
import com.baidubce.services.cfw.model.CreateCfwResponse;
import com.baidubce.services.cfw.model.CreateCfwRuleRequest;
import com.baidubce.services.cfw.model.DeleteCfwRuleRequest;
import com.baidubce.services.cfw.model.DisableCfwRequest;
import com.baidubce.services.cfw.model.EnableCfwRequest;
import com.baidubce.services.cfw.model.GetCfwResponse;
import com.baidubce.services.cfw.model.ListCfwRequest;
import com.baidubce.services.cfw.model.ListCfwResponse;
import com.baidubce.services.cfw.model.ListInstanceRequest;
import com.baidubce.services.cfw.model.ListInstanceResponse;
import com.baidubce.services.cfw.model.UnbindCfwRequest;
import com.baidubce.services.cfw.model.UpdateCfwRequest;
import com.baidubce.services.cfw.model.UpdateCfwRuleRequest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CfwClient
extends BaseBceClient {
    private static final Map<BceRegion, String> ENDPOINTS = ImmutableMap.builder().put((Object)BceRegion.DEFAULT, (Object)"cfw.baidubce.com").build();
    private static final String VERSION = "1";
    private static final String SERVICE_ID = "Cfw";
    private static final Map<String, ApiInfo> CFW_APIS = CfwApi.getApis();

    public CfwClient(String ak, String sk, BceRegion region) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)region));
    }

    public CfwClient(String ak, String sk) {
        super(SERVICE_ID, ak, sk, ENDPOINTS.get((Object)BceRegion.DEFAULT));
    }

    public CfwClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public void bindCfw(String cfwId, BindCfwRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("bindCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public CreateCfwResponse createCfw(CreateCfwRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("createCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        return this.invokeHttpClient(internalRequest, CreateCfwResponse.class);
    }

    public void createCfwRule(String cfwId, CreateCfwRuleRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("createCfwRule"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteCfw(String cfwId) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("deleteCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void deleteCfwRule(String cfwId, DeleteCfwRuleRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("deleteCfwRule"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void disableCfw(String cfwId, DisableCfwRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("disableCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void enableCfw(String cfwId, EnableCfwRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("enableCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public GetCfwResponse getCfw(String cfwId) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("getCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, GetCfwResponse.class);
    }

    public ListCfwResponse listCfw(ListCfwRequest listCfwRequest) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("listCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).get();
        if (StringUtils.isNotBlank((CharSequence)listCfwRequest.getMarker())) {
            apiInfo.getQueries().put("marker", listCfwRequest.getMarker());
        }
        if (listCfwRequest.getMaxKeys() != null) {
            apiInfo.getQueries().put("maxKeys", String.valueOf(listCfwRequest.getMaxKeys()));
        }
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListCfwResponse.class);
    }

    public ListInstanceResponse listInstance(ListInstanceRequest listInstanceRequest) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("listInstance"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).get();
        if (StringUtils.isBlank((CharSequence)listInstanceRequest.getInstanceType())) {
            throw new BceClientException("InstanceType cannot be empty!");
        }
        apiInfo.getQueries().put("instanceType", listInstanceRequest.getInstanceType());
        if (StringUtils.isNotBlank((CharSequence)listInstanceRequest.getMarker())) {
            apiInfo.getQueries().put("marker", listInstanceRequest.getMarker());
        }
        if (StringUtils.isNotBlank((CharSequence)listInstanceRequest.getStatus())) {
            apiInfo.getQueries().put("status", listInstanceRequest.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)listInstanceRequest.getRegion())) {
            apiInfo.getQueries().put("region", listInstanceRequest.getRegion());
        }
        if (listInstanceRequest.getMaxKeys() != null) {
            apiInfo.getQueries().put("maxKeys", String.valueOf(listInstanceRequest.getMaxKeys()));
        }
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), null);
        return this.invokeHttpClient(internalRequest, ListInstanceResponse.class);
    }

    public void unbindCfw(String cfwId, UnbindCfwRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("unbindCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void updateCfw(String cfwId, UpdateCfwRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("updateCfw"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }

    public void updateCfwRule(String cfwId, String cfwRuleId, UpdateCfwRuleRequest body) {
        ApiInfo apiInfo = new ApiInfo(CFW_APIS.get("updateCfwRule"));
        String apiPath = apiInfo.getPath().withPathParameter("version", VERSION).withPathParameter("cfwId", cfwId).withPathParameter("cfwRuleId", cfwRuleId).get();
        InternalRequest internalRequest = this.createRequest(apiInfo.getMethod(), apiPath, apiInfo.getQueries(), apiInfo.getHeaders(), body);
        this.invokeHttpClient(internalRequest, BaseBceResponse.class);
    }
}

