/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk.device.seplatform;

import com.baidubce.services.iothisk.device.crypto.AesEncrypt;
import com.baidubce.services.iothisk.device.crypto.HashCrypto;
import com.baidubce.services.iothisk.device.model.ActiveMessage;
import com.baidubce.services.iothisk.device.model.CipherMessage;
import com.baidubce.services.iothisk.device.model.Device;
import com.baidubce.services.iothisk.device.model.DeviceKey;
import com.baidubce.services.iothisk.device.model.DeviceSdkType;
import com.baidubce.services.iothisk.device.model.PlainMessage;
import com.baidubce.services.iothisk.device.seplatform.SecureElement;
import com.baidubce.services.iothisk.device.utils.ByteUtils;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MbedAkeySe
implements SecureElement {
    private final Device device;
    private final DeviceKey deviceKey;
    private final byte[] seKey;
    private final byte[] seIv;
    private static final int DEVICE_ID_BYTES_LENGTH = 64;
    private static final int CIPHER_MESSAGE_SIGNATURE_BYTE_LENGTH = 32;
    private static final int KEY_ITERATION_COUNT = 50;
    private static final int IV_ITERATION_COUNT = 25;
    private static final int TIMESTAMP_BYTE_LENGTH = 4;
    private static final int SDK_TYPE_BYTES_LENGTH = 1;

    public MbedAkeySe(Device device, DeviceKey deviceKey) {
        this.device = device;
        this.deviceKey = deviceKey;
        byte[] masterKeyBytes = ByteUtils.toBytesFromHex(device.getMasterKey());
        this.seKey = HashCrypto.pbkdf2WithHmacSha256(masterKeyBytes, deviceKey.getSeId().getBytes(), 50);
        this.seIv = HashCrypto.pbkdf2WithHmacSha256(masterKeyBytes, deviceKey.getSeId().getBytes(), 25);
    }

    @Override
    public String generateId() {
        String idBeforeHash = this.device.getDeviceCompany() + this.device.getDeviceType() + this.deviceKey.getSeId();
        byte[] masterKeyBytes = ByteUtils.toBytesFromHex(this.device.getMasterKey());
        try {
            byte[] deviceIdBytes = HashCrypto.hmacSha256(idBeforeHash.getBytes(), masterKeyBytes);
            return ByteUtils.toHexStringFromBytes(deviceIdBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Generate device id failed.");
        }
    }

    @Override
    public CipherMessage encryptThenSign(PlainMessage plainMessage) {
        return this.encryptThenSign(plainMessage, this.seKey);
    }

    @Override
    public CipherMessage encryptThenSign(PlainMessage plainMessage, byte[] signPrivateKey) {
        byte[] encryption = AesEncrypt.encryptByCTRNoPadding(plainMessage.getBytes(), this.seKey, this.seIv);
        try {
            byte[] signature = HashCrypto.hmacSha256(encryption, signPrivateKey);
            return new CipherMessage(encryption, signature);
        }
        catch (Exception e) {
            throw new IllegalStateException("Calculate signature failed.", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] encryption) {
        return AesEncrypt.decryptByCTRNoPadding(encryption, this.seKey, this.seIv);
    }

    @Override
    public void verifySignature(byte[] message, byte[] signature) {
        byte[] calculatedSign = null;
        try {
            calculatedSign = HashCrypto.hmacSha256(message, this.seKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("Calculate signature failed.", e);
        }
        if (!Arrays.equals(calculatedSign, signature)) {
            throw new IllegalArgumentException("Invalid signature.");
        }
    }

    @Override
    public PlainMessage verifyThenDecrypt(CipherMessage cipherMessage) {
        this.verifySignature(cipherMessage.getEncryption(), cipherMessage.getSignature());
        byte[] message = this.decrypt(cipherMessage.getEncryption());
        return this.parsePlainMessage(message);
    }

    @Override
    public CipherMessage parseCipherMessage(byte[] cipherMessage) {
        if (ArrayUtils.getLength((Object)cipherMessage) <= 36) {
            throw new IllegalArgumentException("The data to be encrypted or decrypted is invalid.");
        }
        CipherMessage cipher = new CipherMessage();
        cipher.setEncryption(Arrays.copyOfRange(cipherMessage, 0, cipherMessage.length - 32));
        cipher.setSignature(Arrays.copyOfRange(cipherMessage, cipherMessage.length - 32, cipherMessage.length));
        return cipher;
    }

    @Override
    public PlainMessage parsePlainMessage(byte[] plainMessage) {
        PlainMessage message = new PlainMessage();
        message.setMessage(MbedAkeySe.getMessage(plainMessage));
        message.setCounter(MbedAkeySe.getTimestamp(plainMessage));
        return message;
    }

    @Override
    public ActiveMessage parseActiveMessage(byte[] activeMessage) {
        ActiveMessage message = new ActiveMessage();
        message.setDeviceId(this.getDeviceId(activeMessage));
        message.setSeId(this.getSeId(activeMessage));
        message.setSdkType(this.getSdkType(activeMessage));
        return message;
    }

    @Override
    public void checkActiveMessage(ActiveMessage activeMessage) {
        this.checkDeviceId(activeMessage.getDeviceId());
        this.checkSeId(activeMessage.getSeId());
    }

    private void checkDeviceId(String deviceId) {
        if (!StringUtils.equals((CharSequence)this.generateId(), (CharSequence)deviceId)) {
            throw new IllegalArgumentException("The device ID is invalid.");
        }
    }

    private void checkSeId(String seId) {
        if (StringUtils.isEmpty((CharSequence)this.deviceKey.getSeId()) || StringUtils.isEmpty((CharSequence)seId)) {
            return;
        }
        if (!StringUtils.equals((CharSequence)this.deviceKey.getSeId(), (CharSequence)seId)) {
            throw new IllegalArgumentException("This device se id conflicts with the exist se id.");
        }
    }

    private String getSeId(byte[] activeMessage) {
        return new String(this.getSeIdBytes(activeMessage));
    }

    private byte[] getSeIdBytes(byte[] activeMessage) {
        if (activeMessage.length <= 65) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return Arrays.copyOfRange(activeMessage, 64, activeMessage.length - 1);
    }

    private DeviceSdkType getSdkType(byte[] activeMessage) {
        if (activeMessage.length <= 64) {
            return DeviceSdkType.NONE_RTC;
        }
        String sdkTypeStr = ByteUtils.toHexStringFromBytes(Arrays.copyOfRange(activeMessage, activeMessage.length - 1, activeMessage.length));
        return DeviceSdkType.parse(sdkTypeStr);
    }

    private String getDeviceId(byte[] activeMessage) {
        int len = Math.min(64, activeMessage.length);
        return new String(activeMessage, 0, len);
    }

    private static byte[] getMessage(byte[] plaintext) {
        return Arrays.copyOfRange(plaintext, 4, plaintext.length);
    }

    private static long getTimestamp(byte[] plaintext) {
        byte[] timestamp = Arrays.copyOfRange(plaintext, 0, 4);
        return ByteUtils.toLongFromBytes(timestamp);
    }
}

