/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.lps;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

public class BaseLpsClient
extends AbstractBceClient {
    private static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    private static final String ENDPOINT = "http://lps.baidubce.com";
    private static final String CONTENT_TYPE = "application/json;charset=utf-8";
    private static final String[] HEADERS_TO_SIGN = new String[]{"Host", "x-bce-date"};
    private static HttpResponseHandler[] lmsHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    protected BaseLpsClient() {
        this(new BceClientConfiguration());
    }

    protected BaseLpsClient(String accessKey, String secretKey) {
        this(new BceClientConfiguration().withSocketTimeoutInMillis(20000).withCredentials(new DefaultBceCredentials(accessKey, secretKey)).withEndpoint(ENDPOINT));
    }

    protected BaseLpsClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, lmsHandlers);
    }

    protected InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String path) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path);
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.addHeader("x-bce-date", DateUtils.formatAlternateIso8601Date(new Date()));
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        internalRequest.setSignOptions(signOptions);
        internalRequest.setCredentials(this.config.getCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeadAndBody(bceRequest, internalRequest);
        }
        return internalRequest;
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        try {
            String jsonStr = JsonUtils.toJsonString(bceRequest);
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        catch (IllegalStateException e) {
            throw new BceClientException("Fail to convert request to json", e);
        }
    }
}

