/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model;

import com.baidubce.util.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class AttributeValue {
    public static final String ATTRIBUTE_TYPE_NUMBER = "N";
    public static final String ATTRIBUTE_TYPE_STRING = "S";
    public static final String ATTRIBUTE_TYPE_BINARY = "B";
    private String attributeType;
    private String attributeValue;

    public AttributeValue() {
        this.attributeType = null;
        this.attributeValue = "";
    }

    public AttributeValue(String s) {
        this.attributeType = ATTRIBUTE_TYPE_STRING;
        this.attributeValue = s;
    }

    public AttributeValue(double d) {
        this.attributeType = ATTRIBUTE_TYPE_NUMBER;
        this.attributeValue = Double.toString(d);
    }

    public AttributeValue(long n) {
        this.attributeType = ATTRIBUTE_TYPE_NUMBER;
        this.attributeValue = Long.toString(n);
    }

    public AttributeValue(byte[] buffer) {
        this.setB(buffer);
    }

    public byte[] getB() {
        return Base64.decodeBase64((String)this.attributeValue);
    }

    public AttributeValue withB(byte[] buffer) {
        this.setB(buffer);
        return this;
    }

    public void setB(byte[] buffer) {
        this.setValue(ATTRIBUTE_TYPE_BINARY, Base64.encodeBase64String((byte[])buffer));
    }

    public String getN() {
        return this.attributeValue;
    }

    public long getLong() {
        return Long.parseLong(this.attributeValue);
    }

    public double getDouble() {
        return Double.parseDouble(this.attributeValue);
    }

    public AttributeValue withN(String n) {
        this.setN(n);
        return this;
    }

    public AttributeValue withN(long n) {
        this.setN(Long.toString(n));
        return this;
    }

    public AttributeValue withN(double n) {
        this.setN(Double.toString(n));
        return this;
    }

    public void setN(String n) {
        this.setValue(ATTRIBUTE_TYPE_NUMBER, n);
    }

    public void setN(long n) {
        this.setValue(ATTRIBUTE_TYPE_NUMBER, Long.toString(n));
    }

    public void setN(double n) {
        this.setValue(ATTRIBUTE_TYPE_NUMBER, Double.toString(n));
    }

    public String getS() {
        return this.attributeValue;
    }

    public AttributeValue withS(String s) {
        this.setS(s);
        return this;
    }

    public void setS(String s) {
        this.setValue(ATTRIBUTE_TYPE_STRING, s);
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public String toString() {
        return JsonUtils.toJsonString(this.toJsonObj());
    }

    public void setValue(String type, String value) {
        this.attributeType = type;
        this.attributeValue = value;
    }

    protected Map<String, String> toJsonObj() {
        HashMap<String, String> jsonObj = new HashMap<String, String>();
        jsonObj.put(this.attributeType, this.attributeValue);
        return jsonObj;
    }
}

