/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.model.ShowInstanceResponse;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;

public class ShowInstanceResponseUnmarshaller
implements Unmarshaller<ShowInstanceResponse, InputStream> {
    private ShowInstanceResponse result;

    public ShowInstanceResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ShowInstanceResponse)response;
    }

    @Override
    public ShowInstanceResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        String id = root.get("id").asText();
        String name = root.get("name").asText();
        String region = root.get("region").asText();
        String state = root.get("state").asText();
        String createTime = root.get("createTime").asText();
        String storageType = root.get("storageType").asText();
        this.result.setId(id);
        this.result.setName(name);
        this.result.setRegion(region);
        this.result.setState(state);
        this.result.setCreateTime(createTime);
        this.result.setStorageType(storageType);
        return this.result;
    }
}

