/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.CellType;
import com.baidubce.services.tablestorage.model.TableStorageCell;
import com.baidubce.services.tablestorage.model.TableStorageResult;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;

public class TableStorageResultUnmarshaller
implements Unmarshaller<TableStorageResult, JsonNode> {
    @Override
    public TableStorageResult unmarshall(JsonNode resultNode) throws Exception {
        String rowkey = resultNode.get("rowkey").asText();
        JsonNode cellsNode = resultNode.get("cells");
        ArrayList<TableStorageCell> cells = new ArrayList<TableStorageCell>();
        if (cells != null) {
            Iterator cellList = cellsNode.elements();
            while (cellList.hasNext()) {
                JsonNode cellNode = (JsonNode)cellList.next();
                String column = cellNode.get("column").asText();
                String value = cellNode.get("value").asText();
                String decodeValue = URLDecoder.decode(value, TableStorageConstants.DEFAULT_ENCODING);
                int timestamp = 0;
                if (cellNode.has("timestamp")) {
                    timestamp = cellNode.get("timestamp").asInt();
                }
                TableStorageCell cell = new TableStorageCell(CellType.ResultCell, column, decodeValue, timestamp);
                cells.add(cell);
            }
        }
        String decodeRowkey = URLDecoder.decode(rowkey, TableStorageConstants.DEFAULT_ENCODING);
        return new TableStorageResult(decodeRowkey, cells);
    }
}

