/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vodpro.model.common;

import com.baidubce.BceServiceException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;

@JsonSerialize(using=PathSerializer.class, typing=JsonSerialize.Typing.STATIC)
@JsonDeserialize(using=PathDeserializer.class)
public class Path {
    private String me;
    private String origin;
    @JsonIgnore
    private Path parent;
    private String last;
    private boolean dir;

    public String getMe() {
        return this.me;
    }

    public Path(String content) {
        if (content == null) {
            content = "";
        }
        if (content.length() > 255) {
            throw new BceServiceException("Content is too long: " + content);
        }
        this.origin = content.trim();
        String[] temp = this.origin.split("/");
        ArrayList<String> elements = new ArrayList<String>();
        for (String s : temp) {
            if (s.trim().isEmpty()) continue;
            elements.add(s.trim());
        }
        ImmutableList tokens = ImmutableList.copyOf(elements);
        if (tokens.isEmpty()) {
            this.origin = this.me = "";
            this.dir = true;
            this.last = this.me;
            return;
        }
        for (String s : tokens) {
            if (this.me == null) {
                this.me = String.format("%s", s);
                continue;
            }
            this.me = String.format("%s/%s", this.me, s);
        }
        this.dir = this.origin.isEmpty() || this.origin.charAt(this.origin.length() - 1) == '/';
        this.last = (String)tokens.get(tokens.size() - 1);
        this.parent = new Path((ImmutableList<String>)tokens.subList(0, tokens.size() - 1));
    }

    private Path(ImmutableList<String> dirs) {
        if (dirs == null || dirs.isEmpty()) {
            this.origin = this.me = "";
            this.dir = true;
            this.last = this.me;
        } else {
            for (String s : dirs) {
                this.me = String.format("%s/%s", this.me, s);
            }
            this.origin = this.me;
            this.last = (String)dirs.get(dirs.size() - 1);
            this.dir = true;
            this.parent = new Path((ImmutableList<String>)dirs.subList(0, dirs.size() - 1));
        }
    }

    public static class PathDeserializer
    extends StdDeserializer<Path> {
        public PathDeserializer() {
            this(null);
        }

        public PathDeserializer(Class<?> vc) {
            super(vc);
        }

        public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String content = (String)jsonParser.getCodec().readValue(jsonParser, String.class);
            return new Path(content);
        }
    }

    public static class PathSerializer
    extends StdSerializer<Path> {
        public PathSerializer() {
            this(null);
        }

        public PathSerializer(Class<Path> t) {
            super(t);
        }

        public void serialize(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(path.getMe());
        }
    }
}

