/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.tx.ConnectionFactory;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DynamicTransactionAdvisor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicTransactionAdvisor.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object o;
        if (!StringUtils.isEmpty((Object)TransactionContext.getXID())) {
            return methodInvocation.proceed();
        }
        boolean state = true;
        String xid = UUID.randomUUID().toString();
        TransactionContext.bind(xid);
        try {
            o = methodInvocation.proceed();
        }
        catch (Exception e) {
            state = false;
            throw e;
        }
        finally {
            ConnectionFactory.notify(state);
            TransactionContext.remove();
        }
        return o;
    }
}

