/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.baomidou.dynamic.datasource.toolkit.CryptoUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.StringUtils;

public class DataSourceProperty {
    private static final Logger log = LoggerFactory.getLogger(DataSourceProperty.class);
    private static final Pattern ENC_PATTERN = Pattern.compile("^ENC\\((.*)\\)$");
    private String poolName;
    private Class<? extends DataSource> type;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String jndiName;
    private String schema;
    private String data;
    private Boolean seata = true;
    private Boolean p6spy = true;
    private Boolean lazy;
    private boolean continueOnError = true;
    private String separator = ";";
    @NestedConfigurationProperty
    private DruidConfig druid = new DruidConfig();
    @NestedConfigurationProperty
    private HikariCpConfig hikari = new HikariCpConfig();
    private String publicKey;

    public String getUrl() {
        return this.decrypt(this.url);
    }

    public String getUsername() {
        return this.decrypt(this.username);
    }

    public String getPassword() {
        return this.decrypt(this.password);
    }

    private String decrypt(String cipherText) {
        Matcher matcher;
        if (StringUtils.hasText((String)cipherText) && (matcher = ENC_PATTERN.matcher(cipherText)).find()) {
            try {
                return CryptoUtils.decrypt(this.publicKey, matcher.group(1));
            }
            catch (Exception e) {
                log.error("DynamicDataSourceProperties.decrypt error ", (Throwable)e);
            }
        }
        return cipherText;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public Class<? extends DataSource> getType() {
        return this.type;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getData() {
        return this.data;
    }

    public Boolean getSeata() {
        return this.seata;
    }

    public Boolean getP6spy() {
        return this.p6spy;
    }

    public Boolean getLazy() {
        return this.lazy;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public String getSeparator() {
        return this.separator;
    }

    public DruidConfig getDruid() {
        return this.druid;
    }

    public HikariCpConfig getHikari() {
        return this.hikari;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public DataSourceProperty setPoolName(String poolName) {
        this.poolName = poolName;
        return this;
    }

    public DataSourceProperty setType(Class<? extends DataSource> type) {
        this.type = type;
        return this;
    }

    public DataSourceProperty setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public DataSourceProperty setUrl(String url) {
        this.url = url;
        return this;
    }

    public DataSourceProperty setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataSourceProperty setPassword(String password) {
        this.password = password;
        return this;
    }

    public DataSourceProperty setJndiName(String jndiName) {
        this.jndiName = jndiName;
        return this;
    }

    public DataSourceProperty setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public DataSourceProperty setData(String data) {
        this.data = data;
        return this;
    }

    public DataSourceProperty setSeata(Boolean seata) {
        this.seata = seata;
        return this;
    }

    public DataSourceProperty setP6spy(Boolean p6spy) {
        this.p6spy = p6spy;
        return this;
    }

    public DataSourceProperty setLazy(Boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public DataSourceProperty setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public DataSourceProperty setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public DataSourceProperty setDruid(DruidConfig druid) {
        this.druid = druid;
        return this;
    }

    public DataSourceProperty setHikari(HikariCpConfig hikari) {
        this.hikari = hikari;
        return this;
    }

    public DataSourceProperty setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceProperty)) {
            return false;
        }
        DataSourceProperty other = (DataSourceProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isContinueOnError() != other.isContinueOnError()) {
            return false;
        }
        Boolean this$seata = this.getSeata();
        Boolean other$seata = other.getSeata();
        if (this$seata == null ? other$seata != null : !((Object)this$seata).equals(other$seata)) {
            return false;
        }
        Boolean this$p6spy = this.getP6spy();
        Boolean other$p6spy = other.getP6spy();
        if (this$p6spy == null ? other$p6spy != null : !((Object)this$p6spy).equals(other$p6spy)) {
            return false;
        }
        Boolean this$lazy = this.getLazy();
        Boolean other$lazy = other.getLazy();
        if (this$lazy == null ? other$lazy != null : !((Object)this$lazy).equals(other$lazy)) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        if (this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName)) {
            return false;
        }
        Class<? extends DataSource> this$type = this.getType();
        Class<? extends DataSource> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$jndiName = this.getJndiName();
        String other$jndiName = other.getJndiName();
        if (this$jndiName == null ? other$jndiName != null : !this$jndiName.equals(other$jndiName)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
            return false;
        }
        DruidConfig this$druid = this.getDruid();
        DruidConfig other$druid = other.getDruid();
        if (this$druid == null ? other$druid != null : !((Object)this$druid).equals(other$druid)) {
            return false;
        }
        HikariCpConfig this$hikari = this.getHikari();
        HikariCpConfig other$hikari = other.getHikari();
        if (this$hikari == null ? other$hikari != null : !((Object)this$hikari).equals(other$hikari)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isContinueOnError() ? 79 : 97);
        Boolean $seata = this.getSeata();
        result = result * 59 + ($seata == null ? 43 : ((Object)$seata).hashCode());
        Boolean $p6spy = this.getP6spy();
        result = result * 59 + ($p6spy == null ? 43 : ((Object)$p6spy).hashCode());
        Boolean $lazy = this.getLazy();
        result = result * 59 + ($lazy == null ? 43 : ((Object)$lazy).hashCode());
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        Class<? extends DataSource> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $jndiName = this.getJndiName();
        result = result * 59 + ($jndiName == null ? 43 : $jndiName.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        DruidConfig $druid = this.getDruid();
        result = result * 59 + ($druid == null ? 43 : ((Object)$druid).hashCode());
        HikariCpConfig $hikari = this.getHikari();
        result = result * 59 + ($hikari == null ? 43 : ((Object)$hikari).hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceProperty(poolName=" + this.getPoolName() + ", type=" + this.getType() + ", driverClassName=" + this.getDriverClassName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", jndiName=" + this.getJndiName() + ", schema=" + this.getSchema() + ", data=" + this.getData() + ", seata=" + this.getSeata() + ", p6spy=" + this.getP6spy() + ", lazy=" + this.getLazy() + ", continueOnError=" + this.isContinueOnError() + ", separator=" + this.getSeparator() + ", druid=" + this.getDruid() + ", hikari=" + this.getHikari() + ", publicKey=" + this.getPublicKey() + ")";
    }
}

