/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.support;

import com.baomidou.dynamic.datasource.annotation.DS;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.ClassUtils;

public class DataSourceClassResolver {
    private static final Logger log = LoggerFactory.getLogger(DataSourceClassResolver.class);
    private static boolean mpEnabled = false;
    private static Field mapperInterfaceField;
    private final Map<Object, String> dsCache = new ConcurrentHashMap<Object, String>();
    private final boolean allowedPublicOnly;

    public DataSourceClassResolver(boolean allowedPublicOnly) {
        this.allowedPublicOnly = allowedPublicOnly;
    }

    public String findDSKey(Method method, Object targetObject) {
        if (method.getDeclaringClass() == Object.class) {
            return "";
        }
        MethodClassKey cacheKey = new MethodClassKey(method, targetObject.getClass());
        String ds = this.dsCache.get(cacheKey);
        if (ds == null) {
            ds = this.computeDatasource(method, targetObject);
            if (ds == null) {
                ds = "";
            }
            this.dsCache.put(cacheKey, ds);
        }
        return ds;
    }

    private String computeDatasource(Method method, Object targetObject) {
        if (this.allowedPublicOnly && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> targetClass = targetObject.getClass();
        Class userClass = ClassUtils.getUserClass(targetClass);
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)userClass);
        String dsAttr = this.findDataSourceAttribute(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod));
        if (dsAttr != null) {
            return dsAttr;
        }
        dsAttr = this.findDataSourceAttribute(specificMethod.getDeclaringClass());
        if (dsAttr != null && ClassUtils.isUserLevelMethod((Method)method)) {
            return dsAttr;
        }
        if (specificMethod != method) {
            dsAttr = this.findDataSourceAttribute(method);
            if (dsAttr != null) {
                return dsAttr;
            }
            dsAttr = this.findDataSourceAttribute(method.getDeclaringClass());
            if (dsAttr != null && ClassUtils.isUserLevelMethod((Method)method)) {
                return dsAttr;
            }
        }
        return this.getDefaultDataSourceAttr(targetObject);
    }

    private String getDefaultDataSourceAttr(Object targetObject) {
        Class<?> clazz;
        String datasourceAttr;
        Class<?> targetClass = targetObject.getClass();
        if (!Proxy.isProxyClass(targetClass)) {
            for (Class<?> currentClass = targetClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                datasourceAttr = this.findDataSourceAttribute(currentClass);
                if (datasourceAttr == null) continue;
                return datasourceAttr;
            }
        }
        if (mpEnabled && (clazz = this.getMapperInterfaceClass(targetObject)) != null) {
            datasourceAttr = this.findDataSourceAttribute(clazz);
            if (datasourceAttr != null) {
                return datasourceAttr;
            }
            return this.findDataSourceAttribute(clazz.getSuperclass());
        }
        return null;
    }

    private Class<?> getMapperInterfaceClass(Object target) {
        Object currentRefObject;
        Object current = target;
        while (Proxy.isProxyClass(current.getClass()) && (currentRefObject = AopProxyUtils.getSingletonTarget((Object)current)) != null) {
            current = currentRefObject;
        }
        try {
            if (Proxy.isProxyClass(current.getClass())) {
                return (Class)mapperInterfaceField.get(Proxy.getInvocationHandler(current));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private String findDataSourceAttribute(AnnotatedElement ae) {
        AnnotationAttributes attributes = AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)ae, DS.class);
        if (attributes != null) {
            return attributes.getString("value");
        }
        return null;
    }

    static {
        Class<?> proxyClass = null;
        try {
            proxyClass = Class.forName("com.baomidou.mybatisplus.core.override.MybatisMapperProxy");
        }
        catch (ClassNotFoundException e1) {
            try {
                proxyClass = Class.forName("com.baomidou.mybatisplus.core.override.PageMapperProxy");
            }
            catch (ClassNotFoundException e2) {
                try {
                    proxyClass = Class.forName("org.apache.ibatis.binding.MapperProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (proxyClass != null) {
            try {
                mapperInterfaceField = proxyClass.getDeclaredField("mapperInterface");
                mapperInterfaceField.setAccessible(true);
                mpEnabled = true;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }
}

