/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;

public class TableFieldInfo
implements Constants {
    private final Field field;
    private final String column;
    private final String property;
    private final String el;
    private final Class<?> propertyType;
    private final boolean isPrimitive;
    private final boolean isCharSequence;
    private final FieldStrategy insertStrategy;
    private final FieldStrategy updateStrategy;
    private final FieldStrategy whereStrategy;
    private final boolean version;
    private boolean select = true;
    private boolean logicDelete = false;
    private String logicDeleteValue;
    private String logicNotDeleteValue;
    private String update;
    private String condition = "%s=#{%s}";
    private FieldFill fieldFill = FieldFill.DEFAULT;
    private boolean withInsertFill;
    private boolean withUpdateFill;
    private String sqlSelect;
    private JdbcType jdbcType;
    private Class<? extends TypeHandler<?>> typeHandler;

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, TableField tableField, Reflector reflector, boolean existTableLogic) {
        String columnFormat;
        field.setAccessible(true);
        this.field = field;
        this.version = field.getAnnotation(Version.class) != null;
        this.property = field.getName();
        this.propertyType = reflector.getGetterType(this.property);
        this.isPrimitive = this.propertyType.isPrimitive();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.fieldFill = tableField.fill();
        this.withInsertFill = this.fieldFill == FieldFill.INSERT || this.fieldFill == FieldFill.INSERT_UPDATE;
        this.withUpdateFill = this.fieldFill == FieldFill.UPDATE || this.fieldFill == FieldFill.INSERT_UPDATE;
        this.update = tableField.update();
        JdbcType jdbcType = tableField.jdbcType();
        Class typeHandler = tableField.typeHandler();
        String numericScale = tableField.numericScale();
        String el = this.property;
        if (JdbcType.UNDEFINED != jdbcType) {
            this.jdbcType = jdbcType;
            el = el + ",jdbcType=" + jdbcType.name();
        }
        if (UnknownTypeHandler.class != typeHandler) {
            this.typeHandler = typeHandler;
            if (tableField.javaType()) {
                String javaType = null;
                TypeAliasRegistry registry = tableInfo.getConfiguration().getTypeAliasRegistry();
                Map typeAliases = registry.getTypeAliases();
                for (Map.Entry entry : typeAliases.entrySet()) {
                    if (!((Class)entry.getValue()).equals(this.propertyType)) continue;
                    javaType = (String)entry.getKey();
                    break;
                }
                if (javaType == null) {
                    javaType = this.propertyType.getName();
                    registry.registerAlias(javaType, this.propertyType);
                }
                el = el + ",javaType=" + javaType;
            }
            el = el + ",typeHandler=" + typeHandler.getName();
        }
        if (StringUtils.isNotBlank(numericScale)) {
            el = el + ",numericScale=" + numericScale;
        }
        this.el = el;
        this.initLogicDelete(dbConfig, field, existTableLogic);
        String column = tableField.value();
        if (StringUtils.isBlank(column)) {
            column = this.property;
            if (tableInfo.isUnderCamel()) {
                column = StringUtils.camelToUnderline(column);
            }
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
        }
        if (StringUtils.isNotBlank(columnFormat = dbConfig.getColumnFormat()) && tableField.keepGlobalFormat()) {
            column = String.format(columnFormat, column);
        }
        this.column = column;
        this.sqlSelect = column;
        if (tableInfo.getResultMap() == null && !tableInfo.isAutoInitResultMap() && TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), this.property, this.column)) {
            String propertyFormat = dbConfig.getPropertyFormat();
            String asProperty = this.property;
            if (StringUtils.isNotBlank(propertyFormat)) {
                asProperty = String.format(propertyFormat, this.property);
            }
            this.sqlSelect = this.sqlSelect + " AS " + asProperty;
        }
        this.insertStrategy = this.chooseFieldStrategy(tableField.insertStrategy(), dbConfig.getInsertStrategy());
        this.updateStrategy = this.chooseFieldStrategy(tableField.updateStrategy(), dbConfig.getUpdateStrategy());
        this.whereStrategy = this.chooseFieldStrategy(tableField.whereStrategy(), dbConfig.getSelectStrategy());
        if (StringUtils.isNotBlank(tableField.condition())) {
            this.condition = tableField.condition();
        }
        this.select = tableField.select();
    }

    private FieldStrategy chooseFieldStrategy(FieldStrategy fromAnnotation, FieldStrategy fromDbConfig) {
        return fromAnnotation == FieldStrategy.DEFAULT ? fromDbConfig : fromAnnotation;
    }

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, Reflector reflector, boolean existTableLogic) {
        String columnFormat;
        field.setAccessible(true);
        this.field = field;
        this.version = field.getAnnotation(Version.class) != null;
        this.property = field.getName();
        this.propertyType = reflector.getGetterType(this.property);
        this.isPrimitive = this.propertyType.isPrimitive();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.el = this.property;
        this.insertStrategy = dbConfig.getInsertStrategy();
        this.updateStrategy = dbConfig.getUpdateStrategy();
        this.whereStrategy = dbConfig.getSelectStrategy();
        this.initLogicDelete(dbConfig, field, existTableLogic);
        String column = this.property;
        if (tableInfo.isUnderCamel()) {
            column = StringUtils.camelToUnderline(column);
        }
        if (dbConfig.isCapitalMode()) {
            column = column.toUpperCase();
        }
        if (StringUtils.isNotBlank(columnFormat = dbConfig.getColumnFormat())) {
            column = String.format(columnFormat, column);
        }
        this.column = column;
        this.sqlSelect = column;
        if (tableInfo.getResultMap() == null && !tableInfo.isAutoInitResultMap() && TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), this.property, this.column)) {
            String propertyFormat = dbConfig.getPropertyFormat();
            String asProperty = this.property;
            if (StringUtils.isNotBlank(propertyFormat)) {
                asProperty = String.format(propertyFormat, this.property);
            }
            this.sqlSelect = this.sqlSelect + " AS " + asProperty;
        }
    }

    private void initLogicDelete(GlobalConfig.DbConfig dbConfig, Field field, boolean existTableLogic) {
        String deleteField;
        TableLogic tableLogic = field.getAnnotation(TableLogic.class);
        if (null != tableLogic) {
            this.logicNotDeleteValue = StringUtils.isNotBlank(tableLogic.value()) ? tableLogic.value() : dbConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = StringUtils.isNotBlank(tableLogic.delval()) ? tableLogic.delval() : dbConfig.getLogicDeleteValue();
            this.logicDelete = true;
        } else if (!existTableLogic && StringUtils.isNotBlank(deleteField = dbConfig.getLogicDeleteField()) && this.property.equals(deleteField)) {
            this.logicNotDeleteValue = dbConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = dbConfig.getLogicDeleteValue();
            this.logicDelete = true;
        }
    }

    public String getInsertSqlProperty(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return SqlScriptUtils.safeParam(newPrefix + this.el) + ",";
    }

    public String getInsertSqlPropertyMaybeIf(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = this.getInsertSqlProperty(newPrefix);
        if (this.withInsertFill) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, newPrefix + this.property, this.insertStrategy);
    }

    public String getInsertSqlColumn() {
        return this.column + ",";
    }

    public String getInsertSqlColumnMaybeIf(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = this.getInsertSqlColumn();
        if (this.withInsertFill) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, newPrefix + this.property, this.insertStrategy);
    }

    public String getSqlSet(String prefix) {
        return this.getSqlSet(false, prefix);
    }

    public String getSqlSet(boolean ignoreIf, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlSet = this.column + "=";
        sqlSet = StringUtils.isNotBlank(this.update) ? sqlSet + String.format(this.update, this.column) : sqlSet + SqlScriptUtils.safeParam(newPrefix + this.el);
        sqlSet = sqlSet + ",";
        if (ignoreIf) {
            return sqlSet;
        }
        if (this.withUpdateFill) {
            return sqlSet;
        }
        return this.convertIf(sqlSet, this.convertIfProperty(newPrefix, this.property), this.updateStrategy);
    }

    private String convertIfProperty(String prefix, String property) {
        return StringUtils.isNotBlank(prefix) ? prefix.substring(0, prefix.length() - 1) + "['" + property + "']" : property;
    }

    public String getSqlWhere(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = " AND " + String.format(this.condition, this.column, newPrefix + this.el);
        return this.convertIf(sqlScript, this.convertIfProperty(newPrefix, this.property), this.whereStrategy);
    }

    ResultMapping getResultMapping(Configuration configuration) {
        ResultMapping.Builder builder = new ResultMapping.Builder(configuration, this.property, StringUtils.getTargetColumn(this.column), this.propertyType);
        TypeHandlerRegistry registry = configuration.getTypeHandlerRegistry();
        if (this.jdbcType != null && this.jdbcType != JdbcType.UNDEFINED) {
            builder.jdbcType(this.jdbcType);
        }
        if (this.typeHandler != null && this.typeHandler != UnknownTypeHandler.class) {
            TypeHandler typeHandler = registry.getMappingTypeHandler(this.typeHandler);
            if (typeHandler == null) {
                typeHandler = registry.getInstance(this.propertyType, this.typeHandler);
            }
            builder.typeHandler(typeHandler);
        }
        return builder.build();
    }

    public String getVersionOli(String alias, String prefix) {
        String oli = " AND " + this.column + "=" + SqlScriptUtils.safeParam("MP_OPTLOCK_VERSION_ORIGINAL");
        String ognlStr = this.convertIfProperty(prefix, this.property);
        if (this.isCharSequence) {
            return SqlScriptUtils.convertIf(oli, String.format("%s != null and %s != null and %s != ''", alias, ognlStr, ognlStr), false);
        }
        return SqlScriptUtils.convertIf(oli, String.format("%s != null and %s != null", alias, ognlStr), false);
    }

    private String convertIf(String sqlScript, String property, FieldStrategy fieldStrategy) {
        if (fieldStrategy == FieldStrategy.NEVER) {
            return null;
        }
        if (this.isPrimitive || fieldStrategy == FieldStrategy.IGNORED) {
            return sqlScript;
        }
        if (fieldStrategy == FieldStrategy.NOT_EMPTY && this.isCharSequence) {
            return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null and %s != ''", property, property), false);
        }
        return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null", property), false);
    }

    public Field getField() {
        return this.field;
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public String getEl() {
        return this.el;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isCharSequence() {
        return this.isCharSequence;
    }

    public FieldStrategy getInsertStrategy() {
        return this.insertStrategy;
    }

    public FieldStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public FieldStrategy getWhereStrategy() {
        return this.whereStrategy;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getCondition() {
        return this.condition;
    }

    public FieldFill getFieldFill() {
        return this.fieldFill;
    }

    public boolean isWithInsertFill() {
        return this.withInsertFill;
    }

    public boolean isWithUpdateFill() {
        return this.withUpdateFill;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Class<? extends TypeHandler<?>> getTypeHandler() {
        return this.typeHandler;
    }

    public String toString() {
        return "TableFieldInfo(field=" + this.getField() + ", column=" + this.getColumn() + ", property=" + this.getProperty() + ", el=" + this.getEl() + ", propertyType=" + this.getPropertyType() + ", isPrimitive=" + this.isPrimitive() + ", isCharSequence=" + this.isCharSequence() + ", insertStrategy=" + this.getInsertStrategy() + ", updateStrategy=" + this.getUpdateStrategy() + ", whereStrategy=" + this.getWhereStrategy() + ", version=" + this.isVersion() + ", select=" + this.isSelect() + ", logicDelete=" + this.isLogicDelete() + ", logicDeleteValue=" + this.getLogicDeleteValue() + ", logicNotDeleteValue=" + this.getLogicNotDeleteValue() + ", update=" + this.getUpdate() + ", condition=" + this.getCondition() + ", fieldFill=" + this.getFieldFill() + ", withInsertFill=" + this.isWithInsertFill() + ", withUpdateFill=" + this.isWithUpdateFill() + ", sqlSelect=" + this.getSqlSelect() + ", jdbcType=" + this.getJdbcType() + ", typeHandler=" + this.getTypeHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableFieldInfo)) {
            return false;
        }
        TableFieldInfo other = (TableFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$el = this.getEl();
        String other$el = other.getEl();
        if (this$el == null ? other$el != null : !this$el.equals(other$el)) {
            return false;
        }
        Class<?> this$propertyType = this.getPropertyType();
        Class<?> other$propertyType = other.getPropertyType();
        if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
            return false;
        }
        if (this.isPrimitive() != other.isPrimitive()) {
            return false;
        }
        if (this.isCharSequence() != other.isCharSequence()) {
            return false;
        }
        FieldStrategy this$insertStrategy = this.getInsertStrategy();
        FieldStrategy other$insertStrategy = other.getInsertStrategy();
        if (this$insertStrategy == null ? other$insertStrategy != null : !this$insertStrategy.equals(other$insertStrategy)) {
            return false;
        }
        FieldStrategy this$updateStrategy = this.getUpdateStrategy();
        FieldStrategy other$updateStrategy = other.getUpdateStrategy();
        if (this$updateStrategy == null ? other$updateStrategy != null : !this$updateStrategy.equals(other$updateStrategy)) {
            return false;
        }
        FieldStrategy this$whereStrategy = this.getWhereStrategy();
        FieldStrategy other$whereStrategy = other.getWhereStrategy();
        if (this$whereStrategy == null ? other$whereStrategy != null : !this$whereStrategy.equals(other$whereStrategy)) {
            return false;
        }
        if (this.isVersion() != other.isVersion()) {
            return false;
        }
        if (this.isSelect() != other.isSelect()) {
            return false;
        }
        if (this.isLogicDelete() != other.isLogicDelete()) {
            return false;
        }
        String this$logicDeleteValue = this.getLogicDeleteValue();
        String other$logicDeleteValue = other.getLogicDeleteValue();
        if (this$logicDeleteValue == null ? other$logicDeleteValue != null : !this$logicDeleteValue.equals(other$logicDeleteValue)) {
            return false;
        }
        String this$logicNotDeleteValue = this.getLogicNotDeleteValue();
        String other$logicNotDeleteValue = other.getLogicNotDeleteValue();
        if (this$logicNotDeleteValue == null ? other$logicNotDeleteValue != null : !this$logicNotDeleteValue.equals(other$logicNotDeleteValue)) {
            return false;
        }
        String this$update = this.getUpdate();
        String other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !this$update.equals(other$update)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        FieldFill this$fieldFill = this.getFieldFill();
        FieldFill other$fieldFill = other.getFieldFill();
        if (this$fieldFill == null ? other$fieldFill != null : !this$fieldFill.equals(other$fieldFill)) {
            return false;
        }
        if (this.isWithInsertFill() != other.isWithInsertFill()) {
            return false;
        }
        if (this.isWithUpdateFill() != other.isWithUpdateFill()) {
            return false;
        }
        String this$sqlSelect = this.getSqlSelect();
        String other$sqlSelect = other.getSqlSelect();
        if (this$sqlSelect == null ? other$sqlSelect != null : !this$sqlSelect.equals(other$sqlSelect)) {
            return false;
        }
        JdbcType this$jdbcType = this.getJdbcType();
        JdbcType other$jdbcType = other.getJdbcType();
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        Class<TypeHandler<?>> this$typeHandler = this.getTypeHandler();
        Class<? extends TypeHandler<?>> other$typeHandler = other.getTypeHandler();
        return !(this$typeHandler == null ? other$typeHandler != null : !this$typeHandler.equals(other$typeHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableFieldInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $el = this.getEl();
        result = result * 59 + ($el == null ? 43 : $el.hashCode());
        Class<?> $propertyType = this.getPropertyType();
        result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
        result = result * 59 + (this.isPrimitive() ? 79 : 97);
        result = result * 59 + (this.isCharSequence() ? 79 : 97);
        FieldStrategy $insertStrategy = this.getInsertStrategy();
        result = result * 59 + ($insertStrategy == null ? 43 : $insertStrategy.hashCode());
        FieldStrategy $updateStrategy = this.getUpdateStrategy();
        result = result * 59 + ($updateStrategy == null ? 43 : $updateStrategy.hashCode());
        FieldStrategy $whereStrategy = this.getWhereStrategy();
        result = result * 59 + ($whereStrategy == null ? 43 : $whereStrategy.hashCode());
        result = result * 59 + (this.isVersion() ? 79 : 97);
        result = result * 59 + (this.isSelect() ? 79 : 97);
        result = result * 59 + (this.isLogicDelete() ? 79 : 97);
        String $logicDeleteValue = this.getLogicDeleteValue();
        result = result * 59 + ($logicDeleteValue == null ? 43 : $logicDeleteValue.hashCode());
        String $logicNotDeleteValue = this.getLogicNotDeleteValue();
        result = result * 59 + ($logicNotDeleteValue == null ? 43 : $logicNotDeleteValue.hashCode());
        String $update = this.getUpdate();
        result = result * 59 + ($update == null ? 43 : $update.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        FieldFill $fieldFill = this.getFieldFill();
        result = result * 59 + ($fieldFill == null ? 43 : $fieldFill.hashCode());
        result = result * 59 + (this.isWithInsertFill() ? 79 : 97);
        result = result * 59 + (this.isWithUpdateFill() ? 79 : 97);
        String $sqlSelect = this.getSqlSelect();
        result = result * 59 + ($sqlSelect == null ? 43 : $sqlSelect.hashCode());
        JdbcType $jdbcType = this.getJdbcType();
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        Class<TypeHandler<?>> $typeHandler = this.getTypeHandler();
        result = result * 59 + ($typeHandler == null ? 43 : $typeHandler.hashCode());
        return result;
    }
}

