/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.batch;

import com.baomidou.mybatisplus.core.batch.BatchMethod;
import com.baomidou.mybatisplus.core.batch.BatchSqlSession;
import com.baomidou.mybatisplus.core.batch.ParameterConvert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class MybatisBatch<T> {
    private final SqlSessionFactory sqlSessionFactory;
    private final List<T> dataList;

    public MybatisBatch(SqlSessionFactory sqlSessionFactory, List<T> dataList) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.dataList = dataList;
    }

    public List<BatchResult> execute(String statement) {
        return this.execute(false, statement, entity -> entity);
    }

    public List<BatchResult> execute(String statement, ParameterConvert<T> parameterConvert) {
        return this.execute(false, statement, parameterConvert);
    }

    public List<BatchResult> execute(boolean autoCommit, String statement) {
        return this.execute(autoCommit, statement, entity -> entity);
    }

    public List<BatchResult> execute(BatchMethod<T> batchMethod) {
        return this.execute(false, batchMethod);
    }

    public List<BatchResult> execute(boolean autoCommit, BatchMethod<T> batchMethod) {
        return this.execute(autoCommit, batchMethod.getStatementId(), batchMethod.getParameterConvert());
    }

    public List<BatchResult> execute(boolean autoCommit, String statement, ParameterConvert<T> parameterConvert) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, autoCommit);){
            for (T data : this.dataList) {
                sqlSession.update(statement, this.toParameter(parameterConvert, data));
            }
            List resultList = sqlSession.flushStatements();
            if (!autoCommit) {
                sqlSession.commit();
            }
            List list = resultList;
            return list;
        }
    }

    public List<BatchResult> saveOrUpdate(BatchMethod<T> insertMethod, BiPredicate<BatchSqlSession, T> insertPredicate, BatchMethod<T> updateMethod) {
        return this.saveOrUpdate(false, insertMethod, insertPredicate, updateMethod);
    }

    public List<BatchResult> saveOrUpdate(boolean autoCommit, BatchMethod<T> insertMethod, BiPredicate<BatchSqlSession, T> insertPredicate, BatchMethod<T> updateMethod) {
        ArrayList<BatchResult> resultList = new ArrayList<BatchResult>();
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, autoCommit);){
            BatchSqlSession session = new BatchSqlSession(sqlSession);
            for (T data : this.dataList) {
                if (insertPredicate.test(session, (BatchSqlSession)data)) {
                    sqlSession.insert(insertMethod.getStatementId(), this.toParameter(insertMethod.getParameterConvert(), data));
                    continue;
                }
                sqlSession.update(updateMethod.getStatementId(), this.toParameter(updateMethod.getParameterConvert(), data));
            }
            resultList.addAll(sqlSession.flushStatements());
            resultList.addAll(session.getResultBatchList());
            if (!autoCommit) {
                sqlSession.commit();
            }
            ArrayList<BatchResult> arrayList = resultList;
            return arrayList;
        }
    }

    protected Object toParameter(ParameterConvert<T> parameterConvert, T data) {
        return parameterConvert != null ? parameterConvert.convert(data) : data;
    }

    public static class Method<T> {
        private final String namespace;

        public Method(Class<?> mapperClass) {
            this.namespace = mapperClass.getName();
        }

        public BatchMethod<T> insert() {
            return new BatchMethod(this.namespace + "." + SqlMethod.INSERT_ONE.getMethod());
        }

        public <E> BatchMethod<E> insert(Function<E, T> function) {
            return new BatchMethod<Object>(this.namespace + "." + SqlMethod.INSERT_ONE.getMethod(), function::apply);
        }

        public BatchMethod<T> updateById() {
            return new BatchMethod<Object>(this.namespace + "." + SqlMethod.UPDATE_BY_ID.getMethod(), entity -> {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("et", entity);
                return param;
            });
        }

        public <E> BatchMethod<E> updateById(Function<E, T> etFunction) {
            return new BatchMethod<Object>(this.namespace + "." + SqlMethod.UPDATE_BY_ID.getMethod(), parameter -> {
                HashMap param = new HashMap();
                param.put("et", etFunction.apply(parameter));
                return param;
            });
        }

        public <E> BatchMethod<E> update(Function<E, Wrapper<T>> wrapperFunction) {
            return new BatchMethod<Object>(this.namespace + "." + SqlMethod.UPDATE.getMethod(), parameter -> {
                HashMap param = new HashMap();
                param.put("ew", wrapperFunction.apply(parameter));
                return param;
            });
        }

        public <E> BatchMethod<E> update(Function<E, T> entityFunction, Function<E, Wrapper<T>> wrapperFunction) {
            return new BatchMethod<Object>(this.namespace + "." + SqlMethod.UPDATE.getMethod(), parameter -> {
                HashMap param = new HashMap();
                param.put("et", entityFunction.apply(parameter));
                param.put("ew", wrapperFunction.apply(parameter));
                return param;
            });
        }

        public <E> BatchMethod<E> deleteById(Function<E, T> function) {
            return new BatchMethod<Object>(this.namespace + "." + SqlMethod.DELETE_BY_ID.getMethod(), function::apply);
        }

        public <T> BatchMethod<T> deleteById() {
            return new BatchMethod(this.namespace + "." + SqlMethod.DELETE_BY_ID.getMethod());
        }

        public <E> BatchMethod<E> get(String method) {
            return new BatchMethod(this.namespace + "." + method);
        }

        public <E> BatchMethod<E> get(String method, ParameterConvert<E> parameterConvert) {
            return new BatchMethod<E>(this.namespace + "." + method, parameterConvert);
        }
    }
}

