/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public final class AnnotationUtils {
    public static <T extends Annotation> T findFirstAnnotation(Class<T> annotationClazz, Field field) {
        return AnnotationUtils.getAnnotation(annotationClazz, new HashSet<Class<? extends Annotation>>(), field.getDeclaredAnnotations());
    }

    public static <T extends Annotation> T findFirstAnnotation(Class<T> annotationClazz, Class<?> clz) {
        HashSet<Class<? extends Annotation>> hashSet = new HashSet<Class<? extends Annotation>>();
        T annotation = AnnotationUtils.getAnnotation(annotationClazz, hashSet, clz.getDeclaredAnnotations());
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> currentClass = clz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            annotation = AnnotationUtils.getAnnotation(annotationClazz, hashSet, currentClass.getDeclaredAnnotations());
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static <T extends Annotation> T findFirstAnnotation(Class<T> annotationClazz, Method method) {
        return AnnotationUtils.getAnnotation(annotationClazz, new HashSet<Class<? extends Annotation>>(), method.getDeclaredAnnotations());
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClazz, Set<Class<? extends Annotation>> annotationSet, Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            if (!annotationSet.add(annotation.annotationType())) continue;
            if (annotationClazz.isAssignableFrom(annotation.annotationType())) {
                return (T)annotation;
            }
            if ((annotation = AnnotationUtils.getAnnotation(annotationClazz, annotationSet, annotation.annotationType().getDeclaredAnnotations())) == null) continue;
            return (T)annotation;
        }
        return null;
    }

    private AnnotationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

