/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.toolkit;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class PackageHelper {
    public static String[] convertTypeAliasesPackage(String typeAliasesPackage) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        String pkg = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)typeAliasesPackage) + "/*.class";
        try {
            HashSet<String> set = new HashSet<String>();
            Resource[] resources = resolver.getResources(pkg);
            if (resources != null && resources.length > 0) {
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    set.add(ClassUtils.getPackageName((String)metadataReader.getClassMetadata().getClassName()));
                }
            }
            if (!set.isEmpty()) {
                return set.toArray(new String[0]);
            }
            return new String[0];
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)"not find typeAliasesPackage: %s", (Throwable)e, (Object[])new Object[]{pkg});
        }
    }

    public static Set<Class> scanTypePackage(String typePackage) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        String pkg = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)typePackage) + "/*.class";
        try {
            HashSet<Class> set = new HashSet<Class>();
            Resource[] resources = resolver.getResources(pkg);
            if (resources != null && resources.length > 0) {
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    set.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
                }
            }
            return set;
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)"not find scanTypePackage: %s", (Throwable)e, (Object[])new Object[]{pkg});
        }
    }

    public static void mkDir(File file) {
        file.mkdirs();
    }
}

