/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.querys;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.LikeTable;
import com.baomidou.mybatisplus.generator.config.querys.AbstractDbQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoratorDbQuery
extends AbstractDbQuery {
    private final IDbQuery dbQuery;
    private final Connection connection;
    private final DbType dbType;
    private final StrategyConfig strategyConfig;
    private final String schema;
    private final Logger logger;

    public DecoratorDbQuery(@NotNull DataSourceConfig dataSourceConfig, @NotNull StrategyConfig strategyConfig) {
        this.dbQuery = dataSourceConfig.getDbQuery();
        this.connection = dataSourceConfig.getConn();
        this.dbType = dataSourceConfig.getDbType();
        this.strategyConfig = strategyConfig;
        this.schema = dataSourceConfig.getSchemaName();
        this.logger = LoggerFactory.getLogger(this.dbQuery.getClass());
    }

    @Override
    public String tablesSql() {
        String tablesSql = this.dbQuery.tablesSql();
        if (DbType.POSTGRE_SQL == this.dbType || DbType.KINGBASE_ES == this.dbType || DbType.DB2 == this.dbType || DbType.ORACLE == this.dbType) {
            tablesSql = String.format(tablesSql, this.schema);
        }
        if (this.strategyConfig.isEnableSqlFilter()) {
            StringBuilder sql = new StringBuilder(tablesSql);
            LikeTable table = this.strategyConfig.getLikeTable();
            if (table != null) {
                sql.append(" AND ").append(this.dbQuery.tableName()).append(" LIKE '").append(table.getValue()).append("'");
            } else {
                table = this.strategyConfig.getNotLikeTable();
                if (table != null) {
                    sql.append(" AND ").append(this.dbQuery.tableName()).append(" NOT LIKE '").append(table.getValue()).append("'");
                }
            }
            Set<String> tables = this.strategyConfig.getInclude();
            if (!tables.isEmpty()) {
                sql.append(" AND ").append(this.dbQuery.tableName()).append(" IN (").append(tables.stream().map(tb -> "'" + tb + "'").collect(Collectors.joining(","))).append(")");
            } else {
                tables = this.strategyConfig.getExclude();
                if (!tables.isEmpty()) {
                    sql.append(" AND ").append(this.dbQuery.tableName()).append(" NOT IN (").append(tables.stream().map(tb -> "'" + tb + "'").collect(Collectors.joining(","))).append(")");
                }
            }
            return sql.toString();
        }
        return tablesSql;
    }

    @Override
    public String tableFieldsSql() {
        return this.dbQuery.tableFieldsSql();
    }

    public String tableFieldsSql(String tableName) {
        String tableFieldsSql = this.tableFieldsSql();
        if (DbType.KINGBASE_ES == this.dbType || DbType.DB2 == this.dbType) {
            tableFieldsSql = String.format(tableFieldsSql, this.schema, tableName);
        } else if (DbType.ORACLE == this.dbType) {
            tableName = tableName.toUpperCase();
            tableFieldsSql = String.format(tableFieldsSql.replace("#schema", this.schema), tableName);
        } else if (DbType.DM == this.dbType) {
            tableName = tableName.toUpperCase();
            tableFieldsSql = String.format(tableFieldsSql, tableName);
        } else {
            tableFieldsSql = String.format(tableFieldsSql, tableName);
        }
        return tableFieldsSql;
    }

    @Override
    public String tableName() {
        return this.dbQuery.tableName();
    }

    @Override
    public String tableComment() {
        return this.dbQuery.tableComment();
    }

    @Override
    public String fieldName() {
        return this.dbQuery.fieldName();
    }

    @Override
    public String fieldType() {
        return this.dbQuery.fieldType();
    }

    @Override
    public String fieldComment() {
        return this.dbQuery.fieldComment();
    }

    @Override
    public String fieldKey() {
        return this.dbQuery.fieldKey();
    }

    @Override
    public boolean isKeyIdentity(ResultSet results) {
        try {
            return this.dbQuery.isKeyIdentity(results);
        }
        catch (SQLException e) {
            this.logger.warn("\u5224\u65ad\u4e3b\u952e\u81ea\u589e\u9519\u8bef:{}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public String[] fieldCustom() {
        return this.dbQuery.fieldCustom();
    }

    public Map<String, Object> getCustomFields(ResultSet resultSet) {
        String[] fcs = this.fieldCustom();
        if (null != fcs) {
            HashMap customMap = CollectionUtils.newHashMapWithExpectedSize((int)fcs.length);
            for (String fc : fcs) {
                try {
                    customMap.put(fc, resultSet.getObject(fc));
                }
                catch (SQLException sqlException) {
                    throw new RuntimeException("\u83b7\u53d6\u81ea\u5b9a\u4e49\u5b57\u6bb5\u9519\u8bef:", sqlException);
                }
            }
            return customMap;
        }
        return Collections.emptyMap();
    }

    public void query(String sql, Consumer<ResultSetWrapper> consumer) throws SQLException {
        this.logger.debug("\u6267\u884cSQL:{}", (Object)sql);
        int count = 0;
        long start = System.nanoTime();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                consumer.accept(new ResultSetWrapper(resultSet, this, this.dbType));
                ++count;
            }
            long end = System.nanoTime();
            this.logger.debug("\u8fd4\u56de\u8bb0\u5f55\u6570:{},\u8017\u65f6(ms):{}", (Object)count, (Object)((end - start) / 1000000L));
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void closeConnection() {
        Optional.ofNullable(this.connection).ifPresent(con -> {
            try {
                con.close();
            }
            catch (SQLException sqlException) {
                sqlException.printStackTrace();
            }
        });
    }

    public static class ResultSetWrapper {
        private final IDbQuery dbQuery;
        private final ResultSet resultSet;
        private final DbType dbType;

        ResultSetWrapper(ResultSet resultSet, IDbQuery dbQuery, DbType dbType) {
            this.resultSet = resultSet;
            this.dbQuery = dbQuery;
            this.dbType = dbType;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public String getStringResult(String columnLabel) {
            try {
                return this.resultSet.getString(columnLabel);
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(String.format("\u8bfb\u53d6[%s]\u5b57\u6bb5\u51fa\u9519!", columnLabel), sqlException);
            }
        }

        public String getFiledComment() {
            return this.getComment(this.dbQuery.fieldComment());
        }

        private String getComment(String columnLabel) {
            return StringUtils.isNotBlank((CharSequence)columnLabel) ? this.formatComment(this.getStringResult(columnLabel)) : "";
        }

        public String getTableComment() {
            return this.getComment(this.dbQuery.tableComment());
        }

        public String formatComment(String comment) {
            return StringUtils.isBlank((CharSequence)comment) ? "" : comment.replaceAll("\r\n", "\t");
        }

        public boolean isPrimaryKey() {
            String key = this.getStringResult(this.dbQuery.fieldKey());
            if (DbType.DB2 == this.dbType || DbType.SQLITE == this.dbType || DbType.CLICK_HOUSE == this.dbType) {
                return StringUtils.isNotBlank((CharSequence)key) && "1".equals(key);
            }
            return StringUtils.isNotBlank((CharSequence)key) && "PRI".equalsIgnoreCase(key);
        }
    }
}

