/*
 * Decompiled with CFR 0.152.
 */
package com.buralo.spring.boot.memcached.autoconfigure;

import com.buralo.spring.boot.memcached.autoconfigure.MemcachedProperties;
import com.buralo.spring.boot.memcached.autoconfigure.Utils;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnClass(value={MemcachedClientIF.class})
@EnableConfigurationProperties(value={MemcachedProperties.class})
public class MemcachedClientAutoConfiguration {
    @Bean
    @Autowired
    @Lazy
    @ConditionalOnMissingBean
    public MemcachedClientIF memcachedClient(MemcachedProperties properties, ObjectProvider<ConnectionFactory> connectionFactories) throws IOException {
        List addresses = properties.getServers().stream().map(Utils::toAddress).collect(Collectors.toList());
        ConnectionFactory connectionFactory = (ConnectionFactory)connectionFactories.getIfUnique();
        return connectionFactory == null ? new MemcachedClient(addresses) : new MemcachedClient(connectionFactory, addresses);
    }
}

