/*
 * Decompiled with CFR 0.152.
 */
package com.buralo.spring.boot.memcached.autoconfigure;

import com.buralo.spring.boot.memcached.autoconfigure.MemcachedProperties;
import com.buralo.spring.boot.memcached.autoconfigure.Utils;
import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheImpl;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.ConcurrentLinkedHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MemCacheDaemon.class})
@EnableConfigurationProperties(value={MemcachedProperties.class})
public class MemcachedEmbeddedServerAutoConfiguration {
    @Bean(initMethod="start", destroyMethod="stop")
    @Autowired
    @ConditionalOnMissingBean
    public MemCacheDaemon<LocalCacheElement> embeddedMemcachedDaemon(MemcachedProperties properties) {
        MemcachedProperties.Embedded embedded = properties.getEmbedded();
        ConcurrentLinkedHashMap storage = ConcurrentLinkedHashMap.create((ConcurrentLinkedHashMap.EvictionPolicy)ConcurrentLinkedHashMap.EvictionPolicy.FIFO, (int)embedded.getMaxItems(), (long)embedded.getMaxBytes(), (int)embedded.getThreads());
        MemCacheDaemon daemon = new MemCacheDaemon();
        daemon.setCache((Cache)new CacheImpl((CacheStorage)storage));
        daemon.setBinary(embedded.isBinary());
        daemon.setIdleTime(embedded.getIdleTime());
        daemon.setAddr(Utils.toAddress(embedded.getAddress()));
        daemon.setVerbose(embedded.isVerbose());
        return daemon;
    }
}

