/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMapBasedMultiset$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMapBasedMultiset$MapBasedMultisetIterator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractMultiset;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Count;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multisets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMapBasedMultiset
extends AbstractMultiset
implements Serializable {
    private transient Map backingMap;
    private transient long size;

    protected AbstractMapBasedMultiset(Map map) {
        this.backingMap = (Map)Preconditions.checkNotNull(map);
        this.size = super.size();
    }

    @Override
    public Set entrySet() {
        return super.entrySet();
    }

    @Override
    Iterator entryIterator() {
        Iterator iterator = this.backingMap.entrySet().iterator();
        return new AbstractMapBasedMultiset$1(this, iterator);
    }

    @Override
    public void clear() {
        for (Count count : this.backingMap.values()) {
            count.set(0);
        }
        this.backingMap.clear();
        this.size = 0L;
    }

    @Override
    int distinctElements() {
        return this.backingMap.size();
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public Iterator iterator() {
        return new AbstractMapBasedMultiset$MapBasedMultisetIterator(this);
    }

    @Override
    public int count(@Nullable Object object) {
        Count count = (Count)Maps.safeGet(this.backingMap, object);
        return count == null ? 0 : count.get();
    }

    @Override
    public int add(@Nullable Object object, int n) {
        int n2;
        if (n == 0) {
            return this.count(object);
        }
        Preconditions.checkArgument(n > 0, "occurrences cannot be negative: %s", n);
        Count count = (Count)this.backingMap.get(object);
        if (count == null) {
            n2 = 0;
            this.backingMap.put(object, new Count(n));
        } else {
            n2 = count.get();
            long l = (long)n2 + (long)n;
            Preconditions.checkArgument(l <= Integer.MAX_VALUE, "too many occurrences: %s", l);
            count.getAndAdd(n);
        }
        this.size += (long)n;
        return n2;
    }

    @Override
    public int remove(@Nullable Object object, int n) {
        int n2;
        if (n == 0) {
            return this.count(object);
        }
        Preconditions.checkArgument(n > 0, "occurrences cannot be negative: %s", n);
        Count count = (Count)this.backingMap.get(object);
        if (count == null) {
            return 0;
        }
        int n3 = count.get();
        if (n3 > n) {
            n2 = n;
        } else {
            n2 = n3;
            this.backingMap.remove(object);
        }
        count.addAndGet(-n2);
        this.size -= (long)n2;
        return n3;
    }

    @Override
    public int setCount(@Nullable Object object, int n) {
        int n2;
        Multisets.checkNonnegative(n, "count");
        if (n == 0) {
            Count count = (Count)this.backingMap.remove(object);
            n2 = AbstractMapBasedMultiset.getAndSet(count, n);
        } else {
            Count count = (Count)this.backingMap.get(object);
            n2 = AbstractMapBasedMultiset.getAndSet(count, n);
            if (count == null) {
                this.backingMap.put(object, new Count(n));
            }
        }
        this.size += (long)(n - n2);
        return n2;
    }

    private static int getAndSet(Count count, int n) {
        if (count == null) {
            return 0;
        }
        return count.getAndSet(n);
    }

    static /* synthetic */ Map access$000(AbstractMapBasedMultiset abstractMapBasedMultiset) {
        return abstractMapBasedMultiset.backingMap;
    }

    static /* synthetic */ long access$122(AbstractMapBasedMultiset abstractMapBasedMultiset, long l) {
        return abstractMapBasedMultiset.size -= l;
    }

    static /* synthetic */ long access$110(AbstractMapBasedMultiset abstractMapBasedMultiset) {
        return abstractMapBasedMultiset.size--;
    }
}

