/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import java.util.Collection;
import java.util.Iterator;

public class ImmutableSet$Builder
extends ImmutableCollection$Builder {
    Object[] contents;
    int size;

    public ImmutableSet$Builder() {
        this(4);
    }

    ImmutableSet$Builder(int n) {
        Preconditions.checkArgument(n >= 0, "capacity must be >= 0 but was %s", n);
        this.contents = new Object[n];
        this.size = 0;
    }

    ImmutableSet$Builder ensureCapacity(int n) {
        if (this.contents.length < n) {
            this.contents = ObjectArrays.arraysCopyOf(this.contents, ImmutableSet$Builder.expandedCapacity(this.contents.length, n));
        }
        return this;
    }

    @Override
    public ImmutableSet$Builder add(Object object) {
        this.ensureCapacity(this.size + 1);
        this.contents[this.size++] = Preconditions.checkNotNull(object);
        return this;
    }

    @Override
    public ImmutableSet$Builder addAll(Iterable iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            this.ensureCapacity(this.size + collection.size());
        }
        super.addAll(iterable);
        return this;
    }

    @Override
    public ImmutableSet$Builder addAll(Iterator iterator) {
        super.addAll(iterator);
        return this;
    }

    public ImmutableSet build() {
        ImmutableSet immutableSet = ImmutableSet.access$000(this.size, this.contents);
        this.size = immutableSet.size();
        return immutableSet;
    }
}

