/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFutureTask;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListeningExecutorService;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public abstract class AbstractListeningExecutorService
implements ListeningExecutorService {
    public ListenableFuture submit(Runnable runnable) {
        ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(runnable, null);
        this.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    public ListenableFuture submit(Runnable runnable, @Nullable Object object) {
        ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(runnable, object);
        this.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    @Override
    public ListenableFuture submit(Callable callable) {
        ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable);
        this.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    public Object invokeAny(Collection collection) {
        try {
            return MoreExecutors.invokeAnyImpl(this, collection, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError();
        }
    }

    public Object invokeAny(Collection collection, long l, TimeUnit timeUnit) {
        return MoreExecutors.invokeAnyImpl(this, collection, true, timeUnit.toNanos(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        ArrayList<ListenableFutureTask> arrayList = new ArrayList<ListenableFutureTask>(collection.size());
        boolean bl = false;
        try {
            for (Callable object : collection) {
                ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(object);
                arrayList.add(listenableFutureTask);
                this.execute(listenableFutureTask);
            }
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            bl = true;
            ArrayList<ListenableFutureTask> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection collection, long l, TimeUnit timeUnit) {
        if (collection == null || timeUnit == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        ArrayList<ListenableFutureTask> arrayList = new ArrayList<ListenableFutureTask>(collection.size());
        boolean bl = false;
        try {
            for (Callable callable : collection) {
                arrayList.add(ListenableFutureTask.create(callable));
            }
            long l3 = System.nanoTime();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.execute((Runnable)iterator.next());
                long l4 = System.nanoTime();
                l3 = l4;
                if ((l2 -= l4 - l3) > 0L) continue;
                ArrayList<ListenableFutureTask> arrayList2 = arrayList;
                return arrayList2;
            }
            for (Future object : arrayList) {
                if (object.isDone()) continue;
                if (l2 <= 0L) {
                    ArrayList<ListenableFutureTask> arrayList3 = arrayList;
                    return arrayList3;
                }
                try {
                    object.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    ArrayList<ListenableFutureTask> arrayList4 = arrayList;
                    if (!bl) {
                        for (Future future : arrayList) {
                            future.cancel(true);
                        }
                    }
                    return arrayList4;
                }
                long l5 = System.nanoTime();
                l2 -= l5 - l3;
                l3 = l5;
            }
            bl = true;
            ArrayList<ListenableFutureTask> arrayList5 = arrayList;
            return arrayList5;
        }
        finally {
            if (!bl) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }
}

