/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ClassCreator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ConstructorException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Creator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Initializer;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Parameter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ParameterFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Signature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

class ConstructorScanner {
    private List list = new ArrayList();
    private Initializer primary;
    private Signature registry;
    private Class type;

    public ConstructorScanner(Class clazz) {
        this.registry = new Signature(clazz);
        this.type = clazz;
        this.scan(clazz);
    }

    public Creator getCreator() {
        return new ClassCreator(this.list, this.registry, this.primary);
    }

    private void scan(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        if (!this.isInstantiable(clazz)) {
            throw new ConstructorException("Can not construct inner %s", clazz);
        }
        for (Constructor<?> constructor : constructorArray) {
            Signature signature = new Signature(clazz);
            if (clazz.isPrimitive()) continue;
            this.scan(constructor, signature);
        }
    }

    private void scan(Constructor constructor, Signature signature) {
        Annotation[][] annotationArray = constructor.getParameterAnnotations();
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            for (int j = 0; j < annotationArray[i].length; ++j) {
                Parameter parameter = this.process(constructor, annotationArray[i][j], i);
                if (parameter == null) continue;
                String string = parameter.getPath();
                if (signature.containsKey(string)) {
                    throw new PersistenceException("Parameter '%s' is a duplicate in %s", string, constructor);
                }
                this.registry.put(string, parameter);
                signature.put(string, parameter);
            }
        }
        if (classArray.length == signature.size()) {
            this.build(constructor, signature);
        }
    }

    private void build(Constructor constructor, Signature signature) {
        Initializer initializer = new Initializer(constructor, signature);
        if (initializer.isDefault()) {
            this.primary = initializer;
        }
        this.list.add(initializer);
    }

    private Parameter process(Constructor constructor, Annotation annotation, int n) {
        if (annotation instanceof Attribute) {
            return this.create(constructor, annotation, n);
        }
        if (annotation instanceof ElementList) {
            return this.create(constructor, annotation, n);
        }
        if (annotation instanceof ElementArray) {
            return this.create(constructor, annotation, n);
        }
        if (annotation instanceof ElementMap) {
            return this.create(constructor, annotation, n);
        }
        if (annotation instanceof Element) {
            return this.create(constructor, annotation, n);
        }
        if (annotation instanceof Text) {
            return this.create(constructor, annotation, n);
        }
        return null;
    }

    private Parameter create(Constructor constructor, Annotation annotation, int n) {
        Parameter parameter = ParameterFactory.getInstance(constructor, annotation, n);
        String string = parameter.getPath();
        if (this.registry.containsKey(string)) {
            this.validate(parameter, string);
        }
        return parameter;
    }

    private void validate(Parameter parameter, String string) {
        Parameter parameter2 = (Parameter)this.registry.get(string);
        Annotation annotation = parameter2.getAnnotation();
        if (!((Object)parameter.getAnnotation()).equals(annotation)) {
            throw new MethodException("Annotations do not match for '%s' in %s", string, this.type);
        }
        Class clazz = parameter2.getType();
        if (clazz != parameter.getType()) {
            throw new MethodException("Method types do not match for '%s' in %s", string, this.type);
        }
    }

    private boolean isInstantiable(Class clazz) {
        int n = clazz.getModifiers();
        if (Modifier.isStatic(n)) {
            return true;
        }
        return !clazz.isMemberClass();
    }
}

