/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.DefaultType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Transient;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Version;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AnnotationFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ContactList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ContactMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.FieldContact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Hierarchy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

class FieldScanner
extends ContactList {
    private final AnnotationFactory factory;
    private final Hierarchy hierarchy;
    private final DefaultType access;
    private final ContactMap done;

    public FieldScanner(Class clazz) {
        this(clazz, null);
    }

    public FieldScanner(Class clazz, DefaultType defaultType) {
        this(clazz, defaultType, true);
    }

    public FieldScanner(Class clazz, DefaultType defaultType, boolean bl) {
        this.factory = new AnnotationFactory(bl);
        this.hierarchy = new Hierarchy(clazz);
        this.done = new ContactMap();
        this.access = defaultType;
        this.scan(clazz);
    }

    private void scan(Class clazz) {
        for (Class clazz2 : this.hierarchy) {
            this.scan(clazz2, this.access);
        }
        for (Class clazz2 : this.hierarchy) {
            this.scan(clazz2, clazz);
        }
        this.build();
    }

    private void scan(Class clazz, Class clazz2) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            this.scan(field);
        }
    }

    private void scan(Field field) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = field.getDeclaredAnnotations()) {
            this.scan(field, annotation);
        }
    }

    private void scan(Class clazz, DefaultType defaultType) {
        Field[] fieldArray = clazz.getDeclaredFields();
        if (defaultType == DefaultType.FIELD) {
            for (Field field : fieldArray) {
                Class<?> clazz2 = field.getType();
                if (this.isStatic(field)) continue;
                this.process(field, clazz2);
            }
        }
    }

    private void scan(Field field, Annotation annotation) {
        if (annotation instanceof Attribute) {
            this.process(field, annotation);
        }
        if (annotation instanceof ElementUnion) {
            this.process(field, annotation);
        }
        if (annotation instanceof ElementListUnion) {
            this.process(field, annotation);
        }
        if (annotation instanceof ElementMapUnion) {
            this.process(field, annotation);
        }
        if (annotation instanceof ElementList) {
            this.process(field, annotation);
        }
        if (annotation instanceof ElementArray) {
            this.process(field, annotation);
        }
        if (annotation instanceof ElementMap) {
            this.process(field, annotation);
        }
        if (annotation instanceof Element) {
            this.process(field, annotation);
        }
        if (annotation instanceof Transient) {
            this.remove(field, annotation);
        }
        if (annotation instanceof Version) {
            this.process(field, annotation);
        }
        if (annotation instanceof Text) {
            this.process(field, annotation);
        }
    }

    private void process(Field field, Class clazz) {
        Annotation annotation = this.factory.getInstance(clazz);
        if (annotation != null) {
            this.process(field, annotation);
        }
    }

    private void process(Field field, Annotation annotation) {
        FieldContact fieldContact = new FieldContact(field, annotation);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.done.put(field, fieldContact);
    }

    private void remove(Field field, Annotation annotation) {
        this.done.remove(field);
    }

    private void build() {
        for (Contact contact : this.done) {
            this.add(contact);
        }
    }

    private boolean isStatic(Field field) {
        int n = field.getModifiers();
        return Modifier.isStatic(n);
    }
}

