/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Criteria;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Parameter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Signature;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Variable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class Initializer {
    private final List list;
    private final Constructor factory;
    private final Signature signature;

    public Initializer(Constructor constructor, Signature signature) {
        this.list = signature.getParameters();
        this.signature = signature;
        this.factory = constructor;
    }

    public boolean isDefault() {
        return this.signature.size() == 0;
    }

    public Parameter getParameter(String string) {
        return (Parameter)this.signature.get(string);
    }

    public Object getInstance(Context context) {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(new Object[0]);
    }

    public Object getInstance(Context context, Criteria criteria) {
        Object[] objectArray = this.list.toArray();
        for (int i = 0; i < this.list.size(); ++i) {
            objectArray[i] = this.getVariable(context, criteria, i);
        }
        return this.getInstance(objectArray);
    }

    private Object getVariable(Context context, Criteria criteria, int n) {
        Parameter parameter = (Parameter)this.list.get(n);
        String string = parameter.getPath(context);
        Variable variable = criteria.remove(string);
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    public double getScore(Context context, Criteria criteria) {
        Signature signature = this.signature.getSignature(context);
        for (String string : criteria) {
            Variable variable = criteria.resolve(string);
            if (variable == null) continue;
            Parameter parameter = signature.getParameter(string);
            Contact contact = variable.getContact();
            if (parameter == null) {
                String string2;
                Collection collection = variable.getNames(context);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && (parameter = signature.getParameter(string2 = (String)iterator.next())) == null) {
                }
            }
            if (!contact.isReadOnly() || parameter != null) continue;
            return -1.0;
        }
        return this.getPercentage(context, criteria);
    }

    private double getPercentage(Context context, Criteria criteria) {
        double d = 0.0;
        for (Parameter parameter : this.list) {
            String string = parameter.getPath(context);
            Variable variable = criteria.resolve(string);
            if (variable == null) {
                if (parameter.isRequired()) {
                    return -1.0;
                }
                if (!parameter.isPrimitive()) continue;
                return -1.0;
            }
            d += 1.0;
        }
        return this.getAdjustment(context, d);
    }

    private double getAdjustment(Context context, double d) {
        double d2 = (double)this.list.size() / 1000.0;
        if (d > 0.0) {
            return d2 + d / (double)this.list.size();
        }
        return d / (double)this.list.size();
    }

    private Object getInstance(Object[] objectArray) {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(objectArray);
    }

    public String toString() {
        return this.factory.toString();
    }
}

