/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.generators;

import com.carrotsearch.randomizedtesting.generators.RandomInts;
import com.carrotsearch.randomizedtesting.generators.StringGenerator;
import java.util.Random;

public class UnicodeGenerator
extends StringGenerator {
    private static final int SURROGATE_RANGE = 2048;
    private static final int CODEPOINT_RANGE = 1112063;

    @Override
    public String ofCodeUnitsLength(Random r, int minCodeUnits, int maxCodeUnits) {
        int length = RandomInts.randomIntBetween(r, minCodeUnits, maxCodeUnits);
        char[] chars = new char[length];
        int i = 0;
        while (i < chars.length) {
            int t = RandomInts.randomIntBetween(r, 0, 4);
            if (t == 0 && i < length - 1) {
                chars[i++] = (char)RandomInts.randomIntBetween(r, 55296, 56319);
                chars[i++] = (char)RandomInts.randomIntBetween(r, 56320, 57343);
                continue;
            }
            if (t <= 1) {
                chars[i++] = (char)RandomInts.randomIntBetween(r, 0, 127);
                continue;
            }
            if (t == 2) {
                chars[i++] = (char)RandomInts.randomIntBetween(r, 128, 2047);
                continue;
            }
            if (t == 3) {
                chars[i++] = (char)RandomInts.randomIntBetween(r, 2048, 55295);
                continue;
            }
            if (t != 4) continue;
            chars[i++] = (char)RandomInts.randomIntBetween(r, 57344, 65535);
        }
        return new String(chars);
    }

    @Override
    public String ofCodePointsLength(Random r, int minCodePoints, int maxCodePoints) {
        int length = RandomInts.randomIntBetween(r, minCodePoints, maxCodePoints);
        int[] chars = new int[length];
        for (int i = 0; i < chars.length; ++i) {
            int v = RandomInts.randomIntBetween(r, 0, 1112063);
            if (v >= 55296) {
                v += 2048;
            }
            chars[i] = v;
        }
        return new String(chars, 0, chars.length);
    }

    public String ofUtf8Length(Random r, int minUtf8Length, int maxUtf8Length) {
        int i;
        int length = RandomInts.randomIntBetween(r, minUtf8Length, maxUtf8Length);
        char[] buffer = new char[length * 3];
        int bytes = length;
        for (i = 0; i < buffer.length && bytes != 0; ++i) {
            int t = bytes >= 4 ? r.nextInt(5) : (bytes >= 3 ? r.nextInt(4) : (bytes >= 2 ? r.nextInt(2) : 0));
            if (t == 0) {
                buffer[i] = (char)RandomInts.randomIntBetween(r, 0, 127);
                --bytes;
                continue;
            }
            if (1 == t) {
                buffer[i] = (char)RandomInts.randomIntBetween(r, 128, 2047);
                bytes -= 2;
                continue;
            }
            if (2 == t) {
                buffer[i] = (char)RandomInts.randomIntBetween(r, 2048, 55295);
                bytes -= 3;
                continue;
            }
            if (3 == t) {
                buffer[i] = (char)RandomInts.randomIntBetween(r, 57344, 65535);
                bytes -= 3;
                continue;
            }
            if (4 != t) continue;
            buffer[i++] = (char)RandomInts.randomIntBetween(r, 55296, 56319);
            buffer[i] = (char)RandomInts.randomIntBetween(r, 56320, 57343);
            bytes -= 4;
        }
        return new String(buffer, 0, i);
    }
}

