/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractConfigIntrospector;
import com.caucho.amber.cfg.AbstractEnhancedConfig;
import com.caucho.amber.cfg.AbstractListenerConfig;
import com.caucho.amber.cfg.AbstractRelationConfig;
import com.caucho.amber.cfg.AmberConfigManager;
import com.caucho.amber.cfg.AttributeOverrideConfig;
import com.caucho.amber.cfg.AttributesConfig;
import com.caucho.amber.cfg.BasicConfig;
import com.caucho.amber.cfg.CascadeConfig;
import com.caucho.amber.cfg.ColumnConfig;
import com.caucho.amber.cfg.ColumnResultConfig;
import com.caucho.amber.cfg.Completion;
import com.caucho.amber.cfg.EmbeddableConfig;
import com.caucho.amber.cfg.EmbeddedIdConfig;
import com.caucho.amber.cfg.EntityConfig;
import com.caucho.amber.cfg.EntityListenerConfig;
import com.caucho.amber.cfg.EntityListenersConfig;
import com.caucho.amber.cfg.EntityMappingsConfig;
import com.caucho.amber.cfg.EntityResultConfig;
import com.caucho.amber.cfg.FieldResultConfig;
import com.caucho.amber.cfg.GeneratedValueConfig;
import com.caucho.amber.cfg.IdConfig;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.cfg.JoinTableConfig;
import com.caucho.amber.cfg.ManyToManyConfig;
import com.caucho.amber.cfg.ManyToOneConfig;
import com.caucho.amber.cfg.MapKeyConfig;
import com.caucho.amber.cfg.MappedSuperclassConfig;
import com.caucho.amber.cfg.NamedNativeQueryConfig;
import com.caucho.amber.cfg.NamedQueryConfig;
import com.caucho.amber.cfg.OneToManyConfig;
import com.caucho.amber.cfg.OneToOneConfig;
import com.caucho.amber.cfg.PersistenceUnitDefaultsConfig;
import com.caucho.amber.cfg.PersistenceUnitMetaDataConfig;
import com.caucho.amber.cfg.PrimaryKeyJoinColumnConfig;
import com.caucho.amber.cfg.SqlResultSetMappingConfig;
import com.caucho.amber.cfg.VersionConfig;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CompositeId;
import com.caucho.amber.field.DependentEntityOneToOneField;
import com.caucho.amber.field.EmbeddedIdField;
import com.caucho.amber.field.EmbeddedSubField;
import com.caucho.amber.field.EntityEmbeddedField;
import com.caucho.amber.field.EntityManyToManyField;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.EntityOneToManyField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.field.VersionField;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.GeneratorTableType;
import com.caucho.amber.type.ListenerType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JAccessibleObject;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfigIntrospector
extends AbstractConfigIntrospector {
    private static final Logger log = Logger.getLogger(BaseConfigIntrospector.class.getName());
    private static final L10N L = new L10N(BaseConfigIntrospector.class);
    private static final Class[] _annTypes = new Class[]{Basic.class, Column.class, javax.persistence.Id.class, EmbeddedId.class, ManyToOne.class, OneToMany.class, OneToOne.class, ManyToMany.class, Version.class, Transient.class};
    final AmberConfigManager _configManager;
    final AmberPersistenceUnit _persistenceUnit;
    ArrayList<Completion> _linkCompletions = new ArrayList();
    ArrayList<Completion> _depCompletions = new ArrayList();
    HashMap<EntityType, ArrayList<OneToOneCompletion>> _oneToOneCompletions = new HashMap();
    HashMap<String, EmbeddableConfig> _embeddableConfigMap = new HashMap();
    ArrayList<EntityMappingsConfig> _entityMappingsList;

    public BaseConfigIntrospector(AmberConfigManager manager) {
        this._configManager = manager;
        this._persistenceUnit = manager.getPersistenceUnit();
    }

    public void setEntityMappingsList(ArrayList<EntityMappingsConfig> entityMappingsList) {
        this._entityMappingsList = entityMappingsList;
    }

    public EntityConfig getEntityConfig(String className) {
        if (this._entityMappingsList == null) {
            return null;
        }
        for (EntityMappingsConfig entityMappings : this._entityMappingsList) {
            EntityConfig entityConfig;
            HashMap<String, EntityConfig> entityMap = entityMappings.getEntityMap();
            if (entityMap == null || (entityConfig = entityMap.get(className)) == null) continue;
            return entityConfig;
        }
        return null;
    }

    public MappedSuperclassConfig getMappedSuperclassConfig(String className) {
        if (this._entityMappingsList == null) {
            return null;
        }
        for (EntityMappingsConfig entityMappings : this._entityMappingsList) {
            MappedSuperclassConfig superclassConfig;
            HashMap<String, MappedSuperclassConfig> superclassMap = entityMappings.getMappedSuperclassMap();
            if (superclassMap == null || (superclassConfig = superclassMap.get(className)) == null) continue;
            return superclassConfig;
        }
        return null;
    }

    public void initMetaData(ArrayList<EntityMappingsConfig> entityMappingsList, AmberPersistenceUnit persistenceUnit) throws ConfigException {
        EntityMappingsConfig entityMappings;
        PersistenceUnitMetaDataConfig metaData = null;
        Iterator<EntityMappingsConfig> i$ = entityMappingsList.iterator();
        while (i$.hasNext() && (metaData = (entityMappings = i$.next()).getPersistenceUnitMetaData()) == null) {
        }
        if (metaData == null) {
            return;
        }
        PersistenceUnitDefaultsConfig defaults = metaData.getPersistenceUnitDefaults();
        if (defaults == null) {
            return;
        }
        EntityListenersConfig entityListeners = defaults.getEntityListeners();
        if (entityListeners == null) {
            return;
        }
        ArrayList<EntityListenerConfig> listeners = entityListeners.getEntityListeners();
        for (EntityListenerConfig listener : listeners) {
            this.introspectDefaultListener(listener, persistenceUnit);
        }
    }

    public void introspectDefaultListener(EntityListenerConfig listener, AmberPersistenceUnit persistenceUnit) throws ConfigException {
        String className;
        JClassLoader loader = persistenceUnit.getJClassLoader();
        JClass type = loader.forName(className = listener.getClassName());
        if (type == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type for <entity-listener> in orm.xml", (Object)className));
        }
        ListenerType listenerType = persistenceUnit.addDefaultListener(type);
        this.introspectListener(type, listenerType);
    }

    public void introspectEntityListeners(JClass type, EntityType entityType, AmberPersistenceUnit persistenceUnit) throws ConfigException {
        this.getInternalEntityListenersConfig(type, this._annotationCfg);
        JAnnotation entityListenersAnn = this._annotationCfg.getAnnotation();
        EntityListenersConfig entityListenersCfg = this._annotationCfg.getEntityListenersConfig();
        Object[] listeners = null;
        if (entityListenersCfg != null) {
            listeners = entityListenersCfg.getEntityListeners().toArray();
        } else if (entityListenersAnn != null) {
            listeners = (Object[])entityListenersAnn.get("value");
        } else {
            return;
        }
        String entityTypeName = entityType.getBeanClass().getName();
        for (int i = 0; i < listeners.length; ++i) {
            JClass cl;
            if (listeners[i] instanceof JClass) {
                cl = (JClass)listeners[i];
            } else {
                EntityListenerConfig listenerConfig;
                String className;
                JClassLoader loader = persistenceUnit.getJClassLoader();
                cl = loader.forName(className = (listenerConfig = (EntityListenerConfig)listeners[i]).getClassName());
                if (cl == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown type for <entity-listener> in orm.xml", (Object)className));
                }
            }
            if (persistenceUnit.getDefaultListener(cl.getName()) != null) continue;
            this.introspectEntityListener(cl, persistenceUnit, entityType, entityTypeName);
        }
    }

    public void introspectEntityListener(JClass type, AmberPersistenceUnit persistenceUnit, EntityType sourceType, String sourceClassName) throws ConfigException {
        if (type == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type for @EntityListeners annotated at class '{1}'", (Object)type.getName(), (Object)sourceClassName));
        }
        JClass parentClass = type.getSuperClass();
        if (parentClass == null) {
            return;
        }
        ListenerType listenerType = persistenceUnit.getEntityListener(type.getName());
        ListenerType newListenerType = persistenceUnit.addEntityListener(sourceClassName, type);
        if (listenerType == null) {
            listenerType = newListenerType;
            this.introspectListener(type, listenerType);
        }
        sourceType.addListener(listenerType);
    }

    public void introspectListener(JClass type, ListenerType listenerType) throws ConfigException {
        listenerType.setInstanceClassName(listenerType.getName() + "__ResinExt");
        for (JMethod method : type.getMethods()) {
            this.introspectCallbacks(listenerType, method);
        }
    }

    public void introspectCallbacks(JClass type, EntityType entityType) throws ConfigException {
        this.getInternalExcludeDefaultListenersConfig(type, this._annotationCfg);
        if (!this._annotationCfg.isNull()) {
            entityType.setExcludeDefaultListeners(true);
        }
        this.getInternalExcludeSuperclassListenersConfig(type, this._annotationCfg);
        if (!this._annotationCfg.isNull()) {
            entityType.setExcludeSuperclassListeners(true);
        }
        for (JMethod method : type.getMethods()) {
            this.introspectCallbacks(entityType, method);
        }
    }

    public void introspectCallbacks(AbstractEnhancedType type, JMethod method) throws ConfigException {
        JClass[] param = method.getParameterTypes();
        String methodName = method.getName();
        JClass jClass = type.getBeanClass();
        boolean isListener = type instanceof ListenerType;
        int n = ListenerType.CALLBACK_CLASS.length;
        for (int i = 1; i < n; ++i) {
            this.getInternalCallbackConfig(i, jClass, method, methodName, this._annotationCfg);
            if (this._annotationCfg.isNull()) continue;
            this.validateCallback(ListenerType.CALLBACK_CLASS[i].getName(), method, isListener);
            type.addCallback(i, method);
        }
    }

    void introspectNamedQueries(JClass type, String typeName) {
        this.getInternalNamedQueryConfig(type, this._annotationCfg);
        JAnnotation namedQueryAnn = this._annotationCfg.getAnnotation();
        NamedQueryConfig namedQueryConfig = this._annotationCfg.getNamedQueryConfig();
        JAnnotation namedQueriesAnn = type.getAnnotation(NamedQueries.class);
        if (namedQueryAnn == null && namedQueriesAnn == null) {
            return;
        }
        if (namedQueryAnn != null && namedQueriesAnn != null) {
            throw new ConfigException(L.l("{0} may not have both @NamedQuery and @NamedQueries", (Object)typeName));
        }
        Object[] namedQueryArray = namedQueriesAnn != null ? (Object[])namedQueriesAnn.get("value") : new Object[]{namedQueryAnn};
        for (int i = 0; i < namedQueryArray.length; ++i) {
            namedQueryAnn = (JAnnotation)namedQueryArray[i];
            this._persistenceUnit.addNamedQuery(namedQueryAnn.getString("name"), namedQueryAnn.getString("query"));
        }
    }

    void introspectNamedNativeQueries(JClass type, String typeName) {
        this.getInternalNamedNativeQueryConfig(type, this._annotationCfg);
        JAnnotation namedNativeQueryAnn = this._annotationCfg.getAnnotation();
        NamedNativeQueryConfig namedNativeQueryConfig = this._annotationCfg.getNamedNativeQueryConfig();
        JAnnotation namedNativeQueriesAnn = type.getAnnotation(NamedNativeQueries.class);
        if (namedNativeQueryAnn == null && namedNativeQueriesAnn == null) {
            return;
        }
        if (namedNativeQueryAnn != null && namedNativeQueriesAnn != null) {
            throw new ConfigException(L.l("{0} may not have both @NamedNativeQuery and @NamedNativeQueries", (Object)typeName));
        }
        Object[] namedNativeQueryArray = namedNativeQueriesAnn != null ? (Object[])namedNativeQueriesAnn.get("value") : new Object[]{namedNativeQueryAnn};
        for (int i = 0; i < namedNativeQueryArray.length; ++i) {
            namedNativeQueryAnn = (JAnnotation)namedNativeQueryArray[i];
            NamedNativeQueryConfig nativeQueryConfig = new NamedNativeQueryConfig();
            nativeQueryConfig.setQuery(namedNativeQueryAnn.getString("query"));
            nativeQueryConfig.setResultClass(namedNativeQueryAnn.getClass("resultClass").getName());
            nativeQueryConfig.setResultSetMapping(namedNativeQueryAnn.getString("resultSetMapping"));
            this._persistenceUnit.addNamedNativeQuery(namedNativeQueryAnn.getString("name"), nativeQueryConfig);
        }
    }

    void introspectSqlResultSetMappings(JClass type, EntityType entityType, String typeName) {
        this.getInternalSqlResultSetMappingConfig(type, this._annotationCfg);
        JAnnotation sqlResultSetMappingAnn = this._annotationCfg.getAnnotation();
        SqlResultSetMappingConfig sqlResultSetMappingConfig = this._annotationCfg.getSqlResultSetMappingConfig();
        JAnnotation sqlResultSetMappingsAnn = type.getAnnotation(SqlResultSetMappings.class);
        if (sqlResultSetMappingAnn == null && sqlResultSetMappingsAnn == null) {
            return;
        }
        if (sqlResultSetMappingAnn != null && sqlResultSetMappingsAnn != null) {
            throw new ConfigException(L.l("{0} may not have both @SqlResultSetMapping and @SqlResultSetMappings", (Object)typeName));
        }
        Object[] sqlResultSetMappingArray = sqlResultSetMappingsAnn != null ? (Object[])sqlResultSetMappingsAnn.get("value") : new Object[]{sqlResultSetMappingAnn};
        if (sqlResultSetMappingConfig != null) {
            this._persistenceUnit.addSqlResultSetMapping(sqlResultSetMappingConfig.getName(), sqlResultSetMappingConfig);
            return;
        }
        for (int i = 0; i < sqlResultSetMappingArray.length; ++i) {
            sqlResultSetMappingAnn = (JAnnotation)sqlResultSetMappingArray[i];
            String name = sqlResultSetMappingAnn.getString("name");
            Object[] entities = (Object[])sqlResultSetMappingAnn.get("entities");
            Object[] columns = (Object[])sqlResultSetMappingAnn.get("columns");
            SqlResultSetMappingCompletion completion = new SqlResultSetMappingCompletion(entityType, name, entities, columns);
            this._depCompletions.add(completion);
        }
    }

    void addSqlResultSetMapping(String resultSetName, Object[] entities, Object[] columns) throws ConfigException {
        int i;
        SqlResultSetMappingConfig sqlResultSetMapping = new SqlResultSetMappingConfig();
        for (i = 0; i < entities.length; ++i) {
            JAnnotation entityResult = (JAnnotation)entities[i];
            String className = entityResult.getClass("entityClass").getName();
            EntityType resultType = this._persistenceUnit.getEntityType(className);
            if (resultType == null) {
                throw new ConfigException(L.l("entityClass '{0}' is not an @Entity bean for @SqlResultSetMapping '{1}'. The entityClass of an @EntityResult must be an @Entity bean.", (Object)className, (Object)resultSetName));
            }
            EntityResultConfig entityResultConfig = new EntityResultConfig();
            entityResultConfig.setEntityClass(className);
            Object[] fields = (Object[])entityResult.get("fields");
            for (int j = 0; j < fields.length; ++j) {
                JAnnotation fieldResult = (JAnnotation)fields[j];
                String fieldName = fieldResult.getString("name");
                AmberField field = resultType.getField(fieldName);
                if (field == null) {
                    throw new ConfigException(L.l("@FieldResult with field name '{0}' is not a field for @EntityResult bean '{1}' in @SqlResultSetMapping '{2}'", (Object)fieldName, (Object)className, (Object)resultSetName));
                }
                String columnName = fieldResult.getString("column");
                if (columnName == null || columnName.length() == 0) {
                    throw new ConfigException(L.l("@FieldResult must have a column name defined and it must not be empty for '{0}' in @EntityResult '{1}' @SqlResultSetMapping '{2}'", (Object)fieldName, (Object)className, (Object)resultSetName));
                }
                FieldResultConfig fieldResultConfig = new FieldResultConfig();
                fieldResultConfig.setName(fieldName);
                fieldResultConfig.setColumn(columnName);
                entityResultConfig.addFieldResult(fieldResultConfig);
            }
            sqlResultSetMapping.addEntityResult(entityResultConfig);
        }
        for (i = 0; i < columns.length; ++i) {
            JAnnotation columnResult = (JAnnotation)columns[i];
            String columnName = columnResult.getString("name");
            if (columnName == null || columnName.length() == 0) {
                throw new ConfigException(L.l("@ColumnResult must have a column name defined and it must not be empty in @SqlResultSetMapping '{0}'", (Object)resultSetName));
            }
            ColumnResultConfig columnResultConfig = new ColumnResultConfig();
            columnResultConfig.setName(columnName);
            sqlResultSetMapping.addColumnResult(columnResultConfig);
        }
        this._persistenceUnit.addSqlResultSetMapping(resultSetName, sqlResultSetMapping);
    }

    public void configureLinks() throws ConfigException {
        RuntimeException exn = null;
        while (this._linkCompletions.size() > 0) {
            Completion completion = this._linkCompletions.remove(0);
            try {
                completion.complete();
            }
            catch (Exception e) {
                if (e instanceof ConfigException) {
                    log.warning(e.getMessage());
                    log.log(Level.FINEST, e.toString(), e);
                } else {
                    log.log(Level.WARNING, e.toString(), e);
                }
                completion.getRelatedType().setConfigException(e);
                if (exn != null) continue;
                exn = ConfigException.create((Throwable)e);
            }
        }
        if (exn != null) {
            throw exn;
        }
    }

    public void configureDependencies() throws ConfigException {
        RuntimeException exn = null;
        while (this._depCompletions.size() > 0) {
            Completion completion = this._depCompletions.remove(0);
            try {
                completion.complete();
            }
            catch (Exception e) {
                if (e instanceof ConfigException) {
                    log.warning(e.getMessage());
                    log.log(Level.FINEST, e.toString(), e);
                } else {
                    log.log(Level.WARNING, e.toString(), e);
                }
                completion.getRelatedType().setConfigException(e);
                if (exn != null) continue;
                exn = ConfigException.create((Throwable)e);
            }
        }
        if (exn != null) {
            throw exn;
        }
    }

    void introspectIdMethod(AmberPersistenceUnit persistenceUnit, EntityType entityType, EntityType parentType, JClass type, JClass idClass, MappedSuperclassConfig config) throws ConfigException, SQLException {
        CompositeId id;
        ArrayList<IdField> keys = new ArrayList<IdField>();
        IdField idField = null;
        AttributesConfig attributesConfig = null;
        if (config != null) {
            attributesConfig = config.getAttributes();
        }
        for (JMethod method : type.getMethods()) {
            String fieldName;
            String methodName = method.getName();
            JClass[] paramTypes = method.getParameterTypes();
            if (method.getDeclaringClass().getName().equals("java.lang.Object") || !methodName.startsWith("get") || paramTypes.length != 0 || BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName = BaseConfigIntrospector.toFieldName(methodName.substring(3)))) continue;
            this.getInternalIdConfig(type, method, fieldName, this._annotationCfg);
            JAnnotation id2 = this._annotationCfg.getAnnotation();
            IdConfig idConfig = this._annotationCfg.getIdConfig();
            if (!this._annotationCfg.isNull()) {
                idField = this.introspectId(persistenceUnit, entityType, method, fieldName, method.getReturnType(), idConfig);
                if (idField == null) continue;
                keys.add(idField);
                continue;
            }
            this.getInternalEmbeddedIdConfig(type, method, fieldName, this._annotationCfg);
            JAnnotation embeddedId = this._annotationCfg.getAnnotation();
            EmbeddedIdConfig embeddedIdConfig = this._annotationCfg.getEmbeddedIdConfig();
            if (this._annotationCfg.isNull()) continue;
            idField = this.introspectEmbeddedId(persistenceUnit, entityType, method, fieldName, method.getReturnType());
            break;
        }
        if (keys.size() == 0) {
            if (idField != null) {
                id = new com.caucho.amber.field.EmbeddedId(entityType, (EmbeddedIdField)idField);
                entityType.setId(id);
            }
        } else if (keys.size() == 1) {
            entityType.setId(new Id(entityType, keys));
        } else {
            if (idClass == null) {
                throw new ConfigException(L.l("{0} has multiple @Id methods, but no @IdClass.  Compound primary keys require either an @IdClass or exactly one @EmbeddedId field or property.", (Object)entityType.getName()));
            }
            id = new CompositeId(entityType, keys);
            id.setKeyClass(idClass);
            entityType.setId(id);
        }
    }

    void introspectIdField(AmberPersistenceUnit persistenceUnit, EntityType entityType, EntityType parentType, JClass type, JClass idClass, MappedSuperclassConfig config) throws ConfigException, SQLException {
        ArrayList<IdField> keys = new ArrayList<IdField>();
        AttributesConfig attributesConfig = null;
        if (config != null) {
            attributesConfig = config.getAttributes();
        }
        for (JField field : type.getFields()) {
            IdField idField;
            String fieldName = field.getName();
            if (BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName)) continue;
            this.getInternalIdConfig(type, field, fieldName, this._annotationCfg);
            JAnnotation id = this._annotationCfg.getAnnotation();
            IdConfig idConfig = this._annotationCfg.getIdConfig();
            if (this._annotationCfg.isNull()) {
                this.getInternalEmbeddedIdConfig(type, field, fieldName, this._annotationCfg);
                JAnnotation embeddedId = this._annotationCfg.getAnnotation();
                EmbeddedIdConfig embeddedIdConfig = this._annotationCfg.getEmbeddedIdConfig();
                if (this._annotationCfg.isNull()) continue;
            }
            if ((idField = this.introspectId(persistenceUnit, entityType, field, fieldName, field.getType(), idConfig)) == null) continue;
            keys.add(idField);
        }
        if (keys.size() != 0) {
            if (keys.size() == 1) {
                entityType.setId(new Id(entityType, keys));
            } else {
                if (idClass == null) {
                    throw new ConfigException(L.l("{0} has multiple @Id fields, but no @IdClass.  Compound primary keys require an @IdClass.", (Object)entityType.getName()));
                }
                CompositeId id = new CompositeId(entityType, keys);
                id.setKeyClass(idClass);
                entityType.setId(id);
                this._configManager.introspect(idClass);
            }
        }
    }

    boolean isField(JClass type, AbstractEnhancedConfig typeConfig, boolean isEmbeddable) throws ConfigException {
        if (type == null) {
            return false;
        }
        if (typeConfig != null) {
            String access = typeConfig.getAccess();
            if (access != null) {
                return access.equals("FIELD");
            }
            JClass parentClass = type.getSuperClass();
            if (parentClass == null) {
                return false;
            }
            this.getInternalEntityConfig(parentClass, this._annotationCfg);
            EntityConfig superEntityConfig = this._annotationCfg.getEntityConfig();
            if (superEntityConfig == null) {
                return false;
            }
            return this.isField(parentClass, superEntityConfig, false);
        }
        for (JField field : type.getDeclaredFields()) {
            for (Class annType : _annTypes) {
                if (field.getAnnotation(annType) == null) continue;
                return true;
            }
        }
        return this.isField(type.getSuperClass(), null, false);
    }

    private IdField introspectId(AmberPersistenceUnit persistenceUnit, EntityType entityType, JAccessibleObject field, String fieldName, JClass fieldType, IdConfig idConfig) throws ConfigException, SQLException {
        JAnnotation id = field.getAnnotation(javax.persistence.Id.class);
        JAnnotation column = field.getAnnotation(Column.class);
        ColumnConfig columnConfig = null;
        GeneratedValueConfig generatedValueConfig = null;
        if (idConfig != null) {
            columnConfig = idConfig.getColumn();
            generatedValueConfig = idConfig.getGeneratedValue();
        }
        JAnnotation gen = field.getAnnotation(GeneratedValue.class);
        Type amberType = persistenceUnit.createType(fieldType);
        com.caucho.amber.table.Column keyColumn = null;
        keyColumn = this.createColumn(entityType, field, fieldName, column, amberType, columnConfig);
        if (entityType.getTable() == null) {
            KeyPropertyField idField = new KeyPropertyField(entityType, fieldName, keyColumn);
            return idField;
        }
        KeyPropertyField idField = new KeyPropertyField(entityType, fieldName, keyColumn);
        if (gen != null) {
            Object metaData = null;
            if (GenerationType.IDENTITY.equals(gen.get("strategy"))) {
                keyColumn.setGeneratorType("identity");
                idField.setGenerator("identity");
            } else if (GenerationType.SEQUENCE.equals(gen.get("strategy"))) {
                this.addSequenceIdGenerator(persistenceUnit, idField, gen);
            } else if (GenerationType.TABLE.equals(gen.get("strategy"))) {
                this.addTableIdGenerator(persistenceUnit, idField, id);
            } else if (GenerationType.AUTO.equals(gen.get("strategy"))) {
                keyColumn.setGeneratorType("auto");
                idField.setGenerator("auto");
            }
        }
        return idField;
    }

    private IdField introspectEmbeddedId(AmberPersistenceUnit persistenceUnit, EntityType ownerType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException, SQLException {
        EmbeddableType embeddableType = (EmbeddableType)this._configManager.introspect(fieldType);
        if (embeddableType == null) {
            throw new IllegalStateException("" + fieldType + " is an unsupported embeddable type");
        }
        EmbeddedIdField idField = new EmbeddedIdField(ownerType, embeddableType, fieldName);
        return idField;
    }

    void addSequenceIdGenerator(AmberPersistenceUnit persistenceUnit, KeyPropertyField idField, JAnnotation genAnn) throws ConfigException {
        idField.setGenerator("sequence");
        idField.getColumn().setGeneratorType("sequence");
        String name = genAnn.getString("generator");
        if (name == null || "".equals(name)) {
            name = idField.getEntitySourceType().getTable().getName() + "_cseq";
        }
    }

    void addTableIdGenerator(AmberPersistenceUnit persistenceUnit, KeyPropertyField idField, JAnnotation idAnn) throws ConfigException {
        IdGenerator gen;
        idField.setGenerator("table");
        idField.getColumn().setGeneratorType("table");
        String name = idAnn.getString("generator");
        if (name == null || "".equals(name)) {
            name = "caucho";
        }
        if ((gen = persistenceUnit.getTableGenerator(name)) == null) {
            String genName = "GEN_TABLE";
            GeneratorTableType genTable = persistenceUnit.createGeneratorTable(genName);
            gen = genTable.createGenerator(name);
            genTable.init();
            persistenceUnit.putTableGenerator(name, gen);
        }
        idField.getEntitySourceType().setGenerator(idField.getName(), gen);
    }

    void linkSecondaryTable(com.caucho.amber.table.Table primaryTable, com.caucho.amber.table.Table secondaryTable, JAnnotation[] joinColumnsAnn) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (com.caucho.amber.table.Column column : primaryTable.getIdColumns()) {
            JAnnotation joinAnn = BaseConfigIntrospector.getJoinColumn(joinColumnsAnn, column.getName());
            String name = joinAnn == null ? column.getName() : joinAnn.getString("name");
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    void linkInheritanceTable(com.caucho.amber.table.Table primaryTable, com.caucho.amber.table.Table secondaryTable, JAnnotation joinAnn, PrimaryKeyJoinColumnConfig pkJoinColumnCfg) throws ConfigException {
        JAnnotation[] joinAnns = null;
        if (joinAnn != null) {
            joinAnns = new JAnnotation[]{joinAnn};
        }
        this.linkInheritanceTable(primaryTable, secondaryTable, joinAnns, pkJoinColumnCfg);
    }

    void linkInheritanceTable(com.caucho.amber.table.Table primaryTable, com.caucho.amber.table.Table secondaryTable, JAnnotation[] joinColumnsAnn, PrimaryKeyJoinColumnConfig pkJoinColumnCfg) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (com.caucho.amber.table.Column column : primaryTable.getIdColumns()) {
            JAnnotation join;
            String name = joinColumnsAnn == null ? (pkJoinColumnCfg == null ? column.getName() : pkJoinColumnCfg.getName()) : ((join = BaseConfigIntrospector.getJoinColumn(joinColumnsAnn, column.getName())) == null ? column.getName() : join.getString("name"));
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    void introspectMethods(AmberPersistenceUnit persistenceUnit, BeanType entityType, BeanType parentType, JClass type, AbstractEnhancedConfig typeConfig) throws ConfigException {
        for (JMethod method : type.getMethods()) {
            String propName;
            String methodName = method.getName();
            JClass[] paramTypes = method.getParameterTypes();
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) continue;
            if (paramTypes.length != 0) {
                this.validateNonGetter(method);
                continue;
            }
            if (methodName.startsWith("get")) {
                propName = methodName.substring(3);
            } else if (methodName.startsWith("is") && (method.getReturnType().getName().equals("boolean") || method.getReturnType().getName().equals("java.lang.Boolean"))) {
                propName = methodName.substring(2);
            } else {
                this.validateNonGetter(method);
                continue;
            }
            this.getInternalVersionConfig(type, method, propName, this._annotationCfg);
            JAnnotation versionAnn = this._annotationCfg.getAnnotation();
            VersionConfig versionConfig = this._annotationCfg.getVersionConfig();
            if (!this._annotationCfg.isNull()) {
                this.validateNonGetter(method);
            } else {
                JMethod setter = type.getMethod("set" + propName, new JClass[]{method.getReturnType()});
                if (method.isPrivate() || setter == null || setter.isPrivate()) {
                    JAnnotation ann = this.isAnnotatedMethod(method);
                    if (ann == null) {
                        if (setter != null) {
                            ann = this.isAnnotatedMethod(setter);
                        }
                    } else if (ann.getType().equals("javax.persistence.Transient")) continue;
                    if (ann == null) continue;
                    throw BaseConfigIntrospector.error(method, L.l("'{0}' is not a valid annotation for {1}.  Only public persistent property getters with matching setters may have property annotations.", (Object)ann.getType(), (Object)method.getFullName()));
                }
                if (method.isStatic()) {
                    this.validateNonGetter(method);
                    continue;
                }
            }
            String fieldName = BaseConfigIntrospector.toFieldName(propName);
            if (BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName)) continue;
            JClass fieldType = method.getReturnType();
            this.introspectField(persistenceUnit, entityType, method, fieldName, fieldType, typeConfig);
        }
    }

    void introspectFields(AmberPersistenceUnit persistenceUnit, BeanType entityType, BeanType parentType, JClass type, AbstractEnhancedConfig typeConfig, boolean isEmbeddable) throws ConfigException {
        if (entityType.isEntity() && ((EntityType)entityType).getId() == null) {
            throw new ConfigException(L.l("{0} has no key", (Object)entityType));
        }
        for (JField field : type.getDeclaredFields()) {
            String fieldName = field.getName();
            if (BaseConfigIntrospector.containsFieldOrCompletion(parentType, fieldName) || field.isStatic() || field.isTransient()) continue;
            JClass fieldType = field.getType();
            this.introspectField(persistenceUnit, entityType, field, fieldName, fieldType, typeConfig);
        }
    }

    void introspectField(AmberPersistenceUnit persistenceUnit, BeanType sourceType, JAccessibleObject field, String fieldName, JClass fieldType, AbstractEnhancedConfig typeConfig) throws ConfigException {
        EmbeddableConfig embeddableConfig = null;
        MappedSuperclassConfig mappedSuperOrEntityConfig = null;
        if (typeConfig instanceof EmbeddableConfig) {
            embeddableConfig = (EmbeddableConfig)typeConfig;
        } else if (typeConfig instanceof MappedSuperclassConfig) {
            mappedSuperOrEntityConfig = (MappedSuperclassConfig)typeConfig;
        }
        JClass jClass = field.getDeclaringClass();
        if (jClass.isInterface()) {
            return;
        }
        BeanType declaringType = this._persistenceUnit.getEntityType(jClass.getName());
        if (declaringType == null) {
            declaringType = this._persistenceUnit.getEmbeddable(jClass.getName());
        }
        if (declaringType == null) {
            declaringType = this._persistenceUnit.getMappedSuperclass(jClass.getName());
        }
        if (declaringType == null) {
            return;
        }
        AttributesConfig attributesConfig = null;
        IdConfig idConfig = null;
        BasicConfig basicConfig = null;
        OneToOneConfig oneToOneConfig = null;
        OneToManyConfig oneToManyConfig = null;
        ManyToOneConfig manyToOneConfig = null;
        ManyToManyConfig manyToManyConfig = null;
        VersionConfig versionConfig = null;
        if (mappedSuperOrEntityConfig != null && (attributesConfig = mappedSuperOrEntityConfig.getAttributes()) != null) {
            idConfig = attributesConfig.getId(fieldName);
            basicConfig = attributesConfig.getBasic(fieldName);
            oneToOneConfig = attributesConfig.getOneToOne(fieldName);
            oneToManyConfig = attributesConfig.getOneToMany(fieldName);
            manyToOneConfig = attributesConfig.getManyToOne(fieldName);
            manyToManyConfig = attributesConfig.getManyToMany(fieldName);
            versionConfig = attributesConfig.getVersion(fieldName);
        }
        if (idConfig != null || field.isAnnotationPresent(javax.persistence.Id.class)) {
            BaseConfigIntrospector.validateAnnotations(field, "@Id", _idAnnotations);
            if (!_idTypes.contains(fieldType.getName())) {
                throw BaseConfigIntrospector.error(field, L.l("{0} is an invalid @Id type for {1}.", (Object)fieldType.getName(), (Object)field.getName()));
            }
        } else if (basicConfig != null || field.isAnnotationPresent(Basic.class)) {
            BaseConfigIntrospector.validateAnnotations(field, "@Basic", _basicAnnotations);
            this.addBasic(sourceType, field, fieldName, fieldType, basicConfig);
        } else if (versionConfig != null || field.isAnnotationPresent(Version.class)) {
            BaseConfigIntrospector.validateAnnotations(field, "@Version", _versionAnnotations);
            this.addVersion((EntityType)sourceType, field, fieldName, fieldType, versionConfig);
        } else if (manyToOneConfig != null || field.isAnnotationPresent(ManyToOne.class)) {
            BaseConfigIntrospector.validateAnnotations(field, "@ManyToOne", _manyToOneAnnotations);
            JAnnotation ann = field.getAnnotation(ManyToOne.class);
            JClass targetEntity = null;
            if (ann != null) {
                targetEntity = ann.getClass("targetEntity");
            } else {
                String s = manyToOneConfig.getTargetEntity();
                if (s != null && s.length() > 0) {
                    targetEntity = this._persistenceUnit.getJClassLoader().forName(s);
                }
            }
            if (targetEntity == null || targetEntity.getName().equals("void")) {
                targetEntity = fieldType;
            }
            this.getInternalEntityConfig(targetEntity, this._annotationCfg);
            JAnnotation targetEntityAnn = this._annotationCfg.getAnnotation();
            EntityConfig targetEntityConfig = this._annotationCfg.getEntityConfig();
            if (this._annotationCfg.isNull()) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal targetEntity for {1}.  @ManyToOne relations must target a valid @Entity.", (Object)targetEntity.getName(), (Object)field.getName()));
            }
            if (!fieldType.isAssignableFrom(targetEntity)) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal targetEntity for {1}.  @ManyToOne targetEntity must be assignable to the field type '{2}'.", (Object)targetEntity.getName(), (Object)field.getName(), (Object)fieldType.getName()));
            }
            EntityType entityType = (EntityType)sourceType;
            entityType.setHasDependent(true);
            this._linkCompletions.add(new ManyToOneCompletion(entityType, field, fieldName, fieldType));
        } else if (oneToManyConfig != null || field.isAnnotationPresent(OneToMany.class)) {
            BaseConfigIntrospector.validateAnnotations(field, "@OneToMany", _oneToManyAnnotations);
            if (field.isAnnotationPresent(MapKey.class)) {
                if (!fieldType.getName().equals("java.util.Map")) {
                    throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal @OneToMany/@MapKey type for {1}. @MapKey must be a java.util.Map", (Object)fieldType.getName(), (Object)field.getName()));
                }
            } else if (!_oneToManyTypes.contains(fieldType.getName())) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal @OneToMany type for {1}.  @OneToMany must be a java.util.Collection, java.util.List or java.util.Map", (Object)fieldType.getName(), (Object)field.getName()));
            }
            EntityType entityType = (EntityType)sourceType;
            this._depCompletions.add(new OneToManyCompletion(entityType, field, fieldName, fieldType, oneToManyConfig));
        } else if (oneToOneConfig != null || field.isAnnotationPresent(OneToOne.class)) {
            boolean isOwner;
            String mappedBy;
            BaseConfigIntrospector.validateAnnotations(field, "@OneToOne", _oneToOneAnnotations);
            EntityType entityType = (EntityType)sourceType;
            OneToOneCompletion oneToOne = new OneToOneCompletion(entityType, field, fieldName, fieldType);
            if (oneToOneConfig != null) {
                mappedBy = oneToOneConfig.getMappedBy();
            } else {
                JAnnotation oneToOneAnn = field.getAnnotation(OneToOne.class);
                mappedBy = oneToOneAnn.getString("mappedBy");
            }
            boolean bl = isOwner = mappedBy == null || mappedBy.equals("");
            if (isOwner) {
                this._linkCompletions.add(oneToOne);
            } else {
                this._depCompletions.add(0, oneToOne);
                entityType.setHasDependent(true);
            }
            ArrayList<OneToOneCompletion> oneToOneList = this._oneToOneCompletions.get(entityType);
            if (oneToOneList == null) {
                oneToOneList = new ArrayList();
                this._oneToOneCompletions.put(entityType, oneToOneList);
            }
            oneToOneList.add(oneToOne);
        } else if (manyToManyConfig != null || field.isAnnotationPresent(ManyToMany.class)) {
            if (field.isAnnotationPresent(MapKey.class) && !fieldType.getName().equals("java.util.Map")) {
                throw BaseConfigIntrospector.error(field, L.l("'{0}' is an illegal @ManyToMany/@MapKey type for {1}. @MapKey must be a java.util.Map", (Object)fieldType.getName(), (Object)field.getName()));
            }
            EntityType entityType = (EntityType)sourceType;
            ManyToManyCompletion completion = new ManyToManyCompletion(entityType, field, fieldName, fieldType);
            JAnnotation ann = field.getAnnotation(ManyToMany.class);
            String mappedBy = ann != null ? ann.getString("mappedBy") : manyToManyConfig.getMappedBy();
            if ("".equals(mappedBy)) {
                this._linkCompletions.add(completion);
            } else {
                this._depCompletions.add(completion);
            }
        } else if (field.isAnnotationPresent(Embedded.class)) {
            BaseConfigIntrospector.validateAnnotations(field, "@Embedded", _embeddedAnnotations);
            EntityType entityType = (EntityType)sourceType;
            entityType.setHasDependent(true);
            this._depCompletions.add(new EmbeddedCompletion(entityType, field, fieldName, fieldType, false));
        } else if (field.isAnnotationPresent(EmbeddedId.class)) {
            BaseConfigIntrospector.validateAnnotations(field, "@EmbeddedId", _embeddedIdAnnotations);
            this._depCompletions.add(new EmbeddedCompletion((EntityType)sourceType, field, fieldName, fieldType, true));
        } else if (!field.isAnnotationPresent(Transient.class)) {
            this.addBasic(sourceType, field, fieldName, fieldType, basicConfig);
        }
    }

    void addBasic(BeanType sourceType, JAccessibleObject field, String fieldName, JClass fieldType, BasicConfig basicConfig) throws ConfigException {
        Type amberType;
        AmberPersistenceUnit persistenceUnit = sourceType.getPersistenceUnit();
        JAnnotation basicAnn = field.getAnnotation(Basic.class);
        JAnnotation columnAnn = field.getAnnotation(Column.class);
        JAnnotation enumeratedAnn = field.getAnnotation(Enumerated.class);
        ColumnConfig columnConfig = null;
        if (basicConfig != null) {
            columnConfig = basicConfig.getColumn();
        }
        if (!_basicTypes.contains(fieldType.getName()) && !fieldType.isAssignableTo(Serializable.class)) {
            throw BaseConfigIntrospector.error(field, L.l("{0} is an invalid @Basic type for {1}.", (Object)fieldType.getName(), (Object)field.getName()));
        }
        if (enumeratedAnn == null) {
            amberType = persistenceUnit.createType(fieldType);
        } else {
            com.caucho.amber.type.EnumType enumType = persistenceUnit.createEnum(fieldType.getName(), fieldType);
            enumType.setOrdinal(enumeratedAnn.get("value") == EnumType.ORDINAL);
            amberType = enumType;
        }
        com.caucho.amber.table.Column fieldColumn = null;
        fieldColumn = this.createColumn(sourceType, field, fieldName, columnAnn, amberType, columnConfig);
        PropertyField property = new PropertyField(sourceType, fieldName);
        property.setColumn(fieldColumn);
        property.setType(amberType);
        if (basicAnn != null) {
            property.setLazy(basicAnn.get("fetch") == FetchType.LAZY);
        } else if (basicConfig != null) {
            property.setLazy(basicConfig.getFetch() == FetchType.LAZY);
        } else {
            property.setLazy(false);
        }
        sourceType.addField(property);
    }

    void addVersion(EntityType sourceType, JAccessibleObject field, String fieldName, JClass fieldType, VersionConfig versionConfig) throws ConfigException {
        AmberPersistenceUnit persistenceUnit = sourceType.getPersistenceUnit();
        JAnnotation columnAnn = field.getAnnotation(Column.class);
        ColumnConfig columnConfig = null;
        if (versionConfig != null) {
            columnConfig = versionConfig.getColumn();
        }
        if (!_versionTypes.contains(fieldType.getName())) {
            throw BaseConfigIntrospector.error(field, L.l("{0} is an invalid @Version type for {1}.", (Object)fieldType.getName(), (Object)field.getName()));
        }
        Type amberType = persistenceUnit.createType(fieldType);
        com.caucho.amber.table.Column fieldColumn = this.createColumn(sourceType, field, fieldName, columnAnn, amberType, columnConfig);
        VersionField version = new VersionField(sourceType, fieldName);
        version.setColumn(fieldColumn);
        sourceType.setVersionField(version);
    }

    private com.caucho.amber.table.Column createColumn(BeanType beanType, JAccessibleObject field, String fieldName, JAnnotation columnAnn, Type amberType, ColumnConfig columnConfig) throws ConfigException {
        EntityType entityType = null;
        if (beanType instanceof EntityType) {
            entityType = (EntityType)beanType;
        }
        String name = columnAnn != null && !columnAnn.get("name").equals("") ? (String)columnAnn.get("name") : (columnConfig != null && !columnConfig.getName().equals("") ? columnConfig.getName() : BaseConfigIntrospector.toSqlName(fieldName));
        com.caucho.amber.table.Column column = null;
        if (entityType == null) {
            column = new com.caucho.amber.table.Column(null, name, amberType);
        } else if (columnAnn != null && !columnAnn.get("table").equals("")) {
            String tableName = columnAnn.getString("table");
            com.caucho.amber.table.Table table = entityType.getSecondaryTable(tableName);
            if (table == null) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column(table='{1}') is an unknown secondary table.", (Object)fieldName, (Object)tableName));
            }
            column = table.createColumn(name, amberType);
        } else {
            column = entityType.getTable() != null ? entityType.getTable().createColumn(name, amberType) : new com.caucho.amber.table.Column(null, name, amberType);
        }
        if (column != null && columnAnn != null) {
            column.setUnique(columnAnn.getBoolean("unique"));
            column.setNotNull(!columnAnn.getBoolean("nullable"));
            if (!"".equals(columnAnn.getString("columnDefinition"))) {
                column.setSQLType(columnAnn.getString("columnDefinition"));
            }
            column.setLength(columnAnn.getInt("length"));
            int precision = columnAnn.getInt("precision");
            if (precision < 0) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column precision cannot be less than 0.", (Object)fieldName));
            }
            int scale = columnAnn.getInt("scale");
            if (scale < 0) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column scale cannot be less than 0.", (Object)fieldName));
            }
            if (scale > precision) {
                throw BaseConfigIntrospector.error(field, L.l("{0} @Column scale cannot be greater than precision. Must set precision to a non-zero value before setting scale.", (Object)fieldName));
            }
            if (precision > 0) {
                column.setPrecision(precision);
                column.setScale(scale);
            }
        }
        return column;
    }

    void addManyToOne(EntityType sourceType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException {
        Object[] cascade;
        AmberPersistenceUnit persistenceUnit = sourceType.getPersistenceUnit();
        this.getInternalManyToOneConfig(sourceType.getBeanClass(), field, fieldName, this._annotationCfg);
        JAnnotation manyToOneAnn = this._annotationCfg.getAnnotation();
        AbstractRelationConfig manyToOneConfig = this._annotationCfg.getManyToOneConfig();
        HashMap<String, JoinColumnConfig> joinColumnMap = null;
        CascadeType[] cascadeTypes = null;
        JClass parentClass = sourceType.getBeanClass();
        do {
            AttributesConfig attributesConfig;
            this.getInternalEntityConfig(parentClass, this._annotationCfg);
            JAnnotation parentEntity = this._annotationCfg.getAnnotation();
            EntityConfig superEntityConfig = this._annotationCfg.getEntityConfig();
            if (superEntityConfig == null || (attributesConfig = superEntityConfig.getAttributes()) == null || manyToOneConfig != null) continue;
            manyToOneConfig = attributesConfig.getManyToOne(fieldName);
        } while ((parentClass = parentClass.getSuperClass()) != null && manyToOneConfig == null);
        FetchType fetchType = FetchType.EAGER;
        JClass targetClass = null;
        boolean isManyToOne = true;
        if (manyToOneAnn == null && manyToOneConfig == null) {
            isManyToOne = false;
            this.getInternalOneToOneConfig(sourceType.getBeanClass(), field, fieldName, this._annotationCfg);
            manyToOneAnn = this._annotationCfg.getAnnotation();
            manyToOneConfig = this._annotationCfg.getOneToOneConfig();
            if (manyToOneConfig != null) {
                fetchType = ((OneToOneConfig)manyToOneConfig).getFetch();
                joinColumnMap = ((OneToOneConfig)manyToOneConfig).getJoinColumnMap();
                String s = ((OneToOneConfig)manyToOneConfig).getTargetEntity();
                if (s != null) {
                    targetClass = this._persistenceUnit.getJClassLoader().forName(s);
                }
            }
        } else if (manyToOneConfig != null) {
            String s;
            fetchType = manyToOneConfig.getFetch();
            joinColumnMap = manyToOneConfig.getJoinColumnMap();
            cascade = manyToOneConfig.getCascade();
            if (cascade != null) {
                cascadeTypes = cascade.getCascadeTypes();
            }
            if ((s = manyToOneConfig.getTargetEntity()) != null) {
                targetClass = this._persistenceUnit.getJClassLoader().forName(s);
            }
        }
        if (manyToOneAnn != null) {
            fetchType = (FetchType)manyToOneAnn.get("fetch");
            targetClass = manyToOneAnn.getClass("targetEntity");
            cascade = (Object[])manyToOneAnn.get("cascade");
            cascadeTypes = new CascadeType[cascade.length];
            for (int i = 0; i < cascade.length; ++i) {
                cascadeTypes[i] = (CascadeType)cascade[i];
            }
        }
        if (fetchType == FetchType.EAGER && sourceType.getBeanClass().getName().equals(fieldType.getName())) {
            throw BaseConfigIntrospector.error(field, L.l("'{0}': '{1}' is an illegal recursive type for @OneToOne/@ManyToOne with EAGER fetching. You should specify FetchType.LAZY for this relationship.", (Object)field.getName(), (Object)fieldType.getName()));
        }
        JAnnotation joinColumns = field.getAnnotation(JoinColumns.class);
        Object[] joinColumnsAnn = null;
        if (joinColumns != null) {
            joinColumnsAnn = (Object[])joinColumns.get("value");
        }
        JAnnotation joinColumnAnn = field.getAnnotation(JoinColumn.class);
        if (joinColumnsAnn != null && joinColumnAnn != null) {
            throw BaseConfigIntrospector.error(field, L.l("{0} may not have both @JoinColumn and @JoinColumns", (Object)field.getName()));
        }
        if (joinColumnAnn != null) {
            joinColumnsAnn = new Object[]{joinColumnAnn};
        }
        String targetName = "";
        if (targetClass != null) {
            targetName = targetClass.getName();
        }
        if (targetName.equals("") || targetName.equals("void")) {
            targetName = fieldType.getName();
        }
        EntityManyToOneField manyToOneField = new EntityManyToOneField(sourceType, fieldName, cascadeTypes, isManyToOne);
        EntityType targetType = persistenceUnit.createEntity(targetName, fieldType);
        manyToOneField.setType(targetType);
        manyToOneField.setLazy(fetchType == FetchType.LAZY);
        manyToOneField.setJoinColumns(joinColumnsAnn);
        manyToOneField.setJoinColumnMap(joinColumnMap);
        sourceType.addField(manyToOneField);
        if (sourceType instanceof MappedSuperclassType) {
            return;
        }
        this.validateJoinColumns(field, joinColumnsAnn, joinColumnMap, targetType);
        manyToOneField.init();
    }

    public static JAnnotation getJoinColumn(JAnnotation joinColumns, String keyName) {
        if (joinColumns == null) {
            return null;
        }
        return BaseConfigIntrospector.getJoinColumn((Object[])joinColumns.get("value"), keyName);
    }

    void validateJoinColumns(JAccessibleObject field, Object[] columnsAnn, HashMap<String, JoinColumnConfig> joinColumnMap, EntityType targetType) throws ConfigException {
        int size;
        int idCols;
        if (joinColumnMap == null && columnsAnn == null) {
            return;
        }
        Id id = targetType.getId();
        EntityType parentType = targetType;
        while ((idCols = id.getColumns().size()) == 0 && (parentType = parentType.getParentType()) != null) {
            id = parentType.getId();
        }
        Object[] joinColumnCfg = null;
        if (columnsAnn != null) {
            size = columnsAnn.length;
        } else {
            size = joinColumnMap.size();
            joinColumnCfg = joinColumnMap.values().toArray();
        }
        if (idCols != size) {
            throw BaseConfigIntrospector.error(field, L.l("Number of @JoinColumns for '{1}' ({0}) does not match the number of primary key columns for '{3}' ({2}).", (Object)("" + size), (Object)field.getName(), (Object)idCols, (Object)targetType.getName()));
        }
        for (int i = 0; i < size; ++i) {
            String ref;
            if (joinColumnCfg != null) {
                ref = ((JoinColumnConfig)joinColumnCfg[i]).getReferencedColumnName();
            } else {
                JAnnotation ann = (JAnnotation)columnsAnn[i];
                ref = ann.getString("referencedColumnName");
            }
            if ((ref == null || ref.equals("")) && size > 1) {
                throw BaseConfigIntrospector.error(field, L.l("referencedColumnName is required when more than one @JoinColumn is specified."));
            }
            com.caucho.amber.table.Column column = this.findColumn(id.getColumns(), ref);
            if (column != null) continue;
            throw BaseConfigIntrospector.error(field, L.l("referencedColumnName '{0}' does not match any key column in '{1}'.", (Object)ref, (Object)targetType.getName()));
        }
    }

    private com.caucho.amber.table.Column findColumn(ArrayList<com.caucho.amber.table.Column> columns, String ref) {
        if ((ref == null || ref.equals("")) && columns.size() == 1) {
            return columns.get(0);
        }
        for (com.caucho.amber.table.Column column : columns) {
            if (!column.getName().equals(ref)) continue;
            return column;
        }
        return null;
    }

    public static JAnnotation getJoinColumn(Object[] columnsAnn, String keyName) {
        if (columnsAnn == null || columnsAnn.length == 0) {
            return null;
        }
        for (int i = 0; i < columnsAnn.length; ++i) {
            JAnnotation ann = (JAnnotation)columnsAnn[i];
            String ref = ann.getString("referencedColumnName");
            if (!ref.equals("") && !ref.equals(keyName)) continue;
            return ann;
        }
        return null;
    }

    void addManyToMany(EntityType sourceType, JAccessibleObject field, String fieldName, JClass fieldType) throws ConfigException {
        Object[] cascade;
        String mappedBy;
        EntityType targetType;
        this.getInternalManyToManyConfig(sourceType.getBeanClass(), field, fieldName, this._annotationCfg);
        JAnnotation manyToManyAnn = this._annotationCfg.getAnnotation();
        ManyToManyConfig manyToManyConfig = this._annotationCfg.getManyToManyConfig();
        boolean isLazy = manyToManyAnn != null ? manyToManyAnn.get("fetch") == FetchType.LAZY : manyToManyConfig.getFetch() == FetchType.LAZY;
        JType retType = field instanceof JField ? ((JField)field).getGenericType() : ((JMethod)field).getGenericReturnType();
        JType[] typeArgs = retType.getActualTypeArguments();
        String targetName = "";
        if (manyToManyAnn != null) {
            JClass targetEntity = manyToManyAnn.getClass("targetEntity");
            if (targetEntity != null) {
                targetName = targetEntity.getName();
            }
        } else {
            targetName = manyToManyConfig.getTargetEntity();
        }
        if (targetName.equals("") || targetName.equals("void")) {
            if (typeArgs.length > 0) {
                targetName = typeArgs[0].getName();
            } else {
                throw BaseConfigIntrospector.error(field, L.l("Can't determine targetEntity for {0}.  @OneToMany properties must target @Entity beans.", (Object)field.getName()));
            }
        }
        if ((targetType = this._persistenceUnit.getEntityType(targetName)) == null) {
            throw BaseConfigIntrospector.error(field, L.l("targetEntity '{0}' is not an @Entity bean for {1}.  The targetEntity of a @ManyToMany collection must be an @Entity bean.", (Object)targetName, (Object)field.getName()));
        }
        CascadeType[] cascadeTypes = null;
        if (manyToManyAnn != null) {
            mappedBy = manyToManyAnn.getString("mappedBy");
            cascade = (Object[])manyToManyAnn.get("cascade");
            cascadeTypes = new CascadeType[cascade.length];
            for (int i = 0; i < cascade.length; ++i) {
                cascadeTypes[i] = (CascadeType)cascade[i];
            }
        } else {
            mappedBy = manyToManyConfig.getMappedBy();
            cascade = manyToManyConfig.getCascade();
            if (cascade != null) {
                cascadeTypes = cascade.getCascadeTypes();
            }
        }
        if (mappedBy != null && !"".equals(mappedBy)) {
            String columnName;
            ArrayList<ForeignColumn> columns;
            EntityManyToManyField sourceField = (EntityManyToManyField)targetType.getField(mappedBy);
            if (sourceField == null) {
                throw BaseConfigIntrospector.error(field, L.l("Unable to find the associated field in '{0}' for a @ManyToMany relationship from '{1}'", (Object)targetName, (Object)field.getName()));
            }
            EntityManyToManyField manyToManyField = new EntityManyToManyField(sourceType, fieldName, sourceField, cascadeTypes);
            manyToManyField.setType(targetType);
            sourceType.addField(manyToManyField);
            if (!sourceField.hasJoinColumns()) {
                LinkColumns sourceLink = sourceField.getSourceLink();
                columns = sourceLink.getColumns();
                for (ForeignColumn column : columns) {
                    columnName = column.getName();
                    columnName = columnName.substring(columnName.indexOf(95));
                    columnName = BaseConfigIntrospector.toSqlName(manyToManyField.getName()) + columnName;
                    column.setName(columnName);
                }
            }
            if (!sourceField.hasInverseJoinColumns()) {
                LinkColumns targetLink = sourceField.getTargetLink();
                columns = targetLink.getColumns();
                for (ForeignColumn column : columns) {
                    columnName = column.getName();
                    columnName = columnName.substring(columnName.indexOf(95));
                    columnName = BaseConfigIntrospector.toSqlName(sourceField.getName()) + columnName;
                    column.setName(columnName);
                }
            }
            return;
        }
        EntityManyToManyField manyToManyField = new EntityManyToManyField(sourceType, fieldName, cascadeTypes);
        manyToManyField.setType(targetType);
        String sqlTable = sourceType.getTable().getName() + "_" + targetType.getTable().getName();
        JAnnotation joinTableAnn = field.getAnnotation(JoinTable.class);
        JoinTableConfig joinTableConfig = null;
        if (manyToManyConfig != null) {
            joinTableConfig = manyToManyConfig.getJoinTable();
        }
        com.caucho.amber.table.Table mapTable = null;
        ArrayList<ForeignColumn> sourceColumns = null;
        ArrayList<ForeignColumn> targetColumns = null;
        if (joinTableAnn != null || joinTableConfig != null) {
            String joinTableName;
            Object[] joinColumns = null;
            Object[] inverseJoinColumns = null;
            HashMap<String, JoinColumnConfig> joinColumnsConfig = null;
            HashMap<String, JoinColumnConfig> inverseJoinColumnsConfig = null;
            if (joinTableAnn != null) {
                joinTableName = joinTableAnn.getString("name");
                joinColumns = (Object[])joinTableAnn.get("joinColumns");
                inverseJoinColumns = (Object[])joinTableAnn.get("inverseJoinColumns");
                if (joinColumns != null && joinColumns.length > 0) {
                    manyToManyField.setJoinColumns(true);
                }
                if (inverseJoinColumns != null && inverseJoinColumns.length > 0) {
                    manyToManyField.setInverseJoinColumns(true);
                }
            } else {
                joinTableName = joinTableConfig.getName();
                joinColumnsConfig = joinTableConfig.getJoinColumnMap();
                inverseJoinColumnsConfig = joinTableConfig.getInverseJoinColumnMap();
                if (joinColumnsConfig != null && joinColumnsConfig.size() > 0) {
                    manyToManyField.setJoinColumns(true);
                }
                if (inverseJoinColumnsConfig != null && inverseJoinColumnsConfig.size() > 0) {
                    manyToManyField.setInverseJoinColumns(true);
                }
            }
            if (!joinTableName.equals("")) {
                sqlTable = joinTableName;
            }
            mapTable = this._persistenceUnit.createTable(sqlTable);
            sourceColumns = AbstractConfigIntrospector.calculateColumns(field, mapTable, sourceType.getTable().getName() + "_", sourceType, joinColumns, joinColumnsConfig);
            targetColumns = AbstractConfigIntrospector.calculateColumns(field, mapTable, targetType.getTable().getName() + "_", targetType, inverseJoinColumns, inverseJoinColumnsConfig);
        } else {
            mapTable = this._persistenceUnit.createTable(sqlTable);
            sourceColumns = AbstractConfigIntrospector.calculateColumns(mapTable, sourceType.getTable().getName() + "_", sourceType);
            targetColumns = AbstractConfigIntrospector.calculateColumns(mapTable, targetType.getTable().getName() + "_", targetType);
        }
        manyToManyField.setAssociationTable(mapTable);
        manyToManyField.setTable(sqlTable);
        manyToManyField.setLazy(isLazy);
        manyToManyField.setSourceLink(new LinkColumns(mapTable, sourceType.getTable(), sourceColumns));
        manyToManyField.setTargetLink(new LinkColumns(mapTable, targetType.getTable(), targetColumns));
        this.getInternalMapKeyConfig(sourceType.getBeanClass(), field, fieldName, this._annotationCfg);
        JAnnotation mapKeyAnn = this._annotationCfg.getAnnotation();
        MapKeyConfig mapKeyConfig = this._annotationCfg.getMapKeyConfig();
        if (!this._annotationCfg.isNull()) {
            String key = mapKeyAnn != null ? mapKeyAnn.getString("name") : mapKeyConfig.getName();
            String getter = "get" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
            JMethod method = targetType.getGetter(getter);
            if (method == null) {
                throw BaseConfigIntrospector.error(field, L.l("targetEntity '{0}' has no getter for field named '{1}'. Either the @MapKey name or the @ManyToMany targetEntity is incorrect.", (Object)targetName, (Object)key));
            }
            manyToManyField.setMapKey(key);
        }
        sourceType.addField(manyToManyField);
    }

    EntityManyToOneField getSourceField(EntityType targetType, String mappedBy, EntityType sourceType) {
        do {
            ArrayList<AmberField> fields = targetType.getFields();
            for (AmberField field : fields) {
                if (!("".equals(mappedBy) || mappedBy == null ? field.getJavaType().isAssignableFrom(sourceType.getBeanClass()) : field.getName().equals(mappedBy))) continue;
                return (EntityManyToOneField)field;
            }
        } while ((targetType = targetType.getParentType()) != null);
        return null;
    }

    OneToOneCompletion getSourceCompletion(EntityType targetType, String mappedBy) {
        do {
            ArrayList<OneToOneCompletion> sourceCompletions;
            if ((sourceCompletions = this._oneToOneCompletions.get(targetType)) == null) continue;
            if (sourceCompletions.size() == 1) {
                return sourceCompletions.get(0);
            }
            for (OneToOneCompletion oneToOne : sourceCompletions) {
                if (!oneToOne.getFieldName().equals(mappedBy)) continue;
                return oneToOne;
            }
        } while ((targetType = targetType.getParentType()) != null);
        return null;
    }

    void getInternalEmbeddableConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Embeddable.class);
        EmbeddableConfig embeddableConfig = null;
        if (this._embeddableConfigMap != null) {
            embeddableConfig = this._embeddableConfigMap.get(type.getName());
        }
        annotationCfg.setConfig(embeddableConfig);
    }

    void getInternalEntityConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Entity.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        annotationCfg.setConfig(entityConfig);
    }

    void getInternalMappedSuperclassConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, MappedSuperclass.class);
        MappedSuperclassConfig mappedSuperConfig = this.getMappedSuperclassConfig(type.getName());
        annotationCfg.setConfig(mappedSuperConfig);
    }

    void getInternalEntityListenersConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, EntityListeners.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        annotationCfg.setConfig(entityConfig.getEntityListeners());
    }

    void getInternalExcludeDefaultListenersConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, ExcludeDefaultListeners.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        if (entityConfig.getExcludeDefaultListeners()) {
            annotationCfg.setConfig(entityConfig.getExcludeDefaultListeners());
        }
    }

    void getInternalExcludeSuperclassListenersConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, ExcludeSuperclassListeners.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        if (entityConfig.getExcludeSuperclassListeners()) {
            annotationCfg.setConfig(entityConfig.getExcludeSuperclassListeners());
        }
    }

    void getInternalInheritanceConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Inheritance.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getInheritance());
        }
    }

    void getInternalNamedQueryConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, NamedQuery.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getNamedQuery());
        }
    }

    void getInternalNamedNativeQueryConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, NamedNativeQuery.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getNamedNativeQuery());
        }
    }

    void getInternalSqlResultSetMappingConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, SqlResultSetMapping.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getSqlResultSetMapping());
        }
    }

    void getInternalTableConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, Table.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getTable());
        }
    }

    void getInternalSecondaryTableConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, SecondaryTable.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getSecondaryTable());
        }
    }

    void getInternalIdClassConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, IdClass.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        annotationCfg.setConfig(entityConfig.getIdClass());
    }

    void getInternalPrimaryKeyJoinColumnConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, PrimaryKeyJoinColumn.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getPrimaryKeyJoinColumn());
        }
    }

    void getInternalDiscriminatorColumnConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, DiscriminatorColumn.class);
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            annotationCfg.setConfig(entityConfig.getDiscriminatorColumn());
        }
    }

    void getInternalOneToOneConfig(JClass type, JAccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, OneToOne.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            OneToOneConfig oneToOne = attributes.getOneToOne(fieldName);
            annotationCfg.setConfig(oneToOne);
        }
    }

    void getInternalOneToManyConfig(JClass type, JAccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, OneToMany.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            OneToManyConfig oneToMany = attributes.getOneToMany(fieldName);
            annotationCfg.setConfig(oneToMany);
        }
    }

    void getInternalManyToOneConfig(JClass type, JAccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, ManyToOne.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            ManyToOneConfig manyToOne = attributes.getManyToOne(fieldName);
            annotationCfg.setConfig(manyToOne);
        }
    }

    void getInternalManyToManyConfig(JClass type, JAccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, ManyToMany.class);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        AttributesConfig attributes = entityConfig.getAttributes();
        if (attributes != null) {
            ManyToManyConfig manyToMany = attributes.getManyToMany(fieldName);
            annotationCfg.setConfig(manyToMany);
        }
    }

    void getInternalIdConfig(JClass type, JAccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(method, javax.persistence.Id.class);
        MappedSuperclassConfig mappedSuperclassOrEntityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (mappedSuperclassOrEntityConfig == null) {
            return;
        }
        AttributesConfig attributes = mappedSuperclassOrEntityConfig.getAttributes();
        if (attributes != null) {
            IdConfig id = attributes.getId(fieldName);
            annotationCfg.setConfig(id);
        }
    }

    void getInternalCallbackConfig(int callback, JClass type, JAccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        AbstractListenerConfig callbackConfig;
        annotationCfg.reset(method, ListenerType.CALLBACK_CLASS[callback]);
        MappedSuperclassConfig entityConfig = this.getInternalMappedSuperclassOrEntityConfig(type.getName());
        if (entityConfig == null) {
            return;
        }
        switch (callback) {
            case 1: {
                callbackConfig = entityConfig.getPrePersist();
                break;
            }
            case 2: {
                callbackConfig = entityConfig.getPostPersist();
                break;
            }
            case 3: {
                callbackConfig = entityConfig.getPreRemove();
                break;
            }
            case 4: {
                callbackConfig = entityConfig.getPostRemove();
                break;
            }
            case 5: {
                callbackConfig = entityConfig.getPreUpdate();
                break;
            }
            case 6: {
                callbackConfig = entityConfig.getPostUpdate();
                break;
            }
            case 7: {
                callbackConfig = entityConfig.getPostLoad();
                break;
            }
            default: {
                return;
            }
        }
        if (callbackConfig == null) {
            return;
        }
        if (callbackConfig.getMethodName().equals(method.getName())) {
            annotationCfg.setConfig(callbackConfig);
        }
    }

    void getInternalEmbeddedIdConfig(JClass type, JAccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(method, EmbeddedId.class);
    }

    void getInternalVersionConfig(JClass type, JAccessibleObject method, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(method, Version.class);
    }

    void getInternalJoinColumnConfig(JClass type, JAccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, JoinColumn.class);
    }

    void getInternalJoinTableConfig(JClass type, JAccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, JoinTable.class);
    }

    void getInternalMapKeyConfig(JClass type, JAccessibleObject field, String fieldName, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(field, MapKey.class);
    }

    void getInternalAttributeOverrideConfig(JClass type, AbstractConfigIntrospector.AnnotationConfig annotationCfg) {
        annotationCfg.reset(type, AttributeOverride.class);
    }

    private MappedSuperclassConfig getInternalMappedSuperclassOrEntityConfig(String name) {
        MappedSuperclassConfig mappedSuperclassConfig = null;
        mappedSuperclassConfig = this.getEntityConfig(name);
        if (mappedSuperclassConfig != null) {
            return mappedSuperclassConfig;
        }
        mappedSuperclassConfig = this.getMappedSuperclassConfig(name);
        return mappedSuperclassConfig;
    }

    static AttributeOverrideConfig convertAttributeOverrideAnnotationToConfig(JAnnotation attOverrideAnn) {
        JAnnotation columnAnn = attOverrideAnn.getAnnotation("column");
        return BaseConfigIntrospector.createAttributeOverrideConfig(attOverrideAnn.getString("name"), columnAnn.getString("name"), columnAnn.getBoolean("nullable"), columnAnn.getBoolean("unique"));
    }

    static AttributeOverrideConfig createAttributeOverrideConfig(String name, String columnName, boolean isNullable, boolean isUnique) {
        AttributeOverrideConfig attOverrideConfig = new AttributeOverrideConfig();
        attOverrideConfig.setName(name);
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(columnName);
        columnConfig.setNullable(isNullable);
        columnConfig.setUnique(isUnique);
        attOverrideConfig.setColumn(columnConfig);
        return attOverrideConfig;
    }

    class SqlResultSetMappingCompletion
    extends Completion {
        private String _name;
        private Object[] _entities;
        private Object[] _columns;

        SqlResultSetMappingCompletion(EntityType type, String name, Object[] entities, Object[] columns) {
            super(BaseConfigIntrospector.this, type);
            this._name = name;
            this._entities = entities;
            this._columns = columns;
        }

        void complete() throws ConfigException {
            BaseConfigIntrospector.this.addSqlResultSetMapping(this._name, this._entities, this._columns);
        }
    }

    class EmbeddedCompletion
    extends Completion {
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;
        private boolean _embeddedId;

        EmbeddedCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType, boolean embeddedId) {
            super(BaseConfigIntrospector.this, type, fieldName);
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
            this._embeddedId = embeddedId;
        }

        void complete() throws ConfigException {
            boolean hasAttributeOverrides;
            BaseConfigIntrospector.this.getInternalAttributeOverrideConfig(this._entityType.getBeanClass(), BaseConfigIntrospector.this._annotationCfg);
            JAnnotation attributeOverrideAnn = BaseConfigIntrospector.this._annotationCfg.getAnnotation();
            AttributeOverrideConfig attributeOverrideConfig = BaseConfigIntrospector.this._annotationCfg.getAttributeOverrideConfig();
            boolean hasAttributeOverride = !BaseConfigIntrospector.this._annotationCfg.isNull();
            JAnnotation attributeOverridesAnn = this._field.getAnnotation(AttributeOverrides.class);
            boolean bl = hasAttributeOverrides = attributeOverridesAnn != null;
            if (hasAttributeOverride && hasAttributeOverrides) {
                throw AbstractConfigIntrospector.error(this._field, L.l("{0} may not have both @AttributeOverride and @AttributeOverrides", (Object)this._field.getName()));
            }
            Object[] attOverridesAnn = null;
            if (attributeOverrideAnn != null) {
                attOverridesAnn = new Object[]{attributeOverrideAnn};
            } else if (attributeOverridesAnn != null) {
                attOverridesAnn = (Object[])attributeOverridesAnn.get("value");
            }
            AmberPersistenceUnit persistenceUnit = this._entityType.getPersistenceUnit();
            EmbeddableType type = persistenceUnit.createEmbeddable(this._fieldType);
            EntityEmbeddedField embeddedField = this._embeddedId ? this._entityType.getId().getEmbeddedIdField() : new EntityEmbeddedField(this._entityType, type, this._fieldName);
            embeddedField.setLazy(false);
            this._entityType.addField(embeddedField);
            com.caucho.amber.table.Table sourceTable = this._entityType.getTable();
            HashMap embeddedColumns = new HashMap();
            HashMap fieldNameByColumn = new HashMap();
            for (EmbeddedSubField subField : embeddedField.getSubFields()) {
                String embeddedFieldName = subField.getName();
                String columnName = AbstractConfigIntrospector.toSqlName(embeddedFieldName);
                boolean notNull = false;
                boolean unique = false;
                if (attOverridesAnn == null) continue;
                for (int j = 0; j < attOverridesAnn.length; ++j) {
                    JAnnotation columnAnn;
                    if (!embeddedFieldName.equals(((JAnnotation)attOverridesAnn[j]).getString("name")) || (columnAnn = ((JAnnotation)attOverridesAnn[j]).getAnnotation("column")) == null) continue;
                    columnName = columnAnn.getString("name");
                    notNull = !columnAnn.getBoolean("nullable");
                    unique = columnAnn.getBoolean("unique");
                    subField.getColumn().setName(columnName);
                    subField.getColumn().setNotNull(notNull);
                    subField.getColumn().setUnique(unique);
                }
            }
            embeddedField.init();
        }
    }

    class ManyToOneCompletion
    extends Completion {
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;

        ManyToOneCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType) {
            super(BaseConfigIntrospector.this, type, fieldName);
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            BaseConfigIntrospector.this.addManyToOne(this._entityType, this._field, this._fieldName, this._fieldType);
        }
    }

    class ManyToManyCompletion
    extends Completion {
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;

        ManyToManyCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType) {
            super(BaseConfigIntrospector.this, type, fieldName);
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            BaseConfigIntrospector.this.addManyToMany(this._entityType, this._field, this._fieldName, this._fieldType);
        }
    }

    class OneToOneCompletion
    extends Completion {
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;

        OneToOneCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType) {
            super(BaseConfigIntrospector.this, type, fieldName);
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        String getFieldName() {
            return this._fieldName;
        }

        void complete() throws ConfigException {
            OneToOneCompletion otherSide;
            boolean isManyToOne;
            boolean isLazy;
            BaseConfigIntrospector.this.getInternalOneToOneConfig(this._entityType.getBeanClass(), this._field, this._fieldName, BaseConfigIntrospector.this._annotationCfg);
            JAnnotation oneToOneAnn = BaseConfigIntrospector.this._annotationCfg.getAnnotation();
            OneToOneConfig oneToOneConfig = BaseConfigIntrospector.this._annotationCfg.getOneToOneConfig();
            if (oneToOneAnn != null) {
                isLazy = oneToOneAnn.get("fetch") == FetchType.LAZY;
            } else {
                boolean bl = isLazy = oneToOneConfig.getFetch() == FetchType.LAZY;
            }
            if (!isLazy && this._entityType.getBeanClass().getName().equals(this._fieldType.getName())) {
                throw AbstractConfigIntrospector.error(this._field, L.l("'{0}': '{1}' is an illegal recursive type for @OneToOne with EAGER fetching. You should specify FetchType.LAZY for this relationship.", (Object)this._field.getName(), (Object)this._fieldType.getName()));
            }
            AmberPersistenceUnit persistenceUnit = this._entityType.getPersistenceUnit();
            JClass targetEntity = null;
            String targetName = "";
            if (oneToOneAnn != null) {
                targetEntity = oneToOneAnn.getClass("targetEntity");
                if (targetEntity != null) {
                    targetEntity.getName();
                }
            } else {
                targetName = oneToOneConfig.getTargetEntity();
                if (targetName != null && !"".equals(targetName)) {
                    targetEntity = BaseConfigIntrospector.this._persistenceUnit.getJClassLoader().forName(targetName);
                }
            }
            if (targetEntity == null || targetEntity.getName().equals("void")) {
                targetEntity = this._fieldType;
            }
            BaseConfigIntrospector.this.getInternalEntityConfig(targetEntity, BaseConfigIntrospector.this._annotationCfg);
            JAnnotation targetEntityAnn = BaseConfigIntrospector.this._annotationCfg.getAnnotation();
            EntityConfig targetEntityConfig = BaseConfigIntrospector.this._annotationCfg.getEntityConfig();
            if (BaseConfigIntrospector.this._annotationCfg.isNull()) {
                throw AbstractConfigIntrospector.error(this._field, L.l("'{0}' is an illegal targetEntity for {1}.  @OneToOne relations must target a valid @Entity.", (Object)targetEntity.getName(), (Object)this._field.getName()));
            }
            if (!this._fieldType.isAssignableFrom(targetEntity)) {
                throw AbstractConfigIntrospector.error(this._field, L.l("'{0}' is an illegal targetEntity for {1}.  @OneToOne targetEntity must be assignable to the field type '{2}'.", (Object)targetEntity.getName(), (Object)this._field.getName(), (Object)this._fieldType.getName()));
            }
            String mappedBy = oneToOneAnn != null ? oneToOneAnn.getString("mappedBy") : oneToOneConfig.getMappedBy();
            EntityType targetType = null;
            if (targetName != null && !targetName.equals("")) {
                targetType = persistenceUnit.getEntityType(targetName);
                if (targetType == null) {
                    throw new ConfigException(L.l("{0}: '{1}' is an unknown entity for '{2}'.", (Object)this._field.getDeclaringClass().getName(), (Object)targetName, (Object)this._field.getName()));
                }
            } else {
                targetType = persistenceUnit.getEntityType(this._field.getReturnType().getName());
                if (targetType == null) {
                    throw new ConfigException(L.l("{0} can't determine target name for '{1}'", (Object)this._field.getDeclaringClass().getName(), (Object)this._field.getName()));
                }
            }
            boolean bl = isManyToOne = mappedBy == null || "".equals(mappedBy);
            if (isManyToOne) {
                OneToOneCompletion otherSide2;
                BaseConfigIntrospector.this.getInternalJoinColumnConfig(this._entityType.getBeanClass(), this._field, this._fieldName, BaseConfigIntrospector.this._annotationCfg);
                JAnnotation joinColumnAnn = BaseConfigIntrospector.this._annotationCfg.getAnnotation();
                JoinColumnConfig joinColumnConfig = BaseConfigIntrospector.this._annotationCfg.getJoinColumnConfig();
                if (BaseConfigIntrospector.this._annotationCfg.isNull() && (otherSide2 = BaseConfigIntrospector.this.getSourceCompletion(targetType, mappedBy)) != null) {
                    BaseConfigIntrospector.this.getInternalJoinColumnConfig(targetType.getBeanClass(), otherSide2._field, otherSide2._fieldName, BaseConfigIntrospector.this._annotationCfg);
                    if (!BaseConfigIntrospector.this._annotationCfg.isNull()) {
                        isManyToOne = false;
                    }
                }
            }
            if (targetType.getParentType() != null && targetType.getParentType() instanceof MappedSuperclassType) {
                isManyToOne = false;
                otherSide = BaseConfigIntrospector.this.getSourceCompletion(targetType.getParentType(), mappedBy);
                if (otherSide != null && BaseConfigIntrospector.this._depCompletions.remove(otherSide)) {
                    otherSide.complete();
                }
            }
            if (isManyToOne) {
                BaseConfigIntrospector.this.addManyToOne(this._entityType, this._field, this._fieldName, this._field.getReturnType());
            } else {
                EntityManyToOneField sourceField;
                if (mappedBy != null && !"".equals(mappedBy) && (otherSide = BaseConfigIntrospector.this.getSourceCompletion(targetType, mappedBy)) != null && BaseConfigIntrospector.this._depCompletions.remove(otherSide)) {
                    otherSide.complete();
                }
                if ((sourceField = BaseConfigIntrospector.this.getSourceField(targetType, mappedBy, this._entityType)) == null) {
                    throw new ConfigException(L.l("{0}: OneToOne target '{1}' does not have a matching ManyToOne relation.", (Object)this._field.getDeclaringClass().getName(), (Object)targetType.getName()));
                }
                CascadeType[] cascadeTypes = null;
                if (oneToOneAnn != null) {
                    Object[] cascade = (Object[])oneToOneAnn.get("cascade");
                    cascadeTypes = new CascadeType[cascade.length];
                    for (int i = 0; i < cascade.length; ++i) {
                        cascadeTypes[i] = (CascadeType)cascade[i];
                    }
                }
                DependentEntityOneToOneField oneToOne = new DependentEntityOneToOneField(this._entityType, this._fieldName, cascadeTypes);
                oneToOne.setTargetField(sourceField);
                sourceField.setTargetField(oneToOne);
                oneToOne.setLazy(isLazy);
                this._entityType.addField(oneToOne);
            }
        }
    }

    class OneToManyCompletion
    extends Completion {
        private JAccessibleObject _field;
        private String _fieldName;
        private JClass _fieldType;
        private OneToManyConfig _oneToManyConfig;
        private boolean _isLazy;

        OneToManyCompletion(EntityType type, JAccessibleObject field, String fieldName, JClass fieldType, OneToManyConfig oneToManyConfig) {
            super(BaseConfigIntrospector.this, type, fieldName);
            this._isLazy = true;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
            this._oneToManyConfig = oneToManyConfig;
        }

        void complete() throws ConfigException {
            String mappedBy;
            EntityConfig entityConfig;
            EntityType targetType;
            BaseConfigIntrospector.this.getInternalOneToManyConfig(this._entityType.getBeanClass(), this._field, this._fieldName, BaseConfigIntrospector.this._annotationCfg);
            JAnnotation oneToManyAnn = BaseConfigIntrospector.this._annotationCfg.getAnnotation();
            OneToManyConfig oneToManyConfig = BaseConfigIntrospector.this._annotationCfg.getOneToManyConfig();
            this._isLazy = oneToManyAnn != null ? oneToManyAnn.get("fetch") == FetchType.LAZY : oneToManyConfig.getFetch() == FetchType.LAZY;
            AmberPersistenceUnit persistenceUnit = this._entityType.getPersistenceUnit();
            JType retType = this._field instanceof JField ? ((JField)this._field).getGenericType() : ((JMethod)this._field).getGenericReturnType();
            JType[] typeArgs = retType.getActualTypeArguments();
            JClass targetEntity = null;
            if (oneToManyAnn != null) {
                targetEntity = oneToManyAnn.getClass("targetEntity");
            } else {
                String s = oneToManyConfig.getTargetEntity();
                if (s != null) {
                    targetEntity = BaseConfigIntrospector.this._persistenceUnit.getJClassLoader().forName(s);
                }
            }
            String targetName = "";
            if (targetEntity != null) {
                targetName = targetEntity.getName();
            }
            if (targetName.equals("") || targetName.equals("void")) {
                if (typeArgs.length > 0) {
                    targetName = typeArgs[typeArgs.length - 1].getName();
                } else {
                    throw AbstractConfigIntrospector.error(this._field, L.l("Can't determine targetEntity for {0}.  @OneToMany properties must target @Entity beans.", (Object)this._field.getName()));
                }
            }
            if ((targetType = persistenceUnit.getEntityType(targetName)) == null && (entityConfig = BaseConfigIntrospector.this.getEntityConfig(targetName)) == null) {
                throw AbstractConfigIntrospector.error(this._field, L.l("targetEntity '{0}' is not an @Entity bean for {1}.  The targetEntity of a @OneToMany collection must be an @Entity bean.", (Object)targetName, (Object)this._field.getName()));
            }
            CascadeType[] cascadeTypes = null;
            if (oneToManyAnn != null) {
                mappedBy = oneToManyAnn.getString("mappedBy");
                Object[] cascade = (Object[])oneToManyAnn.get("cascade");
                cascadeTypes = new CascadeType[cascade.length];
                for (int i = 0; i < cascade.length; ++i) {
                    cascadeTypes[i] = (CascadeType)cascade[i];
                }
            } else {
                mappedBy = oneToManyConfig.getMappedBy();
                CascadeConfig cascade = oneToManyConfig.getCascade();
                if (cascade != null) {
                    cascadeTypes = cascade.getCascadeTypes();
                }
            }
            if (mappedBy != null && !mappedBy.equals("")) {
                this.oneToManyBidirectional(targetType, targetName, mappedBy, cascadeTypes);
            } else {
                this.oneToManyUnidirectional(targetType, targetName, cascadeTypes);
            }
        }

        private void oneToManyBidirectional(EntityType targetType, String targetName, String mappedBy, CascadeType[] cascadeTypes) throws ConfigException {
            JAnnotation joinTableAnn = this._field.getAnnotation(JoinTable.class);
            JoinTableConfig joinTableConfig = null;
            if (this._oneToManyConfig != null) {
                joinTableConfig = this._oneToManyConfig.getJoinTable();
            }
            if (joinTableAnn != null || joinTableConfig != null) {
                throw AbstractConfigIntrospector.error(this._field, L.l("Bidirectional @ManyToOne property {0} may not have a @JoinTable annotation.", (Object)this._field.getName()));
            }
            EntityManyToOneField sourceField = BaseConfigIntrospector.this.getSourceField(targetType, mappedBy, null);
            if (sourceField == null) {
                throw AbstractConfigIntrospector.error(this._field, L.l("'{1}' is an unknown column in '{0}' for @ManyToOne(mappedBy={1}).", (Object)targetType.getName(), (Object)mappedBy));
            }
            JAnnotation orderByAnn = this._field.getAnnotation(OrderBy.class);
            String orderBy = null;
            ArrayList<String> orderByFields = null;
            ArrayList<Boolean> orderByAscending = null;
            if (orderByAnn != null) {
                orderBy = (String)orderByAnn.get("value");
                if (orderBy == null) {
                    orderBy = "";
                }
                if ("".equals(orderBy) && targetType instanceof EntityType) {
                    EntityType targetRelatedType = targetType;
                    orderBy = targetRelatedType.getId().generateJavaSelect(null);
                }
                orderByFields = new ArrayList<String>();
                orderByAscending = new ArrayList<Boolean>();
                int len = orderBy.length();
                int i = 0;
                while (i < len) {
                    AmberField amberField;
                    int index = orderBy.indexOf(",", i);
                    if (index < 0) {
                        index = len;
                    }
                    String orderByField = orderBy.substring(i, index);
                    i += index;
                    index = orderByField.toUpperCase().lastIndexOf("SC");
                    Boolean asc = Boolean.TRUE;
                    if (index > 1) {
                        if (orderByField.charAt(index - 1) != 'E') {
                            if (orderByField.charAt(index - 1) == 'A' && Character.isSpaceChar(orderByField.charAt(index - 2))) {
                                index -= 2;
                            }
                        } else if (index > 2 && orderByField.charAt(index - 2) == 'D' && Character.isSpaceChar(orderByField.charAt(index - 3))) {
                            asc = Boolean.FALSE;
                            index -= 3;
                        }
                    }
                    if (index > 0) {
                        orderByField = orderByField.substring(0, index).trim();
                    }
                    if ((amberField = targetType.getField(orderByField)) == null) {
                        throw AbstractConfigIntrospector.error(this._field, L.l("'{0}' has no field named '{1}' in @OrderBy", (Object)targetType.getName(), (Object)orderByField));
                    }
                    orderByFields.add(orderByField);
                    orderByAscending.add(asc);
                }
            }
            EntityOneToManyField oneToMany = new EntityOneToManyField(this._entityType, this._fieldName, cascadeTypes);
            oneToMany.setSourceField(sourceField);
            oneToMany.setOrderBy(orderByFields, orderByAscending);
            oneToMany.setLazy(this._isLazy);
            BaseConfigIntrospector.this.getInternalMapKeyConfig(this._entityType.getBeanClass(), this._field, this._fieldName, BaseConfigIntrospector.this._annotationCfg);
            JAnnotation mapKeyAnn = BaseConfigIntrospector.this._annotationCfg.getAnnotation();
            MapKeyConfig mapKeyConfig = BaseConfigIntrospector.this._annotationCfg.getMapKeyConfig();
            if (!BaseConfigIntrospector.this._annotationCfg.isNull()) {
                String key = mapKeyAnn.getString("name");
                String getter = "get" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
                JMethod method = targetType.getGetter(getter);
                if (method == null) {
                    throw AbstractConfigIntrospector.error(this._field, L.l("targetEntity '{0}' has no getter for field named '{1}'. Either the @MapKey name or the @OneToMany targetEntity is incorrect.", (Object)targetName, (Object)key));
                }
                oneToMany.setMapKey(key);
            }
            this._entityType.addField(oneToMany);
        }

        private void oneToManyUnidirectional(EntityType targetType, String targetName, CascadeType[] cascadeTypes) throws ConfigException {
            EntityManyToManyField manyToManyField = new EntityManyToManyField(this._entityType, this._fieldName, cascadeTypes);
            manyToManyField.setType(targetType);
            String sqlTable = this._entityType.getTable().getName() + "_" + targetType.getTable().getName();
            JAnnotation joinTableAnn = this._field.getAnnotation(JoinTable.class);
            JoinTableConfig joinTableConfig = null;
            if (this._oneToManyConfig != null) {
                joinTableConfig = this._oneToManyConfig.getJoinTable();
            }
            com.caucho.amber.table.Table mapTable = null;
            ArrayList<ForeignColumn> sourceColumns = null;
            ArrayList<ForeignColumn> targetColumns = null;
            if (joinTableAnn != null || joinTableConfig != null) {
                Object[] joinColumns = null;
                Object[] inverseJoinColumns = null;
                HashMap<String, JoinColumnConfig> joinColumnsConfig = null;
                HashMap<String, JoinColumnConfig> inverseJoinColumnsConfig = null;
                if (joinTableAnn != null) {
                    if (!joinTableAnn.getString("name").equals("")) {
                        sqlTable = joinTableAnn.getString("name");
                    }
                    joinColumns = (Object[])joinTableAnn.get("joinColumns");
                    inverseJoinColumns = (Object[])joinTableAnn.get("inverseJoinColumns");
                } else {
                    if (!joinTableConfig.getName().equals("")) {
                        sqlTable = joinTableConfig.getName();
                    }
                    joinColumnsConfig = joinTableConfig.getJoinColumnMap();
                    inverseJoinColumnsConfig = joinTableConfig.getInverseJoinColumnMap();
                }
                mapTable = BaseConfigIntrospector.this._persistenceUnit.createTable(sqlTable);
                sourceColumns = AbstractConfigIntrospector.calculateColumns(this._field, mapTable, this._entityType.getTable().getName() + "_", this._entityType, joinColumns, joinColumnsConfig);
                targetColumns = AbstractConfigIntrospector.calculateColumns(this._field, mapTable, targetType.getTable().getName() + "_", targetType, inverseJoinColumns, inverseJoinColumnsConfig);
            } else {
                mapTable = BaseConfigIntrospector.this._persistenceUnit.createTable(sqlTable);
                sourceColumns = AbstractConfigIntrospector.calculateColumns(mapTable, this._entityType.getTable().getName() + "_", this._entityType);
                targetColumns = AbstractConfigIntrospector.calculateColumns(mapTable, AbstractConfigIntrospector.toSqlName(this._fieldName) + "_", targetType);
            }
            manyToManyField.setAssociationTable(mapTable);
            manyToManyField.setTable(sqlTable);
            manyToManyField.setSourceLink(new LinkColumns(mapTable, this._entityType.getTable(), sourceColumns));
            manyToManyField.setTargetLink(new LinkColumns(mapTable, targetType.getTable(), targetColumns));
            BaseConfigIntrospector.this.getInternalMapKeyConfig(this._entityType.getBeanClass(), this._field, this._field.getName(), BaseConfigIntrospector.this._annotationCfg);
            JAnnotation mapKeyAnn = BaseConfigIntrospector.this._annotationCfg.getAnnotation();
            MapKeyConfig mapKeyConfig = BaseConfigIntrospector.this._annotationCfg.getMapKeyConfig();
            if (!BaseConfigIntrospector.this._annotationCfg.isNull()) {
                String key = mapKeyAnn != null ? mapKeyAnn.getString("name") : mapKeyConfig.getName();
                String getter = "get" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
                JMethod method = targetType.getGetter(getter);
                if (method == null) {
                    throw AbstractConfigIntrospector.error(this._field, L.l("targetEntity '{0}' has no getter for field named '{1}'. Either the @MapKey name or the @ManyToMany targetEntity is incorrect.", (Object)targetName, (Object)key));
                }
                manyToManyField.setMapKey(key);
            }
            this._entityType.addField(manyToManyField);
        }
    }
}

