/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractEnhancedConfig;
import com.caucho.amber.cfg.AmberConfigManager;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.EmbeddableConfig;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.persistence.Embeddable;

public class EmbeddableIntrospector
extends BaseConfigIntrospector {
    private static final L10N L = new L10N(EmbeddableIntrospector.class);
    private static final Logger log = Logger.getLogger(EmbeddableIntrospector.class.getName());
    HashMap<String, EmbeddableType> _embeddableMap = new HashMap();

    public EmbeddableIntrospector(AmberConfigManager configManager) {
        super(configManager);
    }

    public boolean isEmbeddable(JClass type) {
        this.getInternalEmbeddableConfig(type, this._annotationCfg);
        JAnnotation embeddableAnn = this._annotationCfg.getAnnotation();
        EmbeddableConfig embeddableConfig = this._annotationCfg.getEmbeddableConfig();
        return !this._annotationCfg.isNull();
    }

    public EmbeddableType introspect(JClass type) throws ConfigException, SQLException {
        this.getInternalEmbeddableConfig(type, this._annotationCfg);
        JAnnotation embeddableAnn = this._annotationCfg.getAnnotation();
        EmbeddableConfig embeddableConfig = this._annotationCfg.getEmbeddableConfig();
        String typeName = type.getName();
        EmbeddableType embeddableType = this._embeddableMap.get(typeName);
        if (embeddableType != null) {
            return embeddableType;
        }
        try {
            JAnnotation ann;
            embeddableType = this._persistenceUnit.createEmbeddable(typeName, type);
            this._embeddableMap.put(typeName, embeddableType);
            boolean isField = this.isField(type, embeddableConfig);
            if (isField) {
                embeddableType.setFieldAccess(true);
            }
            if ((ann = type.getAnnotation(Embeddable.class)) == null) {
                isField = true;
                embeddableType.setIdClass(true);
                this._persistenceUnit.getAmberContainer().addEmbeddable(typeName, embeddableType);
            }
            embeddableType.setInstanceClassName(type.getName() + "__ResinExt");
            embeddableType.setEnhanced(true);
            if (isField) {
                this.introspectFields(this._persistenceUnit, embeddableType, null, type, embeddableConfig, true);
            } else {
                this.introspectMethods(this._persistenceUnit, embeddableType, null, type, embeddableConfig);
            }
        }
        catch (ConfigException e) {
            if (embeddableType != null) {
                embeddableType.setConfigException(e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (embeddableType != null) {
                embeddableType.setConfigException(e);
            }
            throw e;
        }
        return embeddableType;
    }

    boolean isField(JClass type, AbstractEnhancedConfig typeConfig) throws ConfigException {
        for (JMethod method : type.getDeclaredMethods()) {
            JAnnotation[] ann = method.getDeclaredAnnotations();
            for (int i = 0; ann != null && i < ann.length; ++i) {
                if (!this.isPropertyAnnotation(ann[i].getType())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPropertyAnnotation(String name) {
        return "javax.persistence.Basic".equals(name) || "javax.persistence.Column".equals(name);
    }
}

