/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.EntityMappingsConfig;
import com.caucho.amber.manager.AmberContainer;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.bytecode.JClass;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitConfig
implements PersistenceUnitInfo {
    private static final L10N L = new L10N(PersistenceUnitConfig.class);
    private static final Logger log = Logger.getLogger(PersistenceUnitConfig.class.getName());
    private String _name;
    private Class _provider;
    private String _jtaDataSourceName;
    private String _nonJtaDataSourceName;
    private DataSource _jtaDataSource;
    private DataSource _nonJtaDataSource;
    private boolean _isExcludeUnlistedClasses;
    private URL _rootUrl;
    private DynamicClassLoader _loader;
    private PersistenceUnitTransactionType _transactionType = PersistenceUnitTransactionType.JTA;
    private Properties _properties = new Properties();
    private HashMap<String, JClass> _classMap = new HashMap();
    private ArrayList<String> _mappingFiles = new ArrayList();
    private ArrayList<String> _jarFiles = new ArrayList();
    private ArrayList<URL> _jarFileUrls = new ArrayList();

    public PersistenceUnitConfig(URL rootUrl) {
        Thread thread = Thread.currentThread();
        this._loader = (DynamicClassLoader)thread.getContextClassLoader();
        this._rootUrl = rootUrl;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setTransactionType(String type) {
        if ("JTA".equals(type)) {
            this._transactionType = PersistenceUnitTransactionType.JTA;
        } else if ("RESOURCE_LOCAL".equals(type)) {
            this._transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown JPA transaction-type.", (Object)type));
        }
    }

    public void setDescription(String description) {
    }

    public void setProvider(Class provider) {
        this._provider = provider;
        Config.validate(provider, PersistenceProvider.class);
    }

    public Class getProvider() {
        return this._provider;
    }

    public String getPersistenceProviderClassName() {
        if (this._provider != null) {
            return this._provider.getName();
        }
        return null;
    }

    public void setJtaDataSource(String ds) {
        this._jtaDataSourceName = ds;
    }

    public DataSource getJtaDataSource() {
        if (this._jtaDataSourceName == null) {
            return null;
        }
        if (this._jtaDataSource == null) {
            this._jtaDataSource = this.loadDataSource(this._jtaDataSourceName);
        }
        return this._jtaDataSource;
    }

    public String getJtaDataSourceName() {
        return this._jtaDataSourceName;
    }

    public void setNonJtaDataSource(String ds) {
        this._nonJtaDataSourceName = ds;
    }

    public DataSource getNonJtaDataSource() {
        if (this._nonJtaDataSourceName == null) {
            return null;
        }
        if (this._nonJtaDataSource == null) {
            this._nonJtaDataSource = this.loadDataSource(this._nonJtaDataSourceName);
        }
        return this._nonJtaDataSource;
    }

    public void addMappingFile(String fileName) {
        this._mappingFiles.add(fileName);
    }

    public ArrayList<String> getMappingFiles() {
        return this._mappingFiles;
    }

    public void addJarFile(String fileName) {
        this._jarFiles.add(fileName);
        try {
            URL url = new URL(Vfs.lookup(fileName).getURL());
            this._jarFileUrls.add(url);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public ArrayList<String> getJarFiles() {
        return this._jarFiles;
    }

    public void addClass(String cl) {
        this._classMap.put(cl, null);
    }

    public void addAllClasses(Map<String, JClass> classMap) {
        for (Map.Entry<String, JClass> entry : classMap.entrySet()) {
            String k = entry.getKey();
            JClass v = entry.getValue();
            if (this._classMap.containsKey(k)) continue;
            this._classMap.put(k, v);
        }
    }

    public boolean isExcludeUnlistedClasses() {
        return this._isExcludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean isExclude) {
        this._isExcludeUnlistedClasses = isExclude;
    }

    public PropertiesConfig createProperties() {
        return new PropertiesConfig();
    }

    public AmberPersistenceUnit init(AmberContainer container, ArrayList<EntityMappingsConfig> entityMappings) throws Exception {
        AmberPersistenceUnit unit = new AmberPersistenceUnit(container, this._name);
        unit.setJPA(true);
        if (this._jtaDataSourceName != null) {
            unit.setJtaDataSourceName(this._jtaDataSourceName);
        }
        if (this._nonJtaDataSourceName != null) {
            unit.setNonJtaDataSourceName(this._nonJtaDataSourceName);
        }
        unit.setEntityMappingsList(entityMappings);
        unit.init();
        for (Map.Entry<String, JClass> entry : this._classMap.entrySet()) {
            String className = entry.getKey();
            JClass type = entry.getValue();
            unit.addEntityClass(className, type);
        }
        unit.generate();
        return unit;
    }

    public String getPersistenceUnitName() {
        return this.getName();
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this._transactionType;
    }

    public List<String> getMappingFileNames() {
        return this._mappingFiles;
    }

    public List<URL> getJarFileUrls() {
        return this._jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this._rootUrl;
    }

    public List<String> getManagedClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this._classMap.keySet());
        return names;
    }

    public boolean excludeUnlistedClasses() {
        return this._isExcludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void addTransformer(ClassTransformer transformer) {
        this._loader.addTransformer(new TransformerAdapter(transformer));
    }

    public ClassLoader getNewTempClassLoader() {
        return this._loader.getNewTempClassLoader();
    }

    public String toString() {
        return "PersistenceUnitConfig[" + this._name + "]";
    }

    protected DataSource loadDataSource(String name) {
        DataSource ds = (DataSource)Jndi.lookup(name);
        if (ds != null) {
            return ds;
        }
        return null;
    }

    public static class TransformerAdapter
    implements ClassFileTransformer {
        private ClassTransformer _transformer;

        TransformerAdapter(ClassTransformer transformer) {
            this._transformer = transformer;
        }

        public byte[] transform(ClassLoader loader, String className, Class redefineClass, ProtectionDomain domain, byte[] classFileBuffer) throws IllegalClassFormatException {
            return this._transformer.transform(loader, className, redefineClass, domain, classFileBuffer);
        }
    }

    public static class PropertyConfig {
        private String _name;
        private String _value;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }
    }

    public class PropertiesConfig {
        public void addProperty(PropertyConfig prop) {
            PersistenceUnitConfig.this._properties.put(prop.getName(), prop.getValue());
        }
    }
}

