/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.ejb3;

import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.UserQuery;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class QueryImpl
implements Query {
    private static final L10N L = new L10N(QueryImpl.class);
    private AbstractQuery _query;
    private UserQuery _userQuery;
    private AmberConnection _aConn;
    private int _firstResult;
    private int _maxResults = 0x3FFFFFFF;

    QueryImpl(AbstractQuery query, AmberConnection aConn) {
        this._query = query;
        this._aConn = aConn;
        this._userQuery = new UserQuery(query);
        this._userQuery.setSession(this._aConn);
    }

    public List getResultList() {
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            ResultSet rs = this.executeQuery();
            while (rs.next()) {
                results.add(rs.getObject(1));
            }
            rs.close();
            return results;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    public Object getSingleResult() {
        try {
            ResultSet rs = this.executeQuery();
            Object value = null;
            if (rs.next()) {
                value = rs.getObject(1);
            }
            rs.close();
            return value;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    public int executeUpdate() {
        try {
            return this._userQuery.executeUpdate();
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    protected ResultSet executeQuery() throws SQLException {
        return this._userQuery.executeQuery();
    }

    public Query setMaxResults(int maxResult) {
        return this;
    }

    public Query setFirstResult(int startPosition) {
        return this;
    }

    public Query setHint(String hintName, Object value) {
        return this;
    }

    public Query setParameter(String name, Object value) {
        return this;
    }

    public Query setParameter(String name, Date value, TemporalType type) {
        return this;
    }

    public Query setParameter(String name, Calendar value, TemporalType type) {
        return this;
    }

    public Query setParameter(int index, Object value) {
        this._userQuery.setObject(index, value);
        return this;
    }

    public Query setParameter(int index, Date value, TemporalType type) {
        return this;
    }

    public Query setParameter(int index, Calendar value, TemporalType type) {
        return this;
    }

    public Query setFlushMode(FlushModeType mode) {
        return this;
    }

    public Query setDouble(int index, double value) {
        this._userQuery.setDouble(index, value);
        return this;
    }
}

