/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ArgExpr;
import com.caucho.amber.expr.EnumExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.KeyColumnExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.EnumType;
import com.caucho.amber.type.Type;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;

public class BinaryExpr
extends AbstractAmberExpr {
    private static final L10N L = new L10N(BinaryExpr.class);
    private AmberExpr _left;
    private AmberExpr _right;
    private int _token;

    public BinaryExpr(int token, AmberExpr left, AmberExpr right) {
        this._token = token;
        this._left = left;
        this._right = right;
    }

    public boolean hasRelationship() {
        return this._left.hasRelationship() || this._right.hasRelationship();
    }

    public boolean isBoolean() {
        switch (this._token) {
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                return true;
            }
        }
        return false;
    }

    public Class getJavaType() {
        switch (this._token) {
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                return Boolean.TYPE;
            }
        }
        return Double.TYPE;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        this._left = this._left.bindSelect(parser);
        this._right = this._right.bindSelect(parser);
        BinaryExpr.bindTypes(this._left, this._right);
        BinaryExpr.bindTypes(this._right, this._left);
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._left.usesFrom(from, type) || this._right.usesFrom(from, type);
    }

    public boolean exists(FromItem from) {
        if (this._token == 166) {
            if (this._left instanceof KeyColumnExpr && this._left.usesFrom(from, 1, false) && this._right.exists()) {
                return true;
            }
            return this._right instanceof KeyColumnExpr && this._right.usesFrom(from, 1, false) && this._right.exists(from) && this._left.exists();
        }
        return false;
    }

    public AmberExpr replaceJoin(JoinExpr join) {
        this._left = this._left.replaceJoin(join);
        this._right = this._right.replaceJoin(join);
        return this;
    }

    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        String str = "(" + this._left;
        switch (this._token) {
            case 166: {
                str = str + " = ";
                break;
            }
            case 167: {
                str = str + " <> ";
                break;
            }
            case 168: {
                str = str + " < ";
                break;
            }
            case 169: {
                str = str + " <= ";
                break;
            }
            case 170: {
                str = str + " > ";
                break;
            }
            case 171: {
                str = str + " >= ";
                break;
            }
            case 43: {
                str = str + " + ";
                break;
            }
            case 45: {
                str = str + " - ";
                break;
            }
            case 42: {
                str = str + " * ";
                break;
            }
            case 47: {
                str = str + " / ";
                break;
            }
            case 37: {
                str = str + " % ";
            }
        }
        return str + this._right + ")";
    }

    private static void bindTypes(AmberExpr left, AmberExpr right) {
        Type leftType = left.getType();
        Type rightType = right.getType();
        if (left instanceof EnumExpr) {
            EnumExpr enumExpr = (EnumExpr)left;
            enumExpr.setOrdinal(rightType.isNumeric());
        } else if (left instanceof ArgExpr && rightType instanceof EnumType) {
            ((ArgExpr)left).setType(rightType);
        }
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        cb.append('(');
        if (166 <= this._token && 171 >= this._token) {
            this._left.setInternalArgType(this._right);
            this._right.setInternalArgType(this._left);
        }
        if (select) {
            this._left.generateWhere(cb);
        } else {
            this._left.generateUpdateWhere(cb);
        }
        switch (this._token) {
            case 166: {
                cb.append(" = ");
                break;
            }
            case 167: {
                cb.append(" <> ");
                break;
            }
            case 168: {
                cb.append(" < ");
                break;
            }
            case 169: {
                cb.append(" <= ");
                break;
            }
            case 170: {
                cb.append(" > ");
                break;
            }
            case 171: {
                cb.append(" >= ");
                break;
            }
            case 43: {
                cb.append(" + ");
                break;
            }
            case 45: {
                cb.append(" - ");
                break;
            }
            case 42: {
                cb.append(" * ");
                break;
            }
            case 47: {
                cb.append(" / ");
                break;
            }
            case 37: {
                cb.append(" % ");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (select) {
            this._right.generateWhere(cb);
        } else {
            this._right.generateUpdateWhere(cb);
        }
        cb.append(')');
    }
}

