/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.BooleanColumnExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.Type;
import com.caucho.util.CharBuffer;

public class ColumnExpr
extends AbstractAmberExpr {
    protected PathExpr _parent;
    private Column _column;
    protected FromItem _fromItem;

    public ColumnExpr(PathExpr parent, Column column) {
        this._parent = parent;
        this._column = column;
    }

    public PathExpr getParent() {
        return this._parent;
    }

    public Column getColumn() {
        return this._column;
    }

    public Type getType() {
        return this.getColumn().getType();
    }

    public boolean hasRelationship() {
        return !(this._parent instanceof IdExpr);
    }

    public AmberExpr createBoolean() throws QueryParseException {
        if (this.getColumn().getType().isBoolean()) {
            return new BooleanColumnExpr(this._parent, this._column);
        }
        return super.createBoolean();
    }

    public AmberExpr bindSelect(QueryParser parser) {
        FromItem parentFromItem = this._parent.bindSubPath(parser);
        if (parentFromItem.getTable() == this.getColumn().getTable()) {
            this._fromItem = parentFromItem;
            return this;
        }
        LinkColumns link = this.getColumn().getTable().getDependentIdLink();
        if (link == null) {
            return this;
        }
        this._fromItem = parser.createDependentFromItem(parentFromItem, link);
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (from.isOuterJoin() && type == 1) {
            return false;
        }
        if (this._fromItem == from) {
            return true;
        }
        return this._fromItem == null && this._parent.getChildFromItem() == from;
    }

    public AmberExpr replaceJoin(JoinExpr join) {
        this._parent = (PathExpr)this._parent.replaceJoin(join);
        return this;
    }

    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        return this._parent + "." + this._column.getName();
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        if (this._fromItem != null) {
            if (select) {
                cb.append(this._fromItem.getName());
                cb.append('.');
            }
            cb.append(this._column.getName());
        } else {
            if (select) {
                cb.append(this._parent.getChildFromItem().getName());
                cb.append('.');
            }
            cb.append(this._column.getName());
        }
    }
}

