/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractPathExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ManyToOneJoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.util.CharBuffer;

public class DependentEntityOneToOneExpr
extends AbstractPathExpr {
    private PathExpr _parent;
    private LinkColumns _linkColumns;
    private FromItem _fromItem;
    private FromItem _childFromItem;

    public DependentEntityOneToOneExpr(PathExpr parent, LinkColumns linkColumns) {
        this._parent = parent;
        this._linkColumns = linkColumns;
    }

    public EntityType getTargetType() {
        return this._linkColumns.getSourceTable().getType();
    }

    public AmberExpr bindSelect(QueryParser parser) {
        this._fromItem = this.bindSubPath(parser);
        return this;
    }

    public FromItem getChildFromItem() {
        return this._childFromItem;
    }

    public FromItem bindSubPath(QueryParser parser) {
        if (this._childFromItem != null) {
            return this._childFromItem;
        }
        DependentEntityOneToOneExpr pathExpr = (DependentEntityOneToOneExpr)parser.addPath(this);
        if (pathExpr != this) {
            this._fromItem = pathExpr._fromItem;
            this._childFromItem = pathExpr._childFromItem;
            return this._childFromItem;
        }
        this._fromItem = this._parent.bindSubPath(parser);
        this._childFromItem = parser.getSelectQuery().createFromItem(this._linkColumns.getSourceTable(), parser.createTableName());
        ManyToOneJoinExpr join = new ManyToOneJoinExpr(this._linkColumns, this._childFromItem, this._fromItem);
        this._childFromItem.setJoinExpr(join);
        return this._childFromItem;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._childFromItem == from && type == 1 || this._fromItem == from || this._parent.usesFrom(from, type);
    }

    public void generateMatchArgWhere(CharBuffer cb) {
        if (this._fromItem != null) {
            cb.append(this._linkColumns.generateMatchArgSQL(this._fromItem.getName()));
        } else {
            cb.append(this._linkColumns.generateMatchArgSQL(this._parent.getChildFromItem().getName()));
        }
    }

    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    public String toString() {
        return "OneToOneExpr[" + this._parent + "," + this._linkColumns + "]";
    }

    public int hashCode() {
        return 65521 * this._parent.hashCode() + this._linkColumns.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DependentEntityOneToOneExpr oneToOne = (DependentEntityOneToOneExpr)o;
        return this._parent.equals(oneToOne._parent) && this._linkColumns.equals(oneToOne._linkColumns);
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        if (this._fromItem != null) {
            String s;
            if (select) {
                s = this._fromItem.getName();
                cb.append(s);
                cb.append('.');
            }
            s = this._childFromItem.getTable().getIdColumns().get(0).getName();
            cb.append(s);
        } else if (select) {
            super.generateWhere(cb);
        } else {
            super.generateUpdateWhere(cb);
        }
    }
}

