/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractPathExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.IdFieldExpr;
import com.caucho.amber.expr.ManyToOneJoinExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.util.CharBuffer;

public class KeyManyToOneExpr
extends AbstractPathExpr
implements IdFieldExpr {
    private PathExpr _parent;
    private KeyManyToOneField _manyToOne;
    private FromItem _fromItem;
    private FromItem _childFromItem;

    public KeyManyToOneExpr(PathExpr parent, KeyManyToOneField manyToOne) {
        this._parent = parent;
        this._manyToOne = manyToOne;
    }

    public PathExpr getParent() {
        return this._parent;
    }

    public IdField getField() {
        return this._manyToOne;
    }

    public EntityType getTargetType() {
        return this._manyToOne.getEntityType();
    }

    public Column getColumn() {
        throw new UnsupportedOperationException();
    }

    public AmberExpr createField(QueryParser parser, String name) {
        AmberField field = this.getTargetType().getField(name);
        if (field == null) {
            return null;
        }
        if (field instanceof IdField) {
            KeyPropertyField idField = this._manyToOne.getIdField((IdField)field);
            return idField.createExpr(parser, this._parent);
        }
        return field.createExpr(parser, this);
    }

    public AmberExpr bindSelect(QueryParser parser) {
        this._fromItem = this._parent.bindSubPath(parser);
        return this;
    }

    public FromItem getChildFromItem() {
        return this._childFromItem;
    }

    public FromItem bindSubPath(QueryParser parser) {
        if (this._childFromItem != null) {
            return this._childFromItem;
        }
        KeyManyToOneExpr pathExpr = (KeyManyToOneExpr)parser.addPath(this);
        if (pathExpr != this) {
            this._fromItem = pathExpr._fromItem;
            this._childFromItem = pathExpr._childFromItem;
            return this._childFromItem;
        }
        this._fromItem = this._parent.bindSubPath(parser);
        this._childFromItem = this._fromItem != null ? this._fromItem.getQuery().createFromItem(this.getTargetType().getTable(), parser.createTableName()) : parser.getSelectQuery().createFromItem(this.getTargetType().getTable(), parser.createTableName());
        ManyToOneJoinExpr link = new ManyToOneJoinExpr(this._manyToOne.getLinkColumns(), this._fromItem, this._childFromItem);
        this._childFromItem.setJoinExpr(link);
        return this._childFromItem;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return from == this._childFromItem || this._parent.usesFrom(from, type);
    }

    public void generateMatchArgWhere(CharBuffer cb) {
        String table = this._fromItem != null ? this._fromItem.getName() : this._parent.getChildFromItem().getName();
        cb.append(this._manyToOne.getLinkColumns().generateMatchArgSQL(table));
    }

    public String toString() {
        return this._parent + "." + this.getField();
    }

    public int hashCode() {
        return 65521 * this._parent.hashCode() + this.getField().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        KeyManyToOneExpr manyToOne = (KeyManyToOneExpr)o;
        return this._parent.equals(manyToOne._parent) && this.getField().equals(manyToOne.getField());
    }
}

