/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.QueryParser;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class OrExpr
extends AbstractAmberExpr {
    private ArrayList<AmberExpr> _components = new ArrayList();

    public boolean isBoolean() {
        return true;
    }

    public void add(AmberExpr expr) throws QueryParseException {
        this._components.add(expr.createBoolean());
    }

    public AmberExpr bindSelect(QueryParser parser) {
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            expr = expr.bindSelect(parser);
            this._components.set(i, expr);
        }
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (type == 1) {
            for (int i = 0; i < this._components.size(); ++i) {
                AmberExpr expr = this._components.get(i);
                if (!isNot && !expr.usesFrom(from, type, isNot)) {
                    return false;
                }
                if (!isNot || !expr.usesFrom(from, type, isNot)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            if (!expr.usesFrom(from, type)) continue;
            return true;
        }
        return false;
    }

    public AmberExpr replaceJoin(JoinExpr join) {
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            expr = expr.replaceJoin(join);
            this._components.set(i, expr);
        }
        return this;
    }

    AmberExpr getSingle() {
        if (this._components.size() == 0) {
            return null;
        }
        if (this._components.size() == 1) {
            return this._components.get(0);
        }
        return this;
    }

    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public void generateJoin(CharBuffer cb) {
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" OR ");
            }
            AmberExpr expr = this._components.get(i);
            expr.generateJoin(cb);
        }
        cb.append(')');
    }

    public String toString() {
        if (this._components.size() == 1) {
            return this._components.get(0).toString();
        }
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" OR ");
            }
            AmberExpr expr = this._components.get(i);
            cb.append((Object)expr);
        }
        cb.append(')');
        return cb.toString();
    }

    public void setInternalArgType(AmberExpr other) {
        for (int i = 0; i < this._components.size(); ++i) {
            this._components.get(i).setInternalArgType(other);
        }
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" OR ");
            }
            AmberExpr expr = this._components.get(i);
            if (select) {
                expr.generateWhere(cb);
                continue;
            }
            expr.generateUpdateWhere(cb);
        }
        cb.append(')');
    }
}

