/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeId
extends Id {
    private static final L10N L = new L10N(CompositeId.class);
    protected static final Logger log = Log.open(CompositeId.class);
    private JClass _keyClass;

    public CompositeId(EntityType ownerType, ArrayList<IdField> keys) {
        super(ownerType, keys);
    }

    protected CompositeId(EntityType ownerType) {
        super(ownerType);
    }

    public void setKeyClass(JClass keyClass) {
        this._keyClass = keyClass;
        this.getOwnerType().addDependency(keyClass);
    }

    @Override
    public String getForeignTypeName() {
        if (this._keyClass != null) {
            return this._keyClass.getName();
        }
        if (this.isEmbeddedId()) {
            return this.getEmbeddedIdField().getJavaTypeName();
        }
        return this.getOwnerType().getName();
    }

    public String getForeignMakeKeyName() {
        return this.getOwnerType().getName().replace('.', '_').replace('/', '_');
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        this.generatePrologue(out, completedSet, this.getForeignMakeKeyName());
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet, String name) throws IOException {
        out.println();
        out.println("private transient " + this.getForeignTypeName() + " __caucho_compound_key = new " + this.getForeignTypeName() + "();");
        this.generatePrologueMake(out, completedSet);
        this.generatePrologueLoad(out, completedSet);
    }

    public void generatePrologueMake(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        int i;
        String makeName = "__caucho_make_key_" + this.getForeignMakeKeyName();
        if (completedSet.contains(makeName)) {
            return;
        }
        completedSet.add(makeName);
        out.println();
        out.print("private static ");
        out.print(this.getForeignTypeName() + " " + makeName);
        out.print("(");
        if (!this.isEmbeddedId()) {
            ArrayList<IdField> keys = this.getKeys();
            for (i = 0; i < keys.size(); ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                IdField key = keys.get(i);
                out.print(key.getJavaTypeName() + " a" + i);
            }
        } else {
            EmbeddableType embeddable = (EmbeddableType)this.getEmbeddedIdField().getType();
            ArrayList<AmberField> fields = embeddable.getFields();
            for (int i2 = 0; i2 < fields.size(); ++i2) {
                if (i2 != 0) {
                    out.print(", ");
                }
                AmberField field = fields.get(i2);
                out.print(field.getJavaTypeName() + " a" + i2);
            }
        }
        out.println(")");
        out.println("{");
        out.pushDepth();
        out.println();
        out.println(this.getForeignTypeName() + " key = new " + this.getForeignTypeName() + "();");
        if (this.getOwnerType().getPersistenceUnit().isJPA() && !this.isEmbeddedId()) {
            String args = "";
            ArrayList<IdField> keys = this.getKeys();
            for (int i3 = 0; i3 < keys.size(); ++i3) {
                KeyPropertyField key = (KeyPropertyField)keys.get(i3);
                String name = key.getName();
                char ch = Character.toUpperCase(name.charAt(0));
                name = name.length() == 1 ? "get" + ch : "get" + ch + key.getName().substring(1);
                JMethod method = BeanType.getGetter(this._keyClass, name);
                if (key.isKeyField() || method != null) {
                    out.println(key.generateSetKeyProperty("key", "a" + i3) + ";");
                    continue;
                }
                if (i3 != 0) {
                    args = args + ", ";
                }
                args = args + " a" + i3;
                out.println("if (a" + i3 + " == null)");
                out.println("  return new " + this.getForeignTypeName() + "();");
                if (i3 + 1 != keys.size()) continue;
                out.print("key = new " + this.getForeignTypeName() + "(" + args + ");");
            }
        } else {
            ArrayList<AmberField> fields;
            if (this.getEmbeddedIdField() == null) {
                fields = this.getKeys();
            } else {
                EmbeddableType embeddable = (EmbeddableType)this.getEmbeddedIdField().getType();
                fields = embeddable.getFields();
            }
            for (i = 0; i < fields.size(); ++i) {
                AmberField field = fields.get(i);
                if (this.getOwnerType().isFieldAccess()) {
                    out.println(field.generateSet("key", "a" + i) + ";");
                    continue;
                }
                String setter = field.getName();
                if (this.getOwnerType().getPersistenceUnit().isJPA()) {
                    setter = "set" + Character.toUpperCase(setter.charAt(0)) + (setter.length() == 1 ? "" : setter.substring(1));
                    out.println("key." + setter + "(a" + i + ");");
                    continue;
                }
                out.println("key." + setter + " = a" + i + ";");
            }
        }
        out.println("return key;");
        out.popDepth();
        out.println("}");
    }

    public void generatePrologueLoad(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        IdField key;
        int i;
        String loadName = "__caucho_load_key_" + this.getForeignMakeKeyName();
        if (completedSet.contains(loadName)) {
            return;
        }
        completedSet.add(loadName);
        out.println();
        out.print("private static ");
        out.print(this.getForeignTypeName() + " " + loadName);
        out.println("(com.caucho.amber.manager.AmberConnection aConn, java.sql.ResultSet rs, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        int index = 0;
        ArrayList<IdField> keys = this.getKeys();
        for (i = 0; i < keys.size(); ++i) {
            key = keys.get(i);
            String javaType = key.getJavaTypeName();
            out.print(javaType + " a" + i + " = (" + javaType + ") ");
            index = key.getType().generateLoad(out, "rs", "index", index);
            out.println(";");
            out.println("if (rs.wasNull())");
            out.println("  return null;");
        }
        out.print(this.getForeignTypeName() + " key = new " + this.getForeignTypeName() + "(");
        if (this.isEmbeddedId() || !this.getOwnerType().getPersistenceUnit().isJPA()) {
            out.println(");");
            for (i = 0; i < keys.size(); ++i) {
                out.println(keys.get(i).generateSetKeyProperty("key", "a" + i) + ";");
            }
        } else {
            for (i = 0; i < keys.size(); ++i) {
                key = (KeyPropertyField)keys.get(i);
                String name = ((AbstractField)((Object)key)).getName();
                char ch = Character.toUpperCase(name.charAt(0));
                name = name.length() == 1 ? "get" + ch : "get" + ch + ((AbstractField)((Object)key)).getName().substring(1);
                JMethod method = BeanType.getGetter(this._keyClass, name);
                if (((KeyPropertyField)key).isKeyField() || method != null) {
                    if (i == 0) {
                        out.println(");");
                    }
                    out.println(((KeyPropertyField)key).generateSetKeyProperty("key", "a" + i) + ";");
                    continue;
                }
                if (i != 0) {
                    out.print(", ");
                }
                out.print(" a" + i);
                if (i + 1 != keys.size()) continue;
                out.println(");");
            }
        }
        out.println("return key;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        out.print("__caucho_load_key_" + this.getForeignMakeKeyName());
        out.print("(aConn, " + rs + ", " + indexVar + " + " + index + ")");
        ArrayList<IdField> keys = this.getKeys();
        return index += keys.size();
    }

    @Override
    public String generateSelect(String id) {
        ArrayList<IdField> keys = this.getKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateSelect(id));
        }
        return cb.close();
    }

    @Override
    public String generateJavaSelect(String id) {
        ArrayList<IdField> keys = this.getKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateJavaSelect(id));
        }
        return cb.close();
    }

    @Override
    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public String generateGet(String value) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("__caucho_make_key_" + this.getForeignMakeKeyName());
        cb.append("(");
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateGet(value));
        }
        cb.append(")");
        return cb.close();
    }

    @Override
    public void generateSet(JavaWriter out, String objThis, String value) throws IOException {
        out.println("if (" + value + " != null) {");
        out.pushDepth();
        AmberPersistenceUnit persistenceUnit = this.getOwnerType().getPersistenceUnit();
        if (persistenceUnit.isJPA() && !this.isEmbeddedId()) {
            EmbeddableType embeddable = persistenceUnit.getEmbeddable(this._keyClass.getName());
            ArrayList<AmberField> keys = embeddable.getFields();
            for (int i = 0; i < keys.size(); ++i) {
                PropertyField key = (PropertyField)keys.get(i);
                String getter = "__caucho_get_field(" + i + ")";
                String subValue = "((com.caucho.amber.entity.Embeddable) key)." + getter;
                out.println("Object field" + i + " = " + subValue + ";");
                out.println("if (field" + i + " == null)");
                out.println("  return;");
                KeyPropertyField prop = null;
                Column column = key.getColumn();
                ArrayList<IdField> fields = this.getKeys();
                for (int j = 0; j < fields.size(); ++j) {
                    IdField id = fields.get(j);
                    if (!id.getName().equals(key.getName()) || !(id instanceof KeyPropertyField)) continue;
                    prop = (KeyPropertyField)id;
                }
                if (prop != null) {
                    key = prop;
                }
                Type columnType = key.getColumn().getType();
                value = columnType.generateCastFromObject("field" + i);
                key.generateSet(out, objThis, value);
            }
        } else {
            out.println(this.getForeignTypeName() + " " + value + "_key = (" + this.getForeignTypeName() + ") " + value + ";");
            if (this.getEmbeddedIdField() == null) {
                ArrayList<IdField> keys = this.getKeys();
                for (int i = 0; i < keys.size(); ++i) {
                    IdField key = keys.get(i);
                    key.generateSet(out, objThis, key.generateGetKeyProperty(objThis + "_key"));
                }
            } else {
                this.getEmbeddedIdField().generateSet(out, objThis, value + "_key");
            }
        }
        out.popDepth();
        out.println("}");
    }

    public String generateGetProxyProperty(String value) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("__caucho_make_key_" + this.getForeignMakeKeyName());
        cb.append("(");
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateGetProxyProperty(value));
        }
        cb.append(")");
        return cb.close();
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateLoadFromObject(out, obj);
        }
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateUpdateFromObject(out, obj);
        }
    }

    public String generateWhere(String id) {
        ArrayList<IdField> keys = this.getKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(" and ");
            }
            cb.append(keys.get(i).generateWhere(id));
        }
        return cb.close();
    }

    @Override
    public String generateCreateTableSQL(AmberPersistenceUnit manager) {
        return null;
    }

    @Override
    public void generateSetKey(JavaWriter out, String pstmt, String obj, String index) throws IOException {
        this.generateSet(out, pstmt, obj, index);
    }

    @Override
    public String generateCastFromObject(String value) {
        return value;
    }

    @Override
    public void generateMatch(JavaWriter out, String key) throws IOException {
        out.println("return __caucho_getPrimaryKey().equals(" + key + ");");
    }

    @Override
    public String generateEquals(String leftBase, String value) {
        return leftBase + ".equals(" + value + ")";
    }

    @Override
    public void generateCheckCreateKey(JavaWriter out) throws IOException {
    }

    @Override
    public String toObject(String value) {
        return value;
    }
}

