/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.EmbeddedExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.EmbeddedIdField;
import com.caucho.amber.field.EmbeddedSubField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityEmbeddedField
extends AbstractField {
    private static final L10N L = new L10N(EntityEmbeddedField.class);
    protected static final Logger log = Logger.getLogger(EntityEmbeddedField.class.getName());
    private EmbeddableType _embeddableType;
    private ArrayList<EmbeddedSubField> _subFields;
    private boolean _isInsert = true;
    private boolean _isUpdate = true;

    public EntityEmbeddedField(EntityType ownerType, EmbeddableType embeddableType, String name) throws ConfigException {
        super(ownerType, name);
        this.setEmbeddableType(embeddableType);
    }

    public EntityEmbeddedField(EntityType ownerType, EmbeddableType embeddableType) {
        super(ownerType);
        this.setEmbeddableType(embeddableType);
    }

    public EmbeddableType getEmbeddableType() {
        return this._embeddableType;
    }

    public void setEmbeddableType(EmbeddableType type) {
        this._embeddableType = type;
        this._subFields = new ArrayList();
        ArrayList<AmberField> fields = type.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            this._subFields.add(this.createSubField(fields.get(i), i));
        }
    }

    protected EmbeddedSubField createSubField(AmberField field, int index) {
        return new EmbeddedSubField(this, field, index);
    }

    public Type getType() {
        return this._embeddableType;
    }

    public ArrayList<EmbeddedSubField> getSubFields() {
        return this._subFields;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    public void setInsert(boolean isInsert) {
        this._isInsert = isInsert;
    }

    public void setUpdate(boolean isUpdate) {
        this._isUpdate = isUpdate;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
    }

    @Override
    public String generateNull() {
        return this.getType().generateNull();
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null) {
            return;
        }
        out.println();
        out.println("public " + this.getJavaTypeName() + " " + this.getGetterName() + "()");
        out.println("{");
        out.pushDepth();
        if (!(this instanceof EmbeddedIdField)) {
            out.println("if (__caucho_session != null)");
            out.println("  __caucho_load_" + this.getLoadGroupIndex() + "(__caucho_session);");
            out.println();
        }
        out.println("return " + this.generateSuperGetter("this") + ";");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && (this.getGetterMethod() == null || this.getSetterMethod() == null && !this.isAbstract())) {
            return;
        }
        out.println();
        out.println("public void " + this.getSetterName() + "(" + this.getJavaTypeName() + " v)");
        out.println("{");
        out.pushDepth();
        if (!this._isUpdate) {
            out.println("if (__caucho_session == null)");
            out.println("  " + this.generateSuperSetter("this", "v") + ";");
        } else {
            out.println(this.getJavaTypeName() + " oldValue = " + this.generateSuperGetter("this") + ";");
            int maskGroup = this.getLoadGroupIndex() / 64;
            String loadVar = "__caucho_loadMask_" + maskGroup;
            long mask = 1L << this.getLoadGroupIndex() % 64;
            if (this.getJavaTypeName().equals("java.lang.String")) {
                out.println("if ((oldValue == v || v != null && v.equals(oldValue)) && (" + loadVar + " & " + mask + "L) != 0L)");
                out.println("  return;");
            } else {
                out.println("if (oldValue == v && (" + loadVar + " & " + mask + "L) != 0)");
                out.println("  return;");
            }
            out.println(this.generateSuperSetter("this", "v") + ";");
            int dirtyGroup = this.getIndex() / 64;
            String dirtyVar = "__caucho_dirtyMask_" + dirtyGroup;
            long dirtyMask = 1L << this.getIndex() % 64;
            out.println();
            out.println("long oldMask = " + dirtyVar + ";");
            out.println(dirtyVar + " |= " + dirtyMask + "L;");
            out.println();
            out.println("if (__caucho_session != null && oldMask == 0)");
            out.println("  __caucho_session.update(this);");
        }
        out.popDepth();
        out.println("}");
    }

    public void generateCopy(JavaWriter out, String dest, String source) throws IOException {
        String value = this.generateGet(source);
        out.println(this.generateSet(dest, value) + ";");
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        if (this.getTable() != table) {
            return null;
        }
        return this.generateSelect(id);
    }

    @Override
    public String generateSelect(String id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._subFields.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._subFields.get(i).generateSelect(id));
        }
        return sb.toString();
    }

    @Override
    public String generateWhere(String id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._subFields.size(); ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(this._subFields.get(i).generateWhere(id));
        }
        return sb.toString();
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
        if (this._isInsert) {
            for (int i = 0; i < this._subFields.size(); ++i) {
                this._subFields.get(i).generateInsertColumns(columns);
            }
        }
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        if (this._isUpdate) {
            boolean isFirst = true;
            for (int i = 0; i < this._subFields.size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                this._subFields.get(i).generateUpdate(sql);
            }
        }
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._isInsert) {
            this.generateStatementSet(out, pstmt, index, obj);
        } else if (this.getLoadGroupIndex() != 0) {
            int groupIndex = this.getLoadGroupIndex();
            int group = groupIndex / 64;
            long groupMask = 1L << groupIndex % 64;
            out.println("__caucho_loadMask_" + group + " &= ~" + groupMask + "L;");
        }
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._isUpdate) {
            this.generateStatementSet(out, pstmt, index, obj);
        }
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null) {
            return;
        }
        for (int i = 0; i < this._subFields.size(); ++i) {
        }
    }

    public void generateGetPrimaryKey(CharBuffer cb) {
        if (!this.isFieldAccess() && this.getGetterMethod() == null) {
            return;
        }
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        String value = this._embeddableType.getJavaTypeName() + ".__caucho_make(aConn, rs, " + indexVar + " + " + index + ")";
        out.println(this.generateSuperSetter("this", value) + ";");
        return index += this._subFields.size();
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new EmbeddedExpr(parent, this._embeddableType, this._subFields);
    }
}

