/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.OneToManyExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.CollectionField;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.CascadeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityOneToManyField
extends CollectionField {
    private static final L10N L = new L10N(EntityOneToManyField.class);
    private static final Logger log = Logger.getLogger(EntityOneToManyField.class.getName());
    private String _mapKey;
    private ArrayList<String> _orderByFields;
    private ArrayList<Boolean> _orderByAscending;
    private EntityManyToOneField _sourceField;

    public EntityOneToManyField(EntityType entityType, String name, CascadeType[] cascadeTypes) throws ConfigException {
        super(entityType, name, cascadeTypes);
    }

    public EntityOneToManyField(EntityType entityType, String name) throws ConfigException {
        this(entityType, name, null);
    }

    public EntityOneToManyField(EntityType entityType) {
        super(entityType);
    }

    public void setOrderBy(ArrayList<String> orderByFields, ArrayList<Boolean> orderByAscending) {
        this._orderByFields = orderByFields;
        this._orderByAscending = orderByAscending;
    }

    @Override
    public EntityType getEntitySourceType() {
        return (EntityType)this.getSourceType();
    }

    public EntityType getEntityTargetType() {
        return (EntityType)this.getTargetType();
    }

    @Override
    public Type getTargetType() {
        return this._sourceField.getSourceType();
    }

    public EntityManyToOneField getSourceField() {
        return this._sourceField;
    }

    public void setSourceField(EntityManyToOneField sourceField) {
        this._sourceField = sourceField;
    }

    @Override
    public LinkColumns getLinkColumns() {
        return this._sourceField.getLinkColumns();
    }

    public String getMapKey() {
        return this._mapKey;
    }

    public void setMapKey(String mapKey) {
        this._mapKey = mapKey;
    }

    @Override
    public void init() {
        if (this._sourceField == null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new OneToManyExpr(parser, parent, this.getLinkColumns());
    }

    @Override
    public void generatePreCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (cascadeType == CascadeType.PERSIST) {
            return;
        }
        this.generateInternalCascade(out, aConn, cascadeType);
    }

    @Override
    public void generatePostCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (cascadeType != CascadeType.PERSIST) {
            return;
        }
        this.generateInternalCascade(out, aConn, cascadeType);
    }

    @Override
    protected void generateInternalCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (this.isCascade(cascadeType)) {
            String getter = "_caucho_field_" + this.getGetterName();
            out.println("if (" + getter + " == null && " + this.generateSuperGetter("this") + " != null)");
            out.pushDepth();
            out.println(this.getSetterName() + "(" + this.generateSuperGetter("this") + ");");
            out.popDepth();
            out.println();
            out.println("if (" + getter + " != null) {");
            out.pushDepth();
            out.print("for (Object o : " + getter);
            if (this.getJavaType().isAssignableTo(Map.class)) {
                out.print(".values()");
            }
            out.println(") {");
            out.pushDepth();
            out.println("if (o == null)");
            out.println("  continue;");
            if (this._sourceField != null) {
                String typeName = this.getEntityTargetType().getJavaTypeName();
                String setter = this._sourceField.getSetterName();
                out.println("((" + typeName + ") o)." + setter + "(this);");
            }
            out.print(aConn + ".");
            switch (cascadeType) {
                case PERSIST: {
                    out.print("persistFromCascade");
                    break;
                }
                case MERGE: {
                    out.print("merge");
                    break;
                }
                case REMOVE: {
                    out.print("remove");
                    break;
                }
                case REFRESH: {
                    out.print("refresh");
                }
            }
            out.println("(o);");
            out.popDepth();
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
    }

    @Override
    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public int generatePostLoadSelect(JavaWriter out, int index) throws IOException {
        if (!this.isLazy()) {
            out.println(this.getGetterName() + "();");
            return ++index;
        }
        return index;
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
    }

    @Override
    public String generateTargetSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        Id key = this.getEntityTargetType().getId();
        cb.append(key.generateSelect(id));
        String value = this.getEntityTargetType().generateLoadSelect(id);
        if (cb.length() > 0 && value.length() > 0) {
            cb.append(", ");
        }
        cb.append(value);
        return cb.close();
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        JType type;
        JType[] paramArgs;
        String var = "_caucho_field_" + this.getGetterName();
        boolean isSet = this.getJavaType().isAssignableTo(Set.class);
        boolean isMap = false;
        if (!isSet) {
            isMap = this.getJavaType().isAssignableTo(Map.class);
        }
        JType param = (paramArgs = (type = this.getJavaType()).getActualTypeArguments()).length > 0 ? paramArgs[0] : null;
        JType param2 = paramArgs.length > 1 ? paramArgs[1] : null;
        out.print("protected transient ");
        String collectionImpl = isSet ? "com.caucho.amber.collection.SetImpl" : (isMap ? "com.caucho.amber.collection.MapImpl" : "com.caucho.amber.collection.CollectionImpl");
        out.print(collectionImpl);
        if (param != null) {
            out.print("<");
            out.print(param.getPrintName());
            if (isMap && param2 != null) {
                out.print(", ");
                out.print(param2.getPrintName());
            }
            out.print(">");
        }
        out.println(" " + var + ";");
        out.println();
        out.println("public " + this.getJavaTypeName() + " " + this.getGetterName() + "()");
        out.println("{");
        out.pushDepth();
        out.println("if (" + var + " != null) {");
        out.pushDepth();
        out.println("if (__caucho_state.isPersist()) {");
        out.pushDepth();
        out.println(var + ".setSession(__caucho_session);");
        out.println("return " + var + ";");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("if (" + var + ".getSession() != null");
        out.println("    && " + var + ".getSession() == __caucho_session)");
        out.println("  return " + var + ";");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("com.caucho.amber.AmberQuery query = null;");
        String newEmptyCollection = "new " + collectionImpl;
        if (param != null) {
            newEmptyCollection = newEmptyCollection + "<" + param.getPrintName();
            if (isMap) {
                newEmptyCollection = newEmptyCollection + ", ";
                newEmptyCollection = newEmptyCollection + param2.getPrintName();
            }
            newEmptyCollection = newEmptyCollection + ">";
        }
        newEmptyCollection = newEmptyCollection + "(query";
        if (isMap) {
            newEmptyCollection = newEmptyCollection + "," + this.getEntityTargetType().getBeanClass().getName();
            newEmptyCollection = newEmptyCollection + ".class.getDeclaredMethod(\"";
            String getterMapKey = this.getMapKey();
            getterMapKey = getterMapKey == null ? this.getEntityTargetType().getId().generateGet("this") : "get" + Character.toUpperCase(getterMapKey.charAt(0)) + getterMapKey.substring(1);
            newEmptyCollection = newEmptyCollection + getterMapKey;
            newEmptyCollection = newEmptyCollection + "\", (Class []) null)";
        }
        newEmptyCollection = newEmptyCollection + ")";
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("if (__caucho_session == null) {");
        out.pushDepth();
        out.println("return " + this.generateSuperGetter("this") + ";");
        out.popDepth();
        out.println("}");
        out.println();
        out.print("String sql=\"");
        out.print("SELECT c");
        out.print(" FROM " + this.getEntitySourceType().getName() + " o,");
        out.print("      o." + this.getName() + " c");
        out.print(" WHERE ");
        out.print(this.getEntitySourceType().getId().generateRawWhere("o"));
        if (this._orderByFields != null) {
            out.print(" ORDER BY ");
            for (int i = 0; i < this._orderByFields.size(); ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print("c." + this._orderByFields.get(i));
                if (!Boolean.FALSE.equals(this._orderByAscending.get(i))) continue;
                out.print(" DESC");
            }
        }
        out.println("\";");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getEntitySourceType().getId().generateSet(out, "query", "index", "this");
        out.print(var);
        out.print(" = " + newEmptyCollection + ";");
        if (this.getEntitySourceType().getPersistenceUnit().isJPA()) {
            out.println();
            out.print("for (Object o : " + var);
            if (this.getJavaType().isAssignableTo(Map.class)) {
                out.print(".values()");
            }
            out.println(")");
        }
        out.println(this.generateSuperSetter("this", var) + ";");
        out.println();
        out.println("return " + var + ";");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateSize(JavaWriter out) throws IOException {
        out.println("public int size()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session == null || isValid())");
        out.println("  return super.size();");
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flushNoChecks();");
        out.print("String sql=\"");
        out.print("SELECT count(*) FROM ");
        out.print(this.getEntitySourceType().getName());
        out.print(" AS o ");
        out.print(" WHERE ");
        ArrayList<IdField> keys = this.getEntitySourceType().getId().getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                out.print(" AND ");
            }
            out.print("o." + keys.get(i).getName());
            out.print("=?");
        }
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getEntitySourceType().getId().generateSet(out, "query", "index", this.getEntitySourceType().getInstanceClassName() + ".this");
        out.println("java.sql.ResultSet rs = query.executeQuery();");
        out.println("if (rs.next())");
        out.println("  return rs.getInt(1);");
        out.println("else");
        out.println("  return 0;");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
        JType param2;
        JType[] paramArgs;
        JType type;
        if (!this.getEntitySourceType().isFieldAccess()) {
            type = this.getGetterMethod().getGenericReturnType();
        } else {
            JField field = EntityType.getField(this.getBeanClass(), this.getName());
            type = field.getGenericType();
        }
        out.println();
        out.print("public void " + this.getSetterName() + "(");
        out.print(type.getName() + " value)");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session == null) {");
        out.pushDepth();
        out.println(this.generateSuperSetter("this", "value") + ";");
        out.popDepth();
        out.println("} else {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        String var = "_caucho_field_" + this.getGetterName();
        out.print(var + " = new ");
        type = this.getJavaType();
        boolean isSet = type.isAssignableTo(Set.class);
        boolean isMap = false;
        if (!isSet) {
            isMap = type.isAssignableTo(Map.class);
        }
        JType param = (paramArgs = type.getActualTypeArguments()).length > 0 ? paramArgs[0] : null;
        JType jType = param2 = paramArgs.length > 1 ? paramArgs[1] : null;
        String collectionImpl = isSet ? "com.caucho.amber.collection.SetImpl" : (isMap ? "com.caucho.amber.collection.MapImpl" : "com.caucho.amber.collection.CollectionImpl");
        out.print(collectionImpl);
        if (param != null) {
            out.print("<");
            out.print(param.getPrintName());
            if (isMap && param2 != null) {
                out.print(", ");
                out.print(param2.getPrintName());
            }
            out.print(">");
        }
        out.print("(__caucho_session, null");
        if (isMap) {
            out.print(", ");
            out.print(this.getEntityTargetType().getBeanClass().getName());
            out.print(".class.getDeclaredMethod(\"");
            String getterMapKey = this.getMapKey();
            getterMapKey = getterMapKey == null ? this.getEntityTargetType().getId().getKey().getGetterName() : "get" + Character.toUpperCase(getterMapKey.charAt(0)) + getterMapKey.substring(1);
            out.print(getterMapKey);
            out.print("\")");
        }
        out.println(");");
        out.print(var + ".");
        if (isMap) {
            out.println("putAll(value);");
        } else if (isSet) {
            out.println("addAll(value);");
        } else {
            out.println("addAll(0, value);");
        }
        out.popDepth();
        out.println("} catch(Exception e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        if (this.getEntitySourceType().getPersistenceUnit().isJPA()) {
            return;
        }
        Table table = this.getLinkColumns().getSourceTable();
        out.println("if (\"" + table.getName() + "\".equals(table)) {");
        out.pushDepth();
        String var = "_caucho_field_" + this.getGetterName();
        out.println("if (" + var + " != null)");
        out.println("  " + var + ".update();");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
        String var = "_caucho_field_" + this.getGetterName();
        out.println(var + " = null;");
    }
}

