/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.cfg.AbstractConfigIntrospector;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.ColumnExpr;
import com.caucho.amber.expr.EmbeddedExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.ArrayType;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyField
extends AbstractField {
    private static final L10N L = new L10N(PropertyField.class);
    private static final Logger log = Logger.getLogger(PropertyField.class.getName());
    private Column _column;
    private Type _type;
    private KeyManyToOneField _aliasKey;
    private boolean _isInsert = true;
    private boolean _isUpdate = true;

    public PropertyField(BeanType statefulType, String name) throws ConfigException {
        super(statefulType, name);
    }

    public PropertyField(BeanType statefulType) {
        super(statefulType);
    }

    public void setType(Type type) {
        this._type = type;
    }

    public Type getType() {
        return this._type;
    }

    public EntityType getRelatedSourceType() {
        return (EntityType)this.getSourceType();
    }

    @Override
    public Table getTable() {
        return this.getColumn().getTable();
    }

    @Override
    public void setColumn(Column column) {
        this._column = column;
    }

    @Override
    public Column getColumn() {
        return this._column;
    }

    public void setInsert(boolean isInsert) {
        this._isInsert = isInsert;
    }

    public boolean isInsert() {
        return this._isInsert;
    }

    public void setUpdate(boolean isUpdate) {
        this._isUpdate = isUpdate;
    }

    public boolean isUpdate() {
        return this._isUpdate;
    }

    @Override
    public AmberField override(BeanType type) {
        PropertyField field = new PropertyField(this.getSourceType(), this.getName());
        field.setOverride(true);
        field.setLazy(this.isLazy());
        field.setInsert(this._isInsert);
        field.setUpdate(this._isUpdate);
        return field;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        if (this.getColumn() == null) {
            throw new IllegalStateException(L.l("column must be set before init"));
        }
        if (!(this.getSourceType() instanceof EntityType)) {
            return;
        }
        if (this.getRelatedSourceType().getId() != null) {
            for (IdField field : this.getRelatedSourceType().getId().getKeys()) {
                if (!(field instanceof KeyManyToOneField)) continue;
                KeyManyToOneField key = (KeyManyToOneField)field;
                for (ForeignColumn column : key.getLinkColumns().getColumns()) {
                    if (!this.getColumn().getName().equals(column.getName())) continue;
                    this._aliasKey = key;
                }
            }
        }
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null) {
            return;
        }
        out.println();
        out.println("public " + this.getJavaTypeName() + " " + this.getGetterName() + "()");
        out.println("{");
        out.pushDepth();
        if (!(this.getSourceType() instanceof EmbeddableType)) {
            out.println("if (__caucho_session != null)");
            out.println("  __caucho_load_select_" + this.getLoadGroupIndex() + "(__caucho_session);");
            out.println();
        }
        out.println("return " + this.generateSuperGetter("this") + ";");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && (this.getGetterMethod() == null || this.getSetterMethod() == null && !this.isAbstract())) {
            return;
        }
        out.println();
        out.println("public void " + this.getSetterName() + "(" + this.getJavaTypeName() + " v)");
        out.println("{");
        out.pushDepth();
        int maskGroup = this.getLoadGroupIndex() / 64;
        String loadVar = "__caucho_loadMask_" + maskGroup;
        long mask = 1L << this.getLoadGroupIndex() % 64;
        if (!this._isUpdate || this.getSourceType() instanceof EmbeddableType) {
            out.println(this.generateSuperSetter("this", "v") + ";");
            out.popDepth();
            out.println("}");
            return;
        }
        out.println("if (__caucho_session == null) {");
        out.println("  " + this.generateSuperSetter("this", "v") + ";");
        out.println("  return;");
        out.println("}");
        out.println();
        out.println("if ((" + loadVar + " & " + mask + "L) == 0) {");
        out.println("  __caucho_load_" + maskGroup + "(__caucho_session);");
        out.println("}");
        out.println();
        out.println(this.getJavaTypeName() + " oldValue = " + this.generateSuperGetter("this") + ";");
        out.println();
        if (this.getJavaTypeName().equals("java.lang.String")) {
            out.println("if ((oldValue == v || v != null && v.equals(oldValue)) && (" + loadVar + " & " + mask + "L) != 0L)");
            out.println("  return;");
        } else {
            out.println("if (oldValue == v && (" + loadVar + " & " + mask + "L) != 0)");
            out.println("  return;");
        }
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println(this.generateSuperSetter("this", "v") + ";");
        out.popDepth();
        out.println("} catch (Exception e1) {");
        out.pushDepth();
        out.println("throw __caucho_session.rollback(e1);");
        out.popDepth();
        out.println("}");
        int dirtyGroup = this.getIndex() / 64;
        String dirtyVar = "__caucho_dirtyMask_" + dirtyGroup;
        long dirtyMask = 1L << this.getIndex() % 64;
        out.println();
        out.println("long oldMask = " + dirtyVar + ";");
        out.println(dirtyVar + " |= " + dirtyMask + "L;");
        out.println();
        out.println("if (oldMask == 0)");
        out.println("  __caucho_session.update((com.caucho.amber.entity.Entity) this);");
        out.println();
        out.println("__caucho_increment_version();");
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateNull() {
        return this.getType().generateNull();
    }

    @Override
    protected String getFieldName() {
        if (this.isFieldAccess()) {
            return super.getFieldName();
        }
        if (this.getColumn() == null) {
            return "__amber_" + AbstractConfigIntrospector.toSqlName(this.getName());
        }
        return this.getColumn().getFieldName();
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        if (this.getColumn().getTable() != table && this.getRelatedSourceType() instanceof EntityType) {
            return null;
        }
        return this.generateSelect(id);
    }

    @Override
    public String generateSelect(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public String generateWhere(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
        if (this._isInsert && this._aliasKey == null) {
            columns.add(this.getColumn().getName());
        }
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        if (this._isUpdate && this._aliasKey == null) {
            sql.append(this.getColumn().generateUpdateSet());
        }
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._aliasKey == null) {
            if (this._isInsert) {
                this.generateStatementSet(out, pstmt, index, obj);
            } else if (this.getLoadGroupIndex() != 0) {
                int groupIndex = this.getLoadGroupIndex();
                int group = groupIndex / 64;
                long groupMask = 1L << groupIndex % 64;
                out.println("__caucho_loadMask_" + group + " &= ~" + groupMask + "L;");
            }
        }
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._isUpdate && this._aliasKey == null) {
            this.generateStatementSet(out, pstmt, index, obj);
        }
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null || this._aliasKey != null) {
            return;
        }
        this.getColumn().generateSet(out, pstmt, index, this.generateGet(obj));
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this._aliasKey != null) {
            return index;
        }
        String var = "amber_ld" + index;
        Type columnType = this.getColumn() == null ? this.getType() : this.getColumn().getType();
        if (columnType instanceof ArrayType) {
            out.print(((ArrayType)columnType).getPrimitiveArrayTypeName());
        } else {
            out.print(this.getJavaTypeName());
        }
        out.print(" " + var + " = ");
        index = this.getColumn() == null ? this.getType().generateLoad(out, rs, indexVar, index) : this.getColumn().generateLoad(out, rs, indexVar, index);
        out.println(";");
        if (columnType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)columnType;
            String primitiveType = arrayType.getPrimitiveArrayTypeName();
            out.print(this.getJavaTypeName() + " " + var + "_temp = null;");
            out.println();
            out.print("if (" + var + " != null) {");
            out.pushDepth();
            out.print(var + "_temp = new ");
            String instanceJavaType = arrayType.getJavaObjectTypeName();
            out.println(instanceJavaType + "[" + var + ".length];");
            out.println("for (int i=0; i < " + var + ".length; i++)");
            out.print("  " + var + "_temp[i] = new ");
            out.print(instanceJavaType);
            out.println("(" + var + "[i]);");
            out.popDepth();
            out.println("}");
            out.println();
            out.println(this.generateSuperSetter("this", var + "_temp") + ";");
        } else {
            out.println(this.generateSuperSetter("this", var) + ";");
        }
        return index;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        if (this._aliasKey != null || this.getColumn() == null) {
            return index;
        }
        String var = "amber_ld" + index;
        Type columnType = this.getColumn().getType();
        out.print(this.getJavaTypeName());
        out.print(" " + var + " = ");
        index = this.getColumn().generateLoadNative(out, index);
        out.println(";");
        out.println(this.generateSuperSetter("this", var) + ";");
        return index;
    }

    @Override
    public void generateNativeColumnNames(ArrayList<String> names) {
        if (this._aliasKey != null || this.getColumn() == null) {
            return;
        }
        this.getColumn().generateNativeColumnNames(names);
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        Column column = parent instanceof EmbeddedExpr ? ((EmbeddedExpr)parent).getColumnByFieldName(this.getName()) : this.getColumn();
        return new ColumnExpr(parent, column);
    }
}

