/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubId
extends Id {
    private static final L10N L = new L10N(SubId.class);
    private static final Logger log = Log.open(SubId.class);
    private Id _parentId;
    private LinkColumns _link;

    public SubId(EntityType ownerType, EntityType rootType) {
        super(ownerType, new ArrayList<IdField>());
        this._parentId = rootType.getId();
    }

    public ArrayList<IdField> getParentKeys() {
        return this._parentId.getKeys();
    }

    @Override
    public ArrayList<IdField> getKeys() {
        return this._parentId.getKeys();
    }

    @Override
    public String getForeignTypeName() {
        return this._parentId.getForeignTypeName();
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this._parentId.generateLoadForeign(out, rs, indexVar, index);
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        return this._parentId.generateLoadForeign(out, rs, indexVar, index, name);
    }

    @Override
    public String generateSelect(String id) {
        ArrayList<IdField> keys = this.getParentKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateSelect(id));
        }
        return cb.close();
    }

    @Override
    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public String generateGet(String value) {
        return this._parentId.generateGet(value);
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        this._parentId.generateLoadFromObject(out, obj);
    }

    @Override
    public void generateSet(JavaWriter out, String objThis, String value) throws IOException {
        this._parentId.generateSet(out, objThis, value);
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        this._parentId.generateUpdateFromObject(out, obj);
    }

    @Override
    public String generateMatchArgWhere(String id) {
        ArrayList<IdField> keys = this.getParentKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(" and ");
            }
            this.generateMatchArgWhere(cb, keys.get(i), id);
        }
        return cb.close();
    }

    private void generateMatchArgWhere(CharBuffer cb, IdField parentId, String id) {
        LinkColumns link = this.getOwnerType().getTable().getDependentIdLink();
        ArrayList<Column> columns = parentId.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (i != 0) {
                cb.append(" and ");
            }
            cb.append(id);
            cb.append('.');
            cb.append(link.getSourceColumn(column).getName());
            cb.append("=?");
        }
    }

    @Override
    public String generateCreateTableSQL(AmberPersistenceUnit manager) {
        return null;
    }

    @Override
    public void generateSetKey(JavaWriter out, String pstmt, String obj, String index) throws IOException {
        this._parentId.generateSetKey(out, pstmt, obj, index);
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
        this._parentId.generateSet(out, pstmt, obj, index);
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index) throws IOException {
        this._parentId.generateStatementSet(out, pstmt, index);
    }

    @Override
    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        this._parentId.generateSetInsert(out, pstmt, index);
    }

    @Override
    public String generateCastFromObject(String value) {
        return value;
    }

    @Override
    public void generateMatch(JavaWriter out, String key) throws IOException {
        out.println("return " + this.generateEquals("__caucho_getPrimaryKey()", key) + ";");
    }

    @Override
    public String generateEquals(String leftBase, String value) {
        return leftBase + ".equals(" + value + ")";
    }

    @Override
    public void generateCheckCreateKey(JavaWriter out) throws IOException {
    }

    @Override
    public String toObject(String value) {
        return value;
    }
}

