/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CascadableField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.VersionField;
import com.caucho.amber.gen.AmberMappedComponent;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

public class EntityComponent
extends AmberMappedComponent {
    private static final L10N L = new L10N(EntityComponent.class);

    public EntityType getEntityType() {
        return this._entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.setRelatedType(entityType);
    }

    void generateDelete(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_delete()");
        out.println("{");
        out.pushDepth();
        out.println("if (com.caucho.amber.entity.EntityState.P_DELETING.ordinal() <= __caucho_state.ordinal())");
        out.println("  return;");
        out.println();
        out.println("if (__caucho_home != null)");
        out.println("  __caucho_home.preRemove(this);");
        out.println();
        this.generateCallbacks(out, "this", this._entityType.getPreRemoveCallbacks());
        this._entityType.generatePreDelete(out);
        out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_DELETING;");
        out.println("if (__caucho_session != null) {");
        out.pushDepth();
        out.println("__caucho_session.update((com.caucho.amber.entity.Entity) this);");
        out.println("__caucho_home.getTable().beforeEntityDelete(__caucho_session, (com.caucho.amber.entity.Entity) this);");
        out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_DELETED;");
        this._entityType.generatePostDelete(out);
        out.popDepth();
        out.println("}");
        out.println("else");
        out.println("  __caucho_state = com.caucho.amber.entity.EntityState.P_DELETED;");
        out.popDepth();
        out.println("}");
        Id id = this._entityType.getId();
        out.println();
        out.println("private void __caucho_delete_int()");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        if (this._entityType.getTable() == null || id == null) {
            out.println("return;");
            out.popDepth();
            out.println("}");
            return;
        }
        out.println("java.sql.PreparedStatement pstmt = null;");
        out.println("String sql = null;");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.print("__caucho_home.delete(__caucho_session, ");
        out.print(id.toObject(id.generateGet("this")));
        out.println(");");
        out.println("__caucho_session.removeEntity((com.caucho.amber.entity.Entity) this);");
        String table = this._entityType.getTable().getName();
        String where = this._entityType.getId().generateMatchArgWhere(null);
        String sql = "delete from " + table + " where " + where;
        out.print("sql = \"");
        out.printJavaString(sql);
        out.println("\";");
        out.println();
        out.println("pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        id.generateSet(out, "pstmt", "index", "this");
        out.println();
        out.println("pstmt.executeUpdate();");
        out.println("__caucho_home.postRemove(this);");
        this.generateCallbacks(out, "this", this._entityType.getPostRemoveCallbacks());
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  if (pstmt != null)");
        out.println("    __caucho_session.closeStatement(sql);");
        out.println();
        out.println("  if (e instanceof java.sql.SQLException)");
        out.println("    throw (java.sql.SQLException) e;");
        out.println();
        out.println("  if (e instanceof RuntimeException)");
        out.println("    throw (RuntimeException) e;");
        out.println();
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    void generateFlush(JavaWriter out) throws IOException {
        int i;
        boolean isAbstract;
        out.println();
        out.println("protected void __caucho_flush_callback()");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.println("}");
        out.println();
        out.println("public boolean __caucho_flush()");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        boolean bl = isAbstract = this._entityType.getBeanClass().isAbstract() && this._entityType.getPersistenceUnit().isJPA();
        if (this._entityType.getId() == null || isAbstract) {
            out.println("return false;");
            out.popDepth();
            out.println("}");
            return;
        }
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        ArrayList<AmberField> fields = this._entityType.getFields();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            AmberField field = fields.get(i2);
            if (!field.isCascadable()) continue;
            CascadableField cascadable = (CascadableField)field;
            cascadable.generateFlushCheck(out);
            out.println();
        }
        out.println();
        out.println("if (__caucho_state == com.caucho.amber.entity.EntityState.P_DELETED) {");
        out.println("  __caucho_delete_int();");
        out.println("  return true;");
        out.println("}");
        out.println("else if (__caucho_state == com.caucho.amber.entity.EntityState.P_PERSISTING) {");
        out.println("  __caucho_create(__caucho_session, __caucho_home);");
        out.println("}");
        out.println("else if (__caucho_state == com.caucho.amber.entity.EntityState.P_PERSISTED) {");
        out.println("  __caucho_cascadePrePersist(__caucho_session);");
        out.println("}");
        out.println();
        out.println("boolean isDirty = false;");
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i3 = 0; i3 <= dirtyCount / 64; ++i3) {
            out.println("long mask_" + i3 + " = __caucho_dirtyMask_" + i3 + ";");
            out.println("__caucho_dirtyMask_" + i3 + " = 0L;");
            out.println("__caucho_updateMask_" + i3 + " |= mask_" + i3 + ";");
            out.println();
            out.println("if (mask_" + i3 + " != 0L)");
            out.println("  isDirty = true;");
        }
        out.println();
        out.println("if (isDirty) {");
        out.pushDepth();
        out.println();
        out.println("__caucho_flush_callback();");
        out.println("__caucho_home.preUpdate(this);");
        this.generateCallbacks(out, "this", this._entityType.getPreUpdateCallbacks());
        out.println("com.caucho.util.CharBuffer cb = new com.caucho.util.CharBuffer();");
        out.println("__caucho_home.generateUpdateSQLPrefix(cb);");
        out.println("boolean isFirst = true;");
        VersionField version = this._entityType.getVersionField();
        for (i = 0; i <= dirtyCount / 64; ++i) {
            if (i != 0 || version == null) {
                out.println("if (mask_" + i + " != 0L)");
                out.print("  ");
            }
            out.println("isFirst = __caucho_home.generateUpdateSQLComponent(cb, " + i + ", mask_" + i + ", isFirst);");
        }
        out.println("__caucho_home.generateUpdateSQLSuffix(cb);");
        out.println();
        out.println("java.sql.PreparedStatement pstmt = null;");
        out.println("String sql = cb.toString();");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        for (i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateUpdate(out, "mask", "pstmt", "index");
        }
        out.println();
        this._entityType.getId().generateStatementSet(out, "pstmt", "index");
        if (version != null) {
            out.println();
            version.generateStatementSet(out, "pstmt", "index");
        }
        out.println();
        out.println("int updateCount = pstmt.executeUpdate();");
        out.println();
        if (version != null) {
            out.println("if (updateCount == 0) {");
            out.println("  throw new javax.persistence.OptimisticLockException((com.caucho.amber.entity.Entity) this);");
            out.println("} else {");
            out.pushDepth();
            String value = version.generateGet("super");
            Type type = version.getColumn().getType();
            out.println(version.generateSuperSetter("this", type.generateIncrementVersion(value)) + ";");
            out.popDepth();
            out.println("}");
            out.println();
        }
        out.println("__caucho_home.postUpdate(this);");
        this.generateCallbacks(out, "this", this._entityType.getPostUpdateCallbacks());
        out.println();
        this.generateLogFine(out, " amber update");
        out.println();
        out.println("__caucho_inc_version = false;");
        out.println();
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  if (pstmt != null)");
        out.println("    __caucho_session.closeStatement(sql);");
        out.println();
        out.println("  if (e instanceof java.sql.SQLException)");
        out.println("    throw (java.sql.SQLException) e;");
        out.println();
        out.println("  if (e instanceof RuntimeException)");
        out.println("    throw (RuntimeException) e;");
        out.println();
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println("if (__caucho_state == com.caucho.amber.entity.EntityState.P_PERSISTED) {");
        out.println("  __caucho_cascadePostPersist(__caucho_session);");
        out.println("}");
        out.println();
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }
}

